/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.intake.validator;

import java.util.Map;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.apache.turbine.services.intake.validator.Constraint;
import org.apache.turbine.services.intake.validator.InitableByConstraintMap;
import org.apache.turbine.services.intake.validator.ValidationException;
import org.apache.turbine.services.intake.validator.Validator;
import org.apache.turbine.util.TurbineException;

public class DefaultValidator
implements Validator,
InitableByConstraintMap {
    protected boolean required;
    protected String requiredMessage;
    protected RE mask;
    protected String maskMessage;
    protected int minLength;
    protected String minLengthMessage;
    protected int maxLength;
    protected String maxLengthMessage;
    protected String message;

    public DefaultValidator(Map paramMap) throws TurbineException {
        this.init(paramMap);
    }

    public DefaultValidator() {
    }

    public void init(Map paramMap) throws TurbineException {
        String param;
        this.mask = null;
        this.maskMessage = null;
        this.minLength = 0;
        this.minLengthMessage = null;
        this.maxLength = 0;
        this.maxLengthMessage = null;
        Constraint constraint = (Constraint)paramMap.get("mask");
        if (constraint != null) {
            param = constraint.getValue();
            this.setMask(param);
            this.maskMessage = constraint.getMessage();
        }
        if ((constraint = (Constraint)paramMap.get("minLength")) != null) {
            param = constraint.getValue();
            this.minLength = Integer.parseInt(param);
            this.minLengthMessage = constraint.getMessage();
        }
        if ((constraint = (Constraint)paramMap.get("maxLength")) != null) {
            param = constraint.getValue();
            this.maxLength = Integer.parseInt(param);
            this.maxLengthMessage = constraint.getMessage();
        }
        if ((constraint = (Constraint)paramMap.get("required")) == null) {
            this.required = false;
        } else {
            param = constraint.getValue();
            this.required = new Boolean(param);
            this.requiredMessage = constraint.getMessage();
        }
    }

    public boolean isValid(String testValue) {
        boolean valid = false;
        try {
            this.assertValidity(testValue);
            valid = true;
        }
        catch (ValidationException ve) {
            valid = false;
        }
        return valid;
    }

    public void assertValidity(String testValue) throws ValidationException {
        this.message = null;
        if (!(this.required || this.minLength != 0 || testValue != null && testValue.length() != 0)) {
            return;
        }
        if (this.required && (testValue == null || testValue.length() == 0)) {
            this.message = this.requiredMessage;
            throw new ValidationException(this.requiredMessage);
        }
        this.doAssertValidity(testValue);
        if (this.mask != null && !this.mask.match(testValue)) {
            this.message = this.maskMessage;
            throw new ValidationException(this.maskMessage);
        }
        if (this.minLength > 0 && testValue.length() < this.minLength) {
            this.message = this.minLengthMessage;
            throw new ValidationException(this.minLengthMessage);
        }
        if (this.maxLength > 0 && testValue.length() > this.maxLength) {
            this.message = this.maxLengthMessage;
            throw new ValidationException(this.maxLengthMessage);
        }
    }

    public String getMessage() {
        if (this.message == null) {
            return "";
        }
        return this.message;
    }

    protected void doAssertValidity(String testValue) throws ValidationException {
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean v) {
        this.required = v;
    }

    public String getRequiredMessage() {
        return this.requiredMessage;
    }

    public void setRequiredMessage(String v) {
        this.requiredMessage = v;
    }

    public String getMask() {
        return this.mask.toString();
    }

    public void setMask(String v) throws TurbineException {
        try {
            this.mask = new RE(v);
        }
        catch (RESyntaxException e) {
            throw new TurbineException(e);
        }
    }

    public String getMaskMessage() {
        return this.maskMessage;
    }

    public void setMaskMessage(String v) {
        this.maskMessage = v;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public void setMinLength(int v) {
        this.minLength = v;
    }

    public String getMinLengthMessage() {
        return this.minLengthMessage;
    }

    public void setMinLengthMessage(String v) {
        this.minLengthMessage = v;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int v) {
        this.maxLength = v;
    }

    public String getMaxLengthMessage() {
        return this.maxLengthMessage;
    }

    public void setMaxLengthMessage(String v) {
        this.maxLengthMessage = v;
    }
}

