/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.velocity;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import javax.servlet.ServletConfig;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationConverter;
import org.apache.turbine.Turbine;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.pull.TurbinePull;
import org.apache.turbine.services.servlet.TurbineServlet;
import org.apache.turbine.services.template.BaseTemplateEngineService;
import org.apache.turbine.services.velocity.VelocityService;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.StringUtils;
import org.apache.turbine.util.TurbineConfig;
import org.apache.turbine.util.TurbineException;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public class TurbineVelocityService
extends BaseTemplateEngineService
implements VelocityService {
    private static final String RESOURCE_LOADER_PATH = ".resource.loader.path";
    private static final String DEFAULT_CHAR_SET = "ISO-8859-1";
    private static final String JAR_PREFIX = "jar:";
    private static final String ABSOLUTE_PREFIX = "file://";
    private Context globalContext = null;
    private boolean pullModelActive = false;
    private boolean refreshToolsPerRequest = false;

    public void init() throws InitializationException {
        ServletConfig conf = Turbine.getTurbineServletConfig();
        this.init(conf);
    }

    public void init(ServletConfig config) throws InitializationException {
        try {
            this.initVelocity();
            this.globalContext = null;
            if (TurbinePull.isRegistered()) {
                this.globalContext = TurbinePull.getGlobalContext();
                this.pullModelActive = true;
                this.refreshToolsPerRequest = TurbinePull.refreshToolsPerRequest();
            }
            if (this.globalContext == null) {
                this.globalContext = new VelocityContext();
            }
            this.registerConfiguration("vm");
            this.setInit(true);
        }
        catch (Exception e) {
            throw new InitializationException("Failed to initialize TurbineVelocityService", e);
        }
    }

    public Context getContext() {
        return new VelocityContext(this.globalContext);
    }

    public Context getContext(RunData data) {
        Context context = (Context)data.getTemplateInfo().getTemplateContext("VELOCITY_CONTEXT");
        if (context == null) {
            context = this.getContext();
            context.put("data", (Object)data);
            if (this.pullModelActive) {
                TurbinePull.populateContext(context, data);
            }
            data.getTemplateInfo().setTemplateContext("VELOCITY_CONTEXT", context);
        }
        return context;
    }

    /*
     * Loose catch block
     */
    public String handleRequest(Context context, String filename) throws TurbineException {
        String results;
        block11: {
            results = null;
            ByteArrayOutputStream bytes = null;
            bytes = new ByteArrayOutputStream();
            String charset = this.decodeRequest(context, filename, bytes);
            results = bytes.toString(charset);
            Object var7_7 = null;
            try {
                if (bytes != null) {
                    bytes.close();
                }
                break block11;
            }
            catch (IOException ignored) {}
            break block11;
            {
                catch (Exception e) {
                    TurbineVelocityService.renderingError(filename, e);
                    Object var7_8 = null;
                    try {
                        if (bytes != null) {
                            bytes.close();
                        }
                        break block11;
                    }
                    catch (IOException ignored) {}
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    if (bytes != null) {
                        bytes.close();
                    }
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return results;
    }

    public void handleRequest(Context context, String filename, OutputStream output) throws TurbineException {
        this.decodeRequest(context, filename, output);
    }

    public void handleRequest(Context context, String filename, Writer writer) throws TurbineException {
        String encoding = this.getEncoding(context);
        this.decodeRequest(context, filename, encoding, writer);
    }

    /*
     * Loose catch block
     */
    private String decodeRequest(Context context, String filename, OutputStream output) throws TurbineException {
        String charset;
        block14: {
            OutputStreamWriter writer;
            block13: {
                if (this.pullModelActive && this.refreshToolsPerRequest) {
                    TurbinePull.refreshGlobalTools();
                }
                charset = this.getCharSet(context);
                String encoding = this.getEncoding(context);
                writer = null;
                writer = new OutputStreamWriter(output, charset);
                if (encoding != null) {
                    Velocity.mergeTemplate((String)filename, (String)encoding, (Context)context, (Writer)writer);
                    break block13;
                }
                Velocity.mergeTemplate((String)filename, (Context)context, (Writer)writer);
            }
            Object var9_7 = null;
            try {
                if (writer != null) {
                    writer.flush();
                }
                break block14;
            }
            catch (Exception ignored) {}
            break block14;
            {
                catch (Exception e) {
                    TurbineVelocityService.renderingError(filename, e);
                    Object var9_8 = null;
                    try {
                        if (writer != null) {
                            writer.flush();
                        }
                        break block14;
                    }
                    catch (Exception ignored) {}
                }
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                try {
                    if (writer != null) {
                        writer.flush();
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return charset;
    }

    private String getCharSet(Context context) {
        String charset;
        Object data = context.get("data");
        if (data != null && data instanceof RunData) {
            charset = ((RunData)data).getCharSet();
            if (charset == null) {
                charset = DEFAULT_CHAR_SET;
            }
        } else {
            charset = DEFAULT_CHAR_SET;
        }
        return charset;
    }

    private String getEncoding(Context context) {
        Object data = context.get("data");
        String encoding = data != null && data instanceof RunData ? ((RunData)data).getTemplateEncoding() : null;
        return encoding;
    }

    /*
     * Loose catch block
     */
    private void decodeRequest(Context context, String filename, String encoding, Writer writer) throws TurbineException {
        block14: {
            block13: {
                if (this.pullModelActive && this.refreshToolsPerRequest) {
                    TurbinePull.refreshGlobalTools();
                }
                if (encoding != null) {
                    Velocity.mergeTemplate((String)filename, (String)encoding, (Context)context, (Writer)writer);
                    break block13;
                }
                Velocity.mergeTemplate((String)filename, (Context)context, (Writer)writer);
            }
            Object var7_5 = null;
            try {
                if (writer != null) {
                    writer.flush();
                }
                break block14;
            }
            catch (Exception ignored) {}
            break block14;
            {
                catch (Exception e) {
                    TurbineVelocityService.renderingError(filename, e);
                    Object var7_6 = null;
                    try {
                        if (writer != null) {
                            writer.flush();
                        }
                        break block14;
                    }
                    catch (Exception ignored) {}
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                try {
                    if (writer != null) {
                        writer.flush();
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private static final void renderingError(String filename, Exception e) throws TurbineException {
        String err = "Error rendering Velocity template: " + filename;
        Log.error(err + ": " + e.getMessage());
        throw new TurbineException(err, e);
    }

    private void initVelocity() throws InitializationException {
        String key;
        Configuration configuration = this.getConfiguration();
        String path = Turbine.getRealPath(configuration.getString("runtime.log", null));
        if (!StringUtils.isValid(path)) {
            String msg = "VelocityService runtime log file is misconfigured: '" + path + "' is not a valid log file";
            if (TurbineServlet.getServletConfig() instanceof TurbineConfig) {
                msg = msg + ": TurbineConfig users must use a path relative to web application root";
            }
            throw new Error(msg);
        }
        configuration.setProperty("runtime.log", (Object)path);
        Vector<String> keys = new Vector<String>();
        Iterator i = configuration.getKeys();
        while (i.hasNext()) {
            key = (String)i.next();
            if (!key.endsWith(RESOURCE_LOADER_PATH)) continue;
            keys.add(key);
        }
        Iterator i2 = ((AbstractList)keys).iterator();
        while (i2.hasNext()) {
            key = (String)i2.next();
            Vector paths = configuration.getVector(key, null);
            if (paths == null) continue;
            Velocity.clearProperty((String)key);
            configuration.clearProperty(key);
            Iterator j = ((AbstractList)paths).iterator();
            while (j.hasNext()) {
                path = (String)j.next();
                if (path.startsWith("jar:file")) {
                    String entry;
                    int ind = path.indexOf("!/");
                    if (ind >= 0) {
                        entry = path.substring(ind);
                        path = path.substring(9, ind);
                    } else {
                        entry = "!/";
                        path = path.substring(9);
                    }
                    path = "jar:file:" + Turbine.getRealPath(path) + entry;
                } else if (path.startsWith(ABSOLUTE_PREFIX)) {
                    path = path.substring(ABSOLUTE_PREFIX.length(), path.length());
                } else if (!path.startsWith(JAR_PREFIX)) {
                    path = Turbine.getRealPath(path);
                }
                configuration.addProperty(key, (Object)path);
            }
        }
        try {
            Velocity.setExtendedProperties((ExtendedProperties)ConfigurationConverter.getExtendedProperties((Configuration)configuration));
            Velocity.init();
        }
        catch (Exception e) {
            throw new InitializationException("Failed to set up TurbineVelocityService", e);
        }
    }

    public boolean templateExists(String template) {
        return Velocity.templateExists((String)template);
    }

    public void requestFinished(Context context) {
        if (this.pullModelActive) {
            TurbinePull.releaseTools(context);
        }
    }
}

