/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.parser;

import javax.servlet.http.Cookie;
import org.apache.turbine.util.CookieParser;
import org.apache.turbine.util.DynamicURI;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.parser.BaseValueParser;
import org.apache.turbine.util.pool.Recyclable;

public class DefaultCookieParser
extends BaseValueParser
implements CookieParser,
Recyclable {
    private RunData data = null;
    private DynamicURI cookiePath = null;

    public void dispose() {
        this.data = null;
        this.cookiePath = null;
        super.dispose();
    }

    public RunData getRunData() {
        return this.data;
    }

    public void setRunData(RunData data) {
        this.clear();
        String enc = data.getRequest().getCharacterEncoding();
        this.setCharacterEncoding(enc != null ? enc : "US-ASCII");
        this.cookiePath = new DynamicURI(data);
        this.cookiePath = new DynamicURI(data);
        Cookie[] cookies = data.getRequest().getCookies();
        Log.debug("Number of Cookies " + cookies.length);
        int i = 0;
        while (i < cookies.length) {
            String name = this.convert(cookies[i].getName());
            String value = cookies[i].getValue();
            Log.debug("Adding " + name + "=" + value);
            this.add(name, value);
            ++i;
        }
        this.data = data;
    }

    public DynamicURI getCookiePath() {
        return this.cookiePath;
    }

    public void setCookiePath(DynamicURI path) {
        this.cookiePath = path;
    }

    public void set(String name, String value) {
        this.set(name, value, -1);
    }

    public void set(String name, String value, int seconds_age) {
        if (this.data == null) {
            throw new IllegalStateException("RunData not available");
        }
        Cookie cookie = new Cookie(name, value);
        cookie.setMaxAge(seconds_age);
        cookie.setPath(this.cookiePath.getScriptName());
        this.data.getResponse().addCookie(cookie);
    }

    public void unset(String name) {
        this.set(name, " ", 0);
    }
}

