/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.webmacro;

import java.net.URL;
import java.util.Hashtable;
import javax.mail.MessagingException;
import org.apache.turbine.services.webmacro.TurbineWebMacro;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.mail.HtmlEmail;
import org.webmacro.servlet.WebContext;

public class WebMacroHtmlEmail
extends HtmlEmail {
    private String htmlTemplate = null;
    private String textTemplate = null;
    private Hashtable embmap = null;
    private WebContext context = null;

    public WebMacroHtmlEmail() throws MessagingException {
        this.embmap = new Hashtable();
    }

    public WebMacroHtmlEmail setHtmlTemplate(String template) {
        this.htmlTemplate = template;
        return this;
    }

    public WebMacroHtmlEmail setTextTemplate(String template) {
        this.textTemplate = template;
        return this;
    }

    public WebMacroHtmlEmail setContext(WebContext context) {
        this.context = context;
        return this;
    }

    public WebContext getContext() {
        return this.context;
    }

    public void send() throws MessagingException {
        this.context.put((Object)"mail", (Object)this);
        String htmlbody = "";
        String textbody = "";
        try {
            if (this.htmlTemplate != null) {
                htmlbody = TurbineWebMacro.handleRequest(this.context, this.htmlTemplate);
            }
            if (this.textTemplate != null) {
                textbody = TurbineWebMacro.handleRequest(this.context, this.textTemplate);
            }
        }
        catch (Exception e) {
            throw new MessagingException("Cannot parse template", e);
        }
        this.setHtmlMsg(htmlbody);
        this.setTextMsg(textbody);
        super.send();
    }

    public String embed(String surl, String name) throws MessagingException {
        String cid = "";
        try {
            URL url = new URL(surl);
            cid = super.embed(url, name);
            this.embmap.put(name, cid);
        }
        catch (Exception e) {
            Log.error("cannot embed " + surl + ": ", e);
        }
        return cid;
    }

    public String getCid(String filename) {
        String cid = (String)this.embmap.get(filename);
        return "cid:" + cid;
    }
}

