/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.cache;

import org.apache.fulcrum.cache.CachedObject;
import org.apache.fulcrum.cache.Refreshable;

public class RefreshableCachedObject
extends CachedObject {
    private long timeToLive = -1L;
    private long lastAccess = System.currentTimeMillis();

    public RefreshableCachedObject(Refreshable refreshable) {
        super(refreshable);
    }

    public RefreshableCachedObject(Refreshable refreshable, long l) {
        super(refreshable, l);
    }

    public synchronized void setTTL(long l) {
        this.timeToLive = l;
    }

    public synchronized long getTTL() {
        return this.timeToLive;
    }

    public synchronized void touch() {
        this.lastAccess = System.currentTimeMillis();
    }

    public synchronized boolean isUntouched() {
        if (this.timeToLive < 0L) {
            return false;
        }
        return this.lastAccess + this.timeToLive < System.currentTimeMillis();
    }

    public void refresh() {
        Refreshable refreshable = (Refreshable)this.getContents();
        RefreshableCachedObject refreshableCachedObject = this;
        synchronized (refreshableCachedObject) {
            refreshable.refresh();
            this.created += this.getExpires();
        }
    }
}

