/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.xmlmodel;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Strings;
import org.apache.fulcrum.intake.xmlmodel.Rule;
import org.apache.fulcrum.intake.xmlmodel.XmlGroup;
import org.xml.sax.Attributes;

public class XmlField
implements Serializable {
    private static final String DEFAULT_VALIDATOR = "org.apache.fulcrum.intake.validatore.DefaultValidator";
    private String baseClass;
    private String name;
    private String key;
    private String type;
    private String displayName;
    private String onError;
    private String multiValued;
    private XmlGroup parent;
    private List rules;
    private Map ruleMap;
    private String ifRequiredMessage;
    private String mapToObject;
    private String mapToProperty;
    private String validator;
    private static HashMap defaultOnErrors;
    private static HashMap convertHash;
    private static HashMap convertArrayHash;

    private static void populateDefaults() {
        defaultOnErrors = new HashMap(15);
        convertHash = new HashMap(15);
        convertArrayHash = new HashMap(15);
        defaultOnErrors.put("boolean", "false");
        defaultOnErrors.put("byte", "-1");
        defaultOnErrors.put("short", "-1");
        defaultOnErrors.put("int", "-1");
        defaultOnErrors.put("long", "-1");
        defaultOnErrors.put("float", "-1.0f");
        defaultOnErrors.put("double", "-1.0");
        defaultOnErrors.put("BigDecimal", "new BigDecimal(\"-1.0\")");
        convertHash.put("boolean", "getBoolean");
        convertHash.put("byte", "getByte");
        convertHash.put("short", "getShort");
        convertHash.put("int", "getInt");
        convertHash.put("long", "getLong");
        convertHash.put("float", "getFloat");
        convertHash.put("double", "getDouble");
        convertHash.put("Date", "getDate");
        convertHash.put("BigDecimal", "getBigDecimal");
        convertHash.put("boolean[]", "Boolean.valueOf(stringValue[i]).booleanValue()");
        convertArrayHash.put("byte[]", "Byte.valueOf(stringValue[i]).byteValue()");
        convertArrayHash.put("short[]", "Short.valueOf(stringValue[i]).shortValue()");
        convertArrayHash.put("int[]", "Integer.parseInt(stringValue[i])");
        convertArrayHash.put("long[]", "Long.parseLong(stringValue[i])");
        convertArrayHash.put("float[]", "Float.valueOf(stringValue[i]).floatValue()");
        convertArrayHash.put("double[]", "Double.valueOf(stringValue[i]).doubleValue()");
        convertArrayHash.put("Date[]", "FIXME!!");
        convertArrayHash.put("BigDecimal[]", "new BigDecimal(stringValue[i])");
    }

    public XmlField() {
        XmlField.populateDefaults();
        this.rules = new ArrayList();
        this.ruleMap = new HashMap();
    }

    public XmlField(String string) {
        XmlField.populateDefaults();
        this.name = string;
        this.rules = new ArrayList();
        this.ruleMap = new HashMap();
    }

    public void loadFromXML(Attributes attributes) {
        String string;
        this.setBaseClass(attributes.getValue("baseClass"));
        this.setName(attributes.getValue("name"));
        this.key = attributes.getValue("key");
        this.type = attributes.getValue("type");
        this.displayName = attributes.getValue("displayName");
        this.setMultiValued(attributes.getValue("multiValued"));
        String string2 = attributes.getValue("mapToObject");
        if (string2 != null && string2.length() != 0) {
            this.setMapToObject(string2);
        }
        if ((string = attributes.getValue("mapToProperty")) != null) {
            this.setMapToProperty(string);
        }
        this.setValidator(attributes.getValue("validator"));
    }

    public String getRawName() {
        return this.name;
    }

    public String getName() {
        return Strings.replace((String)this.name, (String)"_", (String)"");
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public String getKey() {
        return this.key;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getType() {
        return this.type;
    }

    public void setBaseClass(String string) {
        this.baseClass = string;
    }

    public String getBaseClass() {
        return this.baseClass;
    }

    public void setMultiValued(String string) {
        this.multiValued = string;
    }

    public boolean isMultiValued() {
        return this.multiValued != null && this.multiValued.equals("true");
    }

    public void setMapToObject(String string) {
        this.mapToObject = string;
    }

    public String getMapToObject() {
        return this.mapToObject;
    }

    public void setMapToProperty(String string) {
        this.mapToProperty = string;
    }

    public String getMapToProperty() {
        if (this.mapToProperty == null) {
            return this.getName();
        }
        return this.mapToProperty;
    }

    public void setValidator(String string) {
        this.validator = string;
    }

    public String getValidator() {
        return this.validator;
    }

    public String getVariable() {
        String string = this.getName().substring(0, 1).toLowerCase();
        return string + this.getName().substring(1);
    }

    public String getPPMethod() {
        String string = null;
        if (convertHash.containsKey(this.getType())) {
            string = (String)convertHash.get(this.getType());
        }
        return string;
    }

    public String getArrayConvert() {
        String string = null;
        if (convertArrayHash.containsKey(this.getType())) {
            string = (String)convertArrayHash.get(this.getType());
        }
        return string;
    }

    public void setGroup(XmlGroup xmlGroup) {
        this.parent = xmlGroup;
        if (this.mapToObject != null && this.mapToObject.length() != 0) {
            this.mapToObject = xmlGroup.getAppData().getBasePackage() + this.mapToObject;
        }
    }

    public XmlGroup getGroup() {
        return this.parent;
    }

    public String getIfRequiredMessage() {
        return this.ifRequiredMessage;
    }

    public void setIfRequiredMessage(String string) {
        this.ifRequiredMessage = string;
    }

    public Rule addRule(Attributes attributes) {
        Rule rule = new Rule();
        rule.loadFromXML(attributes);
        this.addRule(rule);
        return rule;
    }

    public void addRule(Rule rule) {
        rule.setField(this);
        this.rules.add(rule);
        this.ruleMap.put(rule.getName(), rule);
    }

    public List getRules() {
        return this.rules;
    }

    public Map getRuleMap() {
        return this.ruleMap;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" <field name=\"" + this.name + "\"");
        stringBuffer.append(" key=\"" + this.key + "\"");
        stringBuffer.append(" type=\"" + this.type + "\"");
        if (this.displayName != null) {
            stringBuffer.append(" displayName=\"" + this.displayName + "\"");
        }
        if (this.onError != null) {
            stringBuffer.append(" onError=\"" + this.onError + "\"");
        }
        if (this.mapToObject != null) {
            stringBuffer.append(" mapToObject=\"" + this.mapToObject + "\"");
        }
        if (this.mapToProperty != null) {
            stringBuffer.append(" mapToProperty=\"" + this.mapToProperty + "\"");
        }
        if (this.validator != null) {
            stringBuffer.append(" validator=\"" + this.validator + "\"");
        }
        if (this.rules.size() == 0) {
            stringBuffer.append(" />\n");
        } else {
            stringBuffer.append(">\n");
            Iterator iterator = this.rules.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next());
            }
            stringBuffer.append("</field>\n");
        }
        return stringBuffer.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        XmlField.populateDefaults();
    }
}

