/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.localization;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.Strings;
import org.apache.fulcrum.BaseService;
import org.apache.fulcrum.InitializationException;
import org.apache.fulcrum.localization.LocaleTokenizer;
import org.apache.fulcrum.localization.LocalizationService;
import org.apache.log4j.Category;

public class TurbineLocalizationService
extends BaseService
implements LocalizationService {
    private static final Object[] NO_ARGS = new Object[0];
    private HashMap bundles = null;
    private String[] bundleNames = null;
    private Locale defaultLocale = null;
    private String defaultLanguage;
    private String defaultCountry = null;
    private Category category = Category.getInstance((String)this.getClass().getName());

    public TurbineLocalizationService() {
        this.bundles = new HashMap();
    }

    public void init() throws InitializationException {
        this.initBundleNames(null);
        Locale locale = Locale.getDefault();
        this.defaultLanguage = this.getConfiguration().getString("locale.default.language", locale.getLanguage()).trim();
        this.defaultCountry = this.getConfiguration().getString("locale.default.country", locale.getCountry()).trim();
        this.defaultLocale = new Locale(this.defaultLanguage, this.defaultCountry);
        this.setInit(true);
    }

    protected void initBundleNames(String[] stringArray) {
        this.bundleNames = this.getConfiguration().getStringArray("locale.default.bundles");
        String string = this.getConfiguration().getString("locale.default.bundle");
        if (string != null && string.length() > 0) {
            if (this.bundleNames == null || this.bundleNames.length <= 0) {
                this.bundleNames = new String[]{string};
            } else {
                String[] stringArray2 = new String[this.bundleNames.length + 1];
                stringArray2[0] = string;
                System.arraycopy(this.bundleNames, 0, stringArray2, 1, this.bundleNames.length);
                this.bundleNames = stringArray2;
            }
        }
        if (this.bundleNames == null) {
            this.bundleNames = new String[0];
        }
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public String getDefaultCountry() {
        return this.defaultCountry;
    }

    public String getDefaultBundleName() {
        return this.bundleNames.length > 0 ? this.bundleNames[0] : "";
    }

    public String[] getBundleNames() {
        return (String[])this.bundleNames.clone();
    }

    public ResourceBundle getBundle() {
        return this.getBundle(this.getDefaultBundleName(), (Locale)null);
    }

    public ResourceBundle getBundle(String string) {
        return this.getBundle(string, (Locale)null);
    }

    public ResourceBundle getBundle(String string, String string2) {
        return this.getBundle(string, this.getLocale(string2));
    }

    public ResourceBundle getBundle(HttpServletRequest httpServletRequest) {
        return this.getBundle(this.getDefaultBundleName(), this.getLocale(httpServletRequest));
    }

    public ResourceBundle getBundle(String string, HttpServletRequest httpServletRequest) {
        return this.getBundle(string, this.getLocale(httpServletRequest));
    }

    public ResourceBundle getBundle(String string, Locale locale) {
        String string2 = string = string == null ? this.getDefaultBundleName() : string.trim();
        if (locale == null) {
            locale = this.getLocale((String)null);
        }
        ResourceBundle resourceBundle = null;
        HashMap hashMap = (HashMap)this.bundles.get(string);
        if (hashMap != null) {
            resourceBundle = (ResourceBundle)hashMap.get(locale);
            if (resourceBundle == null) {
                resourceBundle = this.cacheBundle(string, locale);
            }
        } else {
            resourceBundle = this.cacheBundle(string, locale);
        }
        return resourceBundle;
    }

    private synchronized ResourceBundle cacheBundle(String string, Locale locale) throws MissingResourceException {
        ResourceBundle resourceBundle;
        HashMap<Locale, ResourceBundle> hashMap = (HashMap<Locale, ResourceBundle>)this.bundles.get(string);
        ResourceBundle resourceBundle2 = resourceBundle = hashMap == null ? null : (ResourceBundle)hashMap.get(locale);
        if (resourceBundle == null) {
            block4: {
                hashMap = hashMap == null ? new HashMap<Locale, ResourceBundle>(3) : new HashMap(hashMap);
                try {
                    resourceBundle = ResourceBundle.getBundle(string, locale);
                }
                catch (MissingResourceException missingResourceException) {
                    resourceBundle = this.findBundleByLocale(string, locale, hashMap);
                    if (resourceBundle != null) break block4;
                    throw (MissingResourceException)missingResourceException.fillInStackTrace();
                }
            }
            if (resourceBundle != null) {
                hashMap.put(resourceBundle.getLocale(), resourceBundle);
                HashMap<String, HashMap<Locale, ResourceBundle>> hashMap2 = new HashMap<String, HashMap<Locale, ResourceBundle>>(this.bundles);
                hashMap2.put(string, hashMap);
                this.bundles = hashMap2;
            }
        }
        return resourceBundle;
    }

    private ResourceBundle findBundleByLocale(String string, Locale locale, Map map) {
        Locale locale2;
        ResourceBundle resourceBundle = null;
        if (!Strings.isValid((String)locale.getCountry()) && this.defaultLanguage.equals(locale.getLanguage())) {
            Locale locale3 = new Locale(locale.getLanguage(), this.defaultCountry);
            resourceBundle = (ResourceBundle)map.get(locale3);
            if (resourceBundle == null) {
                resourceBundle = this.getBundleIgnoreException(string, locale3);
            }
        } else if (!Strings.isValid((String)locale.getLanguage()) && this.defaultCountry.equals(locale.getCountry()) && (resourceBundle = (ResourceBundle)map.get(locale2 = new Locale(this.defaultLanguage, locale.getCountry()))) == null) {
            resourceBundle = this.getBundleIgnoreException(string, locale2);
        }
        if (resourceBundle == null && !this.defaultLocale.equals(locale)) {
            resourceBundle = this.getBundleIgnoreException(string, this.defaultLocale);
        }
        return resourceBundle;
    }

    private final ResourceBundle getBundleIgnoreException(String string, Locale locale) {
        try {
            return ResourceBundle.getBundle(string, locale);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public void setBundle(String string) {
        if (this.bundleNames.length > 0) {
            this.bundleNames[0] = string;
        } else {
            TurbineLocalizationService turbineLocalizationService = this;
            synchronized (turbineLocalizationService) {
                if (this.bundleNames.length <= 0) {
                    this.bundleNames = new String[]{string};
                }
            }
        }
    }

    public final Locale getLocale(HttpServletRequest httpServletRequest) {
        return this.getLocale(httpServletRequest.getHeader("Accept-Language"));
    }

    public Locale getLocale(String string) {
        LocaleTokenizer localeTokenizer;
        if (!Strings.isEmpty((String)string) && (localeTokenizer = new LocaleTokenizer(string)).hasNext()) {
            return (Locale)localeTokenizer.next();
        }
        return this.defaultLocale;
    }

    public String getString(String string, Locale locale, String string2) {
        String string3;
        ResourceBundle resourceBundle;
        String string4 = null;
        if (locale == null) {
            locale = this.getLocale((String)null);
        }
        if ((string4 = this.getStringOrNull(resourceBundle = this.getBundle(string, locale), string2)) == null && this.bundleNames.length > 0) {
            int n = 0;
            while (n < this.bundleNames.length) {
                string3 = this.bundleNames[n];
                if (!string3.equals(string) && (string4 = this.getStringOrNull(resourceBundle = this.getBundle(string3, locale), string2)) != null) {
                    locale = resourceBundle.getLocale();
                    break;
                }
                ++n;
            }
        }
        if (string4 == null) {
            string3 = locale.toString();
            this.category.debug((Object)("LocalizationService noticed missing resource: bundleName=" + string + ", locale=" + string3 + ", key=" + string2));
            throw new MissingResourceException(string, string3, string2);
        }
        return string4;
    }

    protected final String getStringOrNull(ResourceBundle resourceBundle, String string) {
        if (resourceBundle != null) {
            try {
                return resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return null;
    }

    public String format(String string, Locale locale, String string2, Object object) {
        return this.format(string, locale, string2, new Object[]{object});
    }

    public String format(String string, Locale locale, String string2, Object object, Object object2) {
        return this.format(string, locale, string2, new Object[]{object, object2});
    }

    public String format(String string, Locale locale, String string2, Object[] objectArray) {
        if (locale == null) {
            locale = this.getLocale((String)null);
        }
        String string3 = this.getString(string, locale, string2);
        if (objectArray == null) {
            objectArray = NO_ARGS;
        }
        MessageFormat messageFormat = new MessageFormat("");
        messageFormat.setLocale(locale);
        messageFormat.applyPattern(string3);
        StringBuffer stringBuffer = new StringBuffer();
        messageFormat.format(objectArray, stringBuffer, new FieldPosition(0));
        return stringBuffer.toString();
    }
}

