/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security;

import java.security.MessageDigest;
import org.apache.commons.codec.base64.Base64;
import org.apache.fulcrum.BaseService;
import org.apache.fulcrum.InitializationException;
import org.apache.fulcrum.security.SecurityService;
import org.apache.fulcrum.security.UserManager;
import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.entity.Permission;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.util.AccessControlList;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.EntityExistsException;
import org.apache.fulcrum.security.util.GroupSet;
import org.apache.fulcrum.security.util.PasswordMismatchException;
import org.apache.fulcrum.security.util.PermissionSet;
import org.apache.fulcrum.security.util.RoleSet;
import org.apache.fulcrum.security.util.UnknownEntityException;
import org.apache.torque.util.Criteria;

public abstract class BaseSecurityService
extends BaseService
implements SecurityService {
    private GroupSet allGroups = null;
    private RoleSet allRoles = null;
    private PermissionSet allPermissions = null;
    private int readerCount = 0;
    private UserManager userManager = null;
    private Class userClass = null;
    private static Group globalGroup = null;
    static /* synthetic */ Class class$org$apache$fulcrum$security$BaseSecurityService;

    public String encryptPassword(String string) {
        if (string == null) {
            return null;
        }
        String string2 = this.getConfiguration().getString("secure.passwords", "false").toLowerCase();
        String string3 = this.getConfiguration().getString("secure.passwords.algorithm", "SHA");
        if (string2.equals("true") || string2.equals("yes")) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance(string3);
                byte[] byArray = messageDigest.digest(string.getBytes("UTF-8"));
                byte[] byArray2 = Base64.encode((byte[])byArray);
                return byArray2 == null ? null : new String(byArray2);
            }
            catch (Exception exception) {
                this.getCategory().error((Object)"Unable to encrypt password");
                this.getCategory().error((Object)exception);
                return null;
            }
        }
        return string;
    }

    public void init() throws InitializationException {
        String string = this.getConfiguration().getString("user.manager", "org.apache.fulcrum.security.DBUserManager");
        String string2 = this.getConfiguration().getString("user.class", "org.apache.turbine.om.security.TurbineUser");
        try {
            this.userClass = Class.forName(string2);
        }
        catch (Exception exception) {
            throw new InitializationException("Failed create a Class object for User implementation", exception);
        }
        try {
            this.userManager = (UserManager)Class.forName(string).newInstance();
            this.setInit(true);
        }
        catch (Exception exception) {
            throw new InitializationException("BaseSecurityService.init: Failed to instantiate UserManager", exception);
        }
    }

    public Class getUserClass() throws UnknownEntityException {
        if (this.userClass == null) {
            throw new UnknownEntityException("Failed to create a Class object for User implementation");
        }
        return this.userClass;
    }

    public User getUserInstance() throws UnknownEntityException {
        User user;
        try {
            user = (User)this.getUserClass().newInstance();
        }
        catch (Exception exception) {
            throw new UnknownEntityException("Failed instantiate an User implementation object", exception);
        }
        return user;
    }

    public boolean accountExists(User user) throws DataBackendException {
        return this.userManager.accountExists(user);
    }

    public boolean accountExists(String string) throws DataBackendException {
        return this.userManager.accountExists(string);
    }

    public User getAuthenticatedUser(String string, String string2) throws DataBackendException, UnknownEntityException, PasswordMismatchException {
        return this.userManager.retrieve(string, string2);
    }

    public User getUser(String string) throws DataBackendException, UnknownEntityException {
        return this.userManager.retrieve(string);
    }

    public User[] getUsers(Criteria criteria) throws DataBackendException {
        return this.userManager.retrieve(criteria);
    }

    public User getAnonymousUser() throws UnknownEntityException {
        User user = this.getUserInstance();
        user.setUserName("");
        return user;
    }

    public void saveUser(User user) throws UnknownEntityException, DataBackendException {
        this.userManager.store(user);
    }

    public void addUser(User user, String string) throws DataBackendException, EntityExistsException {
        this.userManager.createAccount(user, string);
    }

    public void removeUser(User user) throws DataBackendException, UnknownEntityException {
        this.revokeAll(user);
        this.userManager.removeAccount(user);
    }

    public void changePassword(User user, String string, String string2) throws PasswordMismatchException, UnknownEntityException, DataBackendException {
        this.userManager.changePassword(user, string, string2);
    }

    public void forcePassword(User user, String string) throws UnknownEntityException, DataBackendException {
        this.userManager.forcePassword(user, string);
    }

    protected synchronized void lockShared() {
        ++this.readerCount;
    }

    protected synchronized void unlockShared() {
        --this.readerCount;
        this.notify();
    }

    protected void lockExclusive() {
        while (this.readerCount > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected void unlockExclusive() {
    }

    public Group getGlobalGroup() {
        if (globalGroup == null) {
            Class clazz = class$org$apache$fulcrum$security$BaseSecurityService == null ? (class$org$apache$fulcrum$security$BaseSecurityService = BaseSecurityService.class$("org.apache.fulcrum.security.BaseSecurityService")) : class$org$apache$fulcrum$security$BaseSecurityService;
            synchronized (clazz) {
                if (globalGroup == null) {
                    try {
                        globalGroup = this.getAllGroups().getGroup("global");
                    }
                    catch (DataBackendException dataBackendException) {
                        this.getCategory().error((Object)"Failed to retrieve global group object");
                        this.getCategory().error((Object)dataBackendException);
                    }
                }
            }
        }
        return globalGroup;
    }

    public Group getGroup(String string) throws DataBackendException, UnknownEntityException {
        GroupSet groupSet = this.getAllGroups();
        Group group = groupSet.getGroup(string);
        if (group != null) {
            return group;
        }
        throw new UnknownEntityException("The specified group does not exist");
    }

    public Role getRole(String string) throws DataBackendException, UnknownEntityException {
        RoleSet roleSet = this.getAllRoles();
        Role role = roleSet.getRole(string);
        if (role != null) {
            role.setPermissions(this.getPermissions(role));
            return role;
        }
        throw new UnknownEntityException("The specified role does not exist");
    }

    public Permission getPermission(String string) throws DataBackendException, UnknownEntityException {
        PermissionSet permissionSet = this.getAllPermissions();
        Permission permission = permissionSet.getPermission(string);
        if (permission != null) {
            return permission;
        }
        throw new UnknownEntityException("The specified permission does not exist");
    }

    public GroupSet getAllGroups() throws DataBackendException {
        return this.getGroups(new Criteria());
    }

    public RoleSet getAllRoles() throws DataBackendException {
        return this.getRoles(new Criteria());
    }

    public PermissionSet getAllPermissions() throws DataBackendException {
        return this.getPermissions(new Criteria());
    }

    public abstract void renamePermission(Permission var1, String var2) throws DataBackendException, UnknownEntityException;

    public abstract void renameRole(Role var1, String var2) throws DataBackendException, UnknownEntityException;

    public abstract void renameGroup(Group var1, String var2) throws DataBackendException, UnknownEntityException;

    public abstract void removePermission(Permission var1) throws DataBackendException, UnknownEntityException;

    public abstract void removeRole(Role var1) throws DataBackendException, UnknownEntityException;

    public abstract void removeGroup(Group var1) throws DataBackendException, UnknownEntityException;

    public abstract Permission addPermission(Permission var1) throws DataBackendException, EntityExistsException;

    public abstract Role addRole(Role var1) throws DataBackendException, EntityExistsException;

    public abstract Group addGroup(Group var1) throws DataBackendException, EntityExistsException;

    public abstract void savePermission(Permission var1) throws DataBackendException, UnknownEntityException;

    public abstract void saveRole(Role var1) throws DataBackendException, UnknownEntityException;

    public abstract void saveGroup(Group var1) throws DataBackendException, UnknownEntityException;

    public abstract PermissionSet getPermissions(Criteria var1) throws DataBackendException;

    public abstract RoleSet getRoles(Criteria var1) throws DataBackendException;

    public abstract GroupSet getGroups(Criteria var1) throws DataBackendException;

    public abstract Permission getNewPermission(String var1);

    public abstract Role getNewRole(String var1);

    public abstract Group getNewGroup(String var1);

    public abstract void revokeAll(Role var1) throws DataBackendException, UnknownEntityException;

    public abstract void revoke(Role var1, Permission var2) throws DataBackendException, UnknownEntityException;

    public abstract void grant(Role var1, Permission var2) throws DataBackendException, UnknownEntityException;

    public abstract void revokeAll(User var1) throws DataBackendException, UnknownEntityException;

    public abstract void revoke(User var1, Group var2, Role var3) throws DataBackendException, UnknownEntityException;

    public abstract void grant(User var1, Group var2, Role var3) throws DataBackendException, UnknownEntityException;

    public abstract PermissionSet getPermissions(Role var1) throws DataBackendException, UnknownEntityException;

    public abstract AccessControlList getACL(User var1) throws DataBackendException, UnknownEntityException;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

