/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.impl.db;

import java.util.Iterator;
import java.util.Vector;
import org.apache.fulcrum.security.TurbineSecurity;
import org.apache.fulcrum.security.UserManager;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.impl.db.entity.BaseTurbineUserPeer;
import org.apache.fulcrum.security.impl.db.entity.TurbineUser;
import org.apache.fulcrum.security.impl.db.entity.TurbineUserPeer;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.EntityExistsException;
import org.apache.fulcrum.security.util.PasswordMismatchException;
import org.apache.fulcrum.security.util.UnknownEntityException;
import org.apache.torque.om.BaseObject;
import org.apache.torque.util.Criteria;

public class DBUserManager
implements UserManager {
    private static final boolean DEBUG = false;

    public boolean accountExists(User user) throws DataBackendException {
        return this.accountExists(user.getUserName());
    }

    public boolean accountExists(String string) throws DataBackendException {
        Vector vector;
        Criteria criteria = new Criteria();
        criteria.add(TurbineUserPeer.USERNAME, (Object)string);
        try {
            vector = BaseTurbineUserPeer.doSelect(criteria);
        }
        catch (Exception exception) {
            throw new DataBackendException("Failed to check account's presence", exception);
        }
        if (vector.size() > 1) {
            throw new DataBackendException("Multiple Users with same username '" + string + "'");
        }
        return vector.size() == 1;
    }

    public User retrieve(String string) throws UnknownEntityException, DataBackendException {
        Vector vector;
        Criteria criteria = new Criteria();
        criteria.add(TurbineUserPeer.USERNAME, (Object)string);
        try {
            vector = BaseTurbineUserPeer.doSelect(criteria);
        }
        catch (Exception exception) {
            throw new DataBackendException("Failed to retrieve user '" + string + "'", exception);
        }
        if (vector.size() > 1) {
            throw new DataBackendException("Multiple Users with same username '" + string + "'");
        }
        if (vector.size() == 1) {
            return (User)vector.get(0);
        }
        throw new UnknownEntityException("Unknown user '" + string + "'");
    }

    public User[] retrieve(Criteria criteria) throws DataBackendException {
        Object object;
        Iterator iterator = criteria.keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            Criteria.Criterion[] criterionArray = criteria.getCriterion((String)object).getAttachedCriterion();
            int n = 0;
            while (n < criterionArray.length) {
                String string = criterionArray[n].getTable();
                if (string == null || "".equals(string)) {
                    criterionArray[n].setTable(TurbineUserPeer.getTableName());
                }
                ++n;
            }
        }
        object = new Vector(0);
        try {
            object = BaseTurbineUserPeer.doSelect(criteria);
        }
        catch (Exception exception) {
            throw new DataBackendException("Failed to retrieve users", exception);
        }
        return ((Vector)object).toArray(new User[0]);
    }

    public User retrieve(String string, String string2) throws PasswordMismatchException, UnknownEntityException, DataBackendException {
        User user = this.retrieve(string);
        this.authenticate(user, string2);
        return user;
    }

    public void store(User user) throws UnknownEntityException, DataBackendException {
        if (!this.accountExists(user)) {
            throw new UnknownEntityException("The account '" + user.getUserName() + "' does not exist");
        }
        Criteria criteria = BaseTurbineUserPeer.buildCriteria((TurbineUser)user);
        try {
            BaseTurbineUserPeer.doUpdate(criteria);
        }
        catch (Exception exception) {
            throw new DataBackendException("Failed to save user object", exception);
        }
    }

    public void authenticate(User user, String string) throws PasswordMismatchException, UnknownEntityException, DataBackendException {
        if (!this.accountExists(user)) {
            throw new UnknownEntityException("The account '" + user.getUserName() + "' does not exist");
        }
        String string2 = TurbineSecurity.encryptPassword(string);
        if (!user.getPassword().equals(string2)) {
            throw new PasswordMismatchException("The passwords do not match");
        }
    }

    public void changePassword(User user, String string, String string2) throws PasswordMismatchException, UnknownEntityException, DataBackendException {
        String string3 = TurbineSecurity.encryptPassword(string);
        if (!this.accountExists(user)) {
            throw new UnknownEntityException("The account '" + user.getUserName() + "' does not exist");
        }
        if (!user.getPassword().equals(string3)) {
            throw new PasswordMismatchException("The supplied old password for '" + user.getUserName() + "' was incorrect");
        }
        user.setPassword(TurbineSecurity.encryptPassword(string2));
        this.store(user);
    }

    public void forcePassword(User user, String string) throws UnknownEntityException, DataBackendException {
        if (!this.accountExists(user)) {
            throw new UnknownEntityException("The account '" + user.getUserName() + "' does not exist");
        }
        user.setPassword(TurbineSecurity.encryptPassword(string));
        this.store(user);
    }

    public void createAccount(User user, String string) throws EntityExistsException, DataBackendException {
        if (this.accountExists(user)) {
            throw new EntityExistsException("The account '" + user.getUserName() + "' already exists");
        }
        String string2 = TurbineSecurity.encryptPassword(string);
        user.setPassword(string2);
        Criteria criteria = BaseTurbineUserPeer.buildCriteria((TurbineUser)user);
        try {
            ((BaseObject)user).setPrimaryKey(BaseTurbineUserPeer.doInsert(criteria));
        }
        catch (Exception exception) {
            throw new DataBackendException("Failed to create account '" + user.getUserName() + "'", exception);
        }
    }

    public void removeAccount(User user) throws UnknownEntityException, DataBackendException {
        if (!this.accountExists(user)) {
            throw new UnknownEntityException("The account '" + user.getUserName() + "' does not exist");
        }
        Criteria criteria = new Criteria();
        criteria.add(TurbineUserPeer.USERNAME, (Object)user.getUserName());
        try {
            BaseTurbineUserPeer.doDelete(criteria);
        }
        catch (Exception exception) {
            throw new DataBackendException("Failed to remove account '" + user.getUserName() + "'", exception);
        }
    }
}

