/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.account;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.account.util.AccountUtils;
import com.aimluck.eip.cayenne.om.account.EipMPosition;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.Date;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class AccountPositionFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AccountPositionFormData.class.getName());
    private ALStringField position_name;
    private int position_id;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
    }

    public void initField() {
        this.position_name = new ALStringField();
        this.position_name.setFieldName("\u5f79\u8077\u540d");
        this.position_name.setTrim(true);
    }

    protected void setValidator() {
        this.position_name.setNotNull(true);
        this.position_name.limitMaxLength(50);
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        if (res) {
            try {
                if ("update".equals(this.getMode())) {
                    this.position_id = Integer.parseInt(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid"));
                }
            }
            catch (Exception ex) {
                logger.error((Object)"AccountPositionFormData.setFormData", (Throwable)ex);
            }
        }
        return res;
    }

    protected boolean validate(List<String> msgList) {
        this.position_name.validate(msgList);
        try {
            SelectQuery query = Database.query(EipMPosition.class);
            if ("insert".equals(this.getMode())) {
                Expression exp = ExpressionFactory.matchExp((String)"positionName", (Object)this.position_name.getValue());
                query.setQualifier(exp);
            } else if ("update".equals(this.getMode())) {
                Expression exp1 = ExpressionFactory.matchExp((String)"positionName", (Object)this.position_name.getValue());
                query.setQualifier(exp1);
                Expression exp2 = ExpressionFactory.noMatchDbExp((String)"POSITION_ID", (Object)this.position_id);
                query.andQualifier(exp2);
            }
            if (query.fetchList().size() != 0) {
                msgList.add(ALLocalizationUtils.getl10nFormat((String)"ACCOUNT_VALIDATE_POSITION", (Object[])new Object[]{this.position_name}));
            }
        }
        catch (Exception ex) {
            logger.error((Object)"AccountPositionFormData.validate", (Throwable)ex);
            return false;
        }
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipMPosition record = AccountUtils.getEipMPosition(rundata, context);
            if (record == null) {
                return false;
            }
            this.position_name.setValue(record.getPositionName());
        }
        catch (Exception ex) {
            logger.error((Object)"AccountPositionFormData.loadFormData", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipMPosition position = (EipMPosition)Database.create(EipMPosition.class);
            position.setPositionName(this.position_name.getValue());
            Date now = new Date();
            position.setCreateDate(now);
            position.setUpdateDate(now);
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(position.getPositionId().intValue(), 3, "\u5f79\u8077\u300c" + position.getPositionName() + "\u300d\u3092\u8ffd\u52a0");
            this.position_id = position.getPositionId();
            ALEipManager.getInstance().reloadPosition();
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"AccountPositionFormData.insertFormData", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipMPosition record = AccountUtils.getEipMPosition(rundata, context);
            if (record == null) {
                return false;
            }
            record.setPositionName(this.position_name.getValue());
            record.setUpdateDate(new Date());
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(record.getPositionId().intValue(), 3, "\u5f79\u8077\u300c" + record.getPositionName() + "\u300d\u3092\u66f4\u65b0");
            ALEipManager.getInstance().reloadPosition();
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"AccountPositionFormData.updateFormData", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipMPosition record = AccountUtils.getEipMPosition(rundata, context);
            if (record == null) {
                return false;
            }
            int positionId = record.getPositionId();
            Database.delete((Persistent)record);
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(record.getPositionId().intValue(), 3, "\u5f79\u8077\u300c" + record.getPositionName() + "\u300d\u3092\u524a\u9664");
            String sql = "UPDATE turbine_user set POSITION_ID = 0 where POSITION_ID = " + positionId;
            Database.sql(TurbineUser.class, (String)sql).execute();
            ALEipManager.getInstance().reloadPosition();
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"AccountPositionFormData.deleteFormData", (Throwable)ex);
            return false;
        }
        return true;
    }

    public ALStringField getPositionName() {
        return this.position_name;
    }

    public int getPositionId() {
        return this.position_id;
    }
}

