/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.account;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.account.util.AccountUtils;
import com.aimluck.eip.cayenne.om.account.EipMPost;
import com.aimluck.eip.cayenne.om.security.TurbineGroup;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipPost;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.om.security.Group;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class AccountPostFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AccountPostFormData.class.getName());
    private ALStringField post_name;
    private ALStringField zipcode1;
    private ALStringField zipcode2;
    private ALStringField address;
    private ALStringField post_out_telephone1;
    private ALStringField post_out_telephone2;
    private ALStringField post_out_telephone3;
    private ALStringField post_in_telephone;
    private ALStringField fax_number1;
    private ALStringField fax_number2;
    private ALStringField fax_number3;
    private List<ALEipUser> memberList;
    private boolean is_join_member = true;
    private int post_id;
    private ALStringField group_name;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
    }

    public void initField() {
        this.post_name = new ALStringField();
        this.post_name.setFieldName(ALLocalizationUtils.getl10n((String)"ACCOUNT_POST_NAME"));
        this.post_name.setTrim(true);
        this.zipcode1 = new ALStringField();
        this.zipcode1.setFieldName(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_ZIPCODE"));
        this.zipcode1.setTrim(true);
        this.zipcode2 = new ALStringField();
        this.zipcode2.setFieldName(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_ZIPCODE"));
        this.zipcode2.setTrim(true);
        this.address = new ALStringField();
        this.address.setFieldName(ALLocalizationUtils.getl10n((String)"ACCOUNT_POST_ADDRESS"));
        this.address.setTrim(true);
        this.post_out_telephone1 = new ALStringField();
        this.post_out_telephone1.setFieldName(ALLocalizationUtils.getl10n((String)"ACCOUNT_OUT_TELEPHONE"));
        this.post_out_telephone1.setTrim(true);
        this.post_out_telephone2 = new ALStringField();
        this.post_out_telephone2.setFieldName(ALLocalizationUtils.getl10n((String)"ACCOUNT_OUT_TELEPHONE"));
        this.post_out_telephone2.setTrim(true);
        this.post_out_telephone3 = new ALStringField();
        this.post_out_telephone3.setFieldName(ALLocalizationUtils.getl10n((String)"ACCOUNT_OUT_TELEPHONE"));
        this.post_out_telephone3.setTrim(true);
        this.post_in_telephone = new ALStringField();
        this.post_in_telephone.setFieldName(ALLocalizationUtils.getl10n((String)"ACCOUNT_IN_TELEPHONE"));
        this.post_in_telephone.setTrim(true);
        this.fax_number1 = new ALStringField();
        this.fax_number1.setFieldName(ALLocalizationUtils.getl10n((String)"ACCOUNT_FAX_NUMBER"));
        this.fax_number1.setTrim(true);
        this.fax_number2 = new ALStringField();
        this.fax_number2.setFieldName(ALLocalizationUtils.getl10n((String)"ACCOUNT_FAX_NUMBER"));
        this.fax_number2.setTrim(true);
        this.fax_number3 = new ALStringField();
        this.fax_number3.setFieldName(ALLocalizationUtils.getl10n((String)"ACCOUNT_FAX_NUMBER"));
        this.fax_number3.setTrim(true);
        if (this.is_join_member) {
            this.memberList = new ArrayList<ALEipUser>();
        }
        this.group_name = new ALStringField();
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        if (res) {
            try {
                if ("update".equals(this.getMode())) {
                    this.post_id = Integer.parseInt(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid"));
                }
                if (this.is_join_member) {
                    Object[] str = rundata.getParameters().getStrings("member_to");
                    if (str == null) {
                        return res;
                    }
                    Expression exp = ExpressionFactory.inExp((String)"loginName", (Object[])str);
                    SelectQuery query = Database.query(TurbineUser.class);
                    query.setQualifier(exp);
                    List list = query.fetchList();
                    int size = list.size();
                    for (int i = 0; i < size; ++i) {
                        TurbineUser record = (TurbineUser)list.get(i);
                        ALEipUser user = new ALEipUser();
                        user.initField();
                        user.setName(record.getLoginName());
                        user.setAliasName(record.getFirstName(), record.getLastName());
                        this.memberList.add(user);
                    }
                }
            }
            catch (Exception ex) {
                logger.error((Object)"AccountPostFormData.setFormData", (Throwable)ex);
            }
        }
        return res;
    }

    protected void setValidator() {
        this.post_name.setNotNull(true);
        this.post_name.limitMaxLength(50);
        this.zipcode1.setCharacterType(2);
        this.zipcode1.limitLength(3, 3);
        this.zipcode2.setCharacterType(2);
        this.zipcode2.limitLength(4, 4);
        this.address.limitMaxLength(64);
        this.post_out_telephone1.setCharacterType(2);
        this.post_out_telephone1.limitMaxLength(5);
        this.post_out_telephone2.setCharacterType(2);
        this.post_out_telephone2.limitMaxLength(4);
        this.post_out_telephone3.setCharacterType(2);
        this.post_out_telephone3.limitMaxLength(4);
        this.post_in_telephone.setCharacterType(19);
        this.post_in_telephone.limitMaxLength(13);
        this.fax_number1.setCharacterType(2);
        this.fax_number1.limitMaxLength(5);
        this.fax_number2.setCharacterType(2);
        this.fax_number2.limitMaxLength(4);
        this.fax_number3.setCharacterType(2);
        this.fax_number3.limitMaxLength(4);
    }

    protected boolean validate(List<String> msgList) {
        ArrayList dummy = new ArrayList();
        this.post_name.validate(msgList);
        this.address.validate(msgList);
        if (this.post_name.toString().lastIndexOf("/") != -1) {
            msgList.add(ALLocalizationUtils.getl10n((String)"ACCOUNT_POST_SET_OTHER_NAME"));
        }
        try {
            SelectQuery query = Database.query(EipMPost.class);
            if ("insert".equals(this.getMode())) {
                Expression exp = ExpressionFactory.matchExp((String)"postName", (Object)this.post_name.getValue());
                query.setQualifier(exp);
            } else if ("update".equals(this.getMode())) {
                Expression exp1 = ExpressionFactory.matchExp((String)"postName", (Object)this.post_name.getValue());
                query.setQualifier(exp1);
                Expression exp2 = ExpressionFactory.noMatchDbExp((String)"POST_ID", (Object)this.post_id);
                query.andQualifier(exp2);
            }
            if (query.fetchList().size() != 0) {
                msgList.add(ALLocalizationUtils.getl10nFormat((String)"ACCOUNT_POST_EXIST", (Object[])new Object[]{this.post_name.toString()}));
            }
        }
        catch (Exception ex) {
            logger.error((Object)"AccountPostFormData.validate", (Throwable)ex);
            return false;
        }
        if (!(this.zipcode1.getValue().equals("") && this.zipcode2.getValue().equals("") || this.zipcode1.validate(dummy) && this.zipcode2.validate(dummy))) {
            msgList.add(ALLocalizationUtils.getl10n((String)"ACCOUNT_POST_WITHIN_SEVEN"));
        }
        if (!(this.post_out_telephone1.getValue().equals("") && this.post_out_telephone2.getValue().equals("") && this.post_out_telephone3.getValue().equals("") || this.post_out_telephone1.validate(dummy) && this.post_out_telephone2.validate(dummy) && this.post_out_telephone3.validate(dummy))) {
            msgList.add(ALLocalizationUtils.getl10n((String)"ACCOUNT_POST_SET_TELEPHON_EXTERNAL_NOMBER"));
        }
        this.post_in_telephone.validate(msgList);
        Pattern pattern = Pattern.compile(".*[^-0-9]+.*");
        Matcher matcher = pattern.matcher(this.post_in_telephone.getValue());
        Boolean ext_validater = matcher.matches();
        if (ext_validater.booleanValue()) {
            msgList.add(ALLocalizationUtils.getl10n((String)"ACCOUNT_POST_WITHIN_SIXTEEN"));
        }
        if (!(this.fax_number1.getValue().equals("") && this.fax_number2.getValue().equals("") && this.fax_number3.getValue().equals("") || this.fax_number1.validate(dummy) && this.fax_number2.validate(dummy) && this.fax_number3.validate(dummy))) {
            msgList.add(ALLocalizationUtils.getl10n((String)"ACCOUNT_POST_SET_FAX_NOMBER"));
        }
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            StringTokenizer token;
            EipMPost record = AccountUtils.getEipMPost(rundata, context);
            if (record == null) {
                return false;
            }
            this.post_name.setValue(record.getPostName());
            if (record.getZipcode() != null && (token = new StringTokenizer(record.getZipcode(), "-")).countTokens() == 2) {
                this.zipcode1.setValue(token.nextToken());
                this.zipcode2.setValue(token.nextToken());
            }
            this.address.setValue(record.getAddress());
            if (record.getOutTelephone() != null && (token = new StringTokenizer(record.getOutTelephone(), "-")).countTokens() == 3) {
                this.post_out_telephone1.setValue(token.nextToken());
                this.post_out_telephone2.setValue(token.nextToken());
                this.post_out_telephone3.setValue(token.nextToken());
            }
            this.post_in_telephone.setValue(record.getInTelephone());
            if (record.getFaxNumber() != null && (token = new StringTokenizer(record.getFaxNumber(), "-")).countTokens() == 3) {
                this.fax_number1.setValue(token.nextToken());
                this.fax_number2.setValue(token.nextToken());
                this.fax_number3.setValue(token.nextToken());
            }
            this.post_id = record.getPostId();
            if (this.is_join_member) {
                SelectQuery query = Database.query(TurbineGroup.class);
                Expression exp = ExpressionFactory.matchExp((String)"groupAliasName", (Object)this.post_name);
                query.setQualifier(exp);
                List list = query.fetchList();
                if (!list.isEmpty()) {
                    TurbineGroup tg = (TurbineGroup)list.get(0);
                    this.memberList.addAll(ALEipUtils.getUsers((String)tg.getGroupName()));
                } else {
                    this.post_name.setValue(null);
                }
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            logger.error((Object)"AccountPostFormData.loadFormData", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            TurbineGroup group = (TurbineGroup)Database.create(TurbineGroup.class);
            String name = this.post_name.getValue();
            String groupName = new StringBuffer().append(new Date().getTime()).append("_").append(ALEipUtils.getUserId((RunData)rundata)).toString();
            group.setGroupName(groupName);
            group.setOwnerId(Integer.valueOf(1));
            group.setGroupAliasName(name);
            group.setPublicFlag("1");
            JetspeedSecurity.addGroup((Group)group);
            EipMPost record = (EipMPost)Database.create(EipMPost.class);
            record.setPostName(this.post_name.getValue());
            record.setCompanyId(Integer.valueOf(1));
            if (!this.zipcode1.getValue().equals("") && !this.zipcode2.getValue().equals("")) {
                record.setZipcode(new StringBuffer().append(this.zipcode1.getValue()).append("-").append(this.zipcode2.getValue()).toString());
            } else {
                record.setZipcode("");
            }
            record.setAddress(this.address.getValue());
            if (!(this.post_out_telephone1.getValue().equals("") || this.post_out_telephone2.getValue().equals("") || this.post_out_telephone3.getValue().equals(""))) {
                record.setOutTelephone(new StringBuffer().append(this.post_out_telephone1.getValue()).append("-").append(this.post_out_telephone2.getValue()).append("-").append(this.post_out_telephone3.getValue()).toString());
            } else {
                record.setOutTelephone("");
            }
            record.setInTelephone(this.post_in_telephone.getValue());
            if (!(this.fax_number1.getValue().equals("") || this.fax_number2.getValue().equals("") || this.fax_number3.getValue().equals(""))) {
                record.setFaxNumber(new StringBuffer().append(this.fax_number1.getValue()).append("-").append(this.fax_number2.getValue()).append("-").append(this.fax_number3.getValue()).toString());
            } else {
                record.setFaxNumber("");
            }
            record.setGroupName(groupName);
            Date now = new Date();
            record.setCreateDate(now);
            record.setUpdateDate(now);
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(record.getPostId().intValue(), 3, "\u90e8\u7f72\u300c" + record.getPostName() + "\u300d\u3092\u8ffd\u52a0");
            ALEipManager.getInstance().reloadPost();
            if (this.is_join_member) {
                int size = this.memberList.size();
                for (int i = 0; i < size; ++i) {
                    ALEipUtils.changePost((RunData)rundata, (String)this.memberList.get(i).getName().getValue(), (int)record.getPostId());
                }
            }
            this.post_id = record.getPostId();
        }
        catch (RuntimeException ex) {
            Database.rollback();
            logger.error((Object)"AccountPostFormData.insertFormData", (Throwable)ex);
            return false;
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"AccountPostFormData.insertFormData", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipMPost record = AccountUtils.getEipMPost(rundata, context);
            if (record == null) {
                return false;
            }
            record.setPostName(this.post_name.getValue());
            if (!this.zipcode1.getValue().equals("") && !this.zipcode2.getValue().equals("")) {
                record.setZipcode(new StringBuffer().append(this.zipcode1.getValue()).append("-").append(this.zipcode2.getValue()).toString());
            } else {
                record.setZipcode("");
            }
            record.setAddress(this.address.getValue());
            if (!(this.post_out_telephone1.getValue().equals("") || this.post_out_telephone2.getValue().equals("") || this.post_out_telephone3.getValue().equals(""))) {
                record.setOutTelephone(new StringBuffer().append(this.post_out_telephone1.getValue()).append("-").append(this.post_out_telephone2.getValue()).append("-").append(this.post_out_telephone3.getValue()).toString());
            } else {
                record.setOutTelephone("");
            }
            record.setInTelephone(this.post_in_telephone.getValue());
            if (!(this.fax_number1.getValue().equals("") || this.fax_number2.getValue().equals("") || this.fax_number3.getValue().equals(""))) {
                record.setFaxNumber(new StringBuffer().append(this.fax_number1.getValue()).append("-").append(this.fax_number2.getValue()).append("-").append(this.fax_number3.getValue()).toString());
            } else {
                record.setFaxNumber("");
            }
            record.setUpdateDate(new Date());
            Database.commit();
            this.post_id = record.getPostId();
            TurbineGroup group = (TurbineGroup)JetspeedSecurity.getGroup((String)record.getGroupName());
            if (group == null) {
                return false;
            }
            group.setGroupAliasName(this.post_name.getValue());
            JetspeedSecurity.saveGroup((Group)group);
            ALEipManager.getInstance().reloadPost();
            if (this.is_join_member) {
                int i;
                List users = ALEipUtils.getUsers((String)record.getGroupName());
                int size = users.size();
                for (i = 0; i < size; ++i) {
                    JetspeedSecurity.unjoinGroup((String)((ALEipUser)users.get(i)).getName().getValue(), (String)record.getGroupName());
                }
                size = this.memberList.size();
                for (i = 0; i < size; ++i) {
                    ALEipUtils.changePost((RunData)rundata, (String)this.memberList.get(i).getName().getValue(), (int)record.getPostId());
                }
            }
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(record.getPostId().intValue(), 3, "\u90e8\u7f72\u300c" + record.getPostName() + "\u300d\u3092\u66f4\u65b0");
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"AccountPostFormData.updateFormData", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipMPost record = AccountUtils.getEipMPost(rundata, context);
            if (record == null) {
                return false;
            }
            List users = ALEipUtils.getUsersIncludingN((String)record.getGroupName());
            int size = users.size();
            for (int i = 0; i < size; ++i) {
                JetspeedSecurity.unjoinGroup((String)((ALEipUser)users.get(i)).getName().getValue(), (String)record.getGroupName());
            }
            JetspeedSecurity.removeGroup((String)record.getGroupName());
            Database.delete((Persistent)record);
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(record.getPostId().intValue(), 3, "\u90e8\u7f72\u300c" + record.getPostName() + "\u300d\u3092\u524a\u9664");
            ALEipManager.getInstance().reloadPost();
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"AccountPostFormData.deleteFormData", (Throwable)ex);
            return false;
        }
        return true;
    }

    public ALStringField getPostName() {
        return this.post_name;
    }

    public ALStringField getAddress() {
        return this.address;
    }

    public ALStringField getFaxNumber1() {
        return this.fax_number1;
    }

    public ALStringField getFaxNumber2() {
        return this.fax_number2;
    }

    public ALStringField getFaxNumber3() {
        return this.fax_number3;
    }

    public ALStringField getOutTelephone1() {
        return this.post_out_telephone1;
    }

    public ALStringField getOutTelephone2() {
        return this.post_out_telephone2;
    }

    public ALStringField getOutTelephone3() {
        return this.post_out_telephone3;
    }

    public ALStringField getInTelephone() {
        return this.post_in_telephone;
    }

    public ALStringField getZipcode1() {
        return this.zipcode1;
    }

    public ALStringField getZipcode2() {
        return this.zipcode2;
    }

    public List<ALEipUser> getMemberList() {
        return this.memberList;
    }

    public ALStringField getGroupName() {
        return this.group_name;
    }

    public List<ALEipUser> getUsers(String groupname) {
        try {
            return ALEipUtils.getUsers((String)groupname);
        }
        catch (Exception e) {
            logger.error((Object)"AccountPostFormData.getUsers", (Throwable)e);
            return new ArrayList<ALEipUser>();
        }
    }

    public Map<Integer, ALEipPost> getPostMap() {
        return ALEipManager.getInstance().getPostMap();
    }

    public void setJoinMember(boolean bool) {
        this.is_join_member = bool;
    }

    public boolean isJoinMember() {
        return this.is_join_member;
    }

    public int getPostId() {
        return this.post_id;
    }
}

