/*
 * Decompiled with CFR 0.152.
 */
package com.develop.jcfe.attribute;

import com.develop.jcfe.attribute.CodeAttribute;
import com.develop.jcfe.attribute.ConstantValueAttribute;
import com.develop.jcfe.attribute.CustomAttribute;
import com.develop.jcfe.attribute.ExceptionsAttribute;
import com.develop.jcfe.attribute.LineNumberTableAttribute;
import com.develop.jcfe.attribute.LocalVariableTableAttribute;
import com.develop.jcfe.attribute.SerializableAttribute;
import com.develop.jcfe.attribute.SourceFileAttribute;
import com.develop.jcfe.cpool.ConstantPool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class Attribute {
    public static final short INVALID_INDEX = -1;
    private short attribute_name_index = (short)-1;
    private final String name;
    public static final int ATTRIBUTE_HEADER_LENGTH = 6;

    public short getNameIndex() {
        return this.attribute_name_index;
    }

    protected void setNameIndex(short idx) {
        if (this.attribute_name_index != -1) {
            throw new IllegalStateException("Name index can be set only once");
        }
        this.attribute_name_index = idx;
    }

    public abstract int getLength();

    public int getTotalLength() {
        return this.getLength() + 6;
    }

    public final String getName() {
        return this.name;
    }

    public static Attribute read(ConstantPool cp, DataInputStream dis) throws IOException {
        short name_index = dis.readShort();
        int attribute_length = dis.readInt();
        String name = cp.getUtf8String(name_index);
        if (name.equals("Code")) {
            return new CodeAttribute(cp, dis, name_index, attribute_length);
        }
        if (name.equals("SourceFile")) {
            return new SourceFileAttribute(cp, dis, name_index, attribute_length);
        }
        if (name.equals("ConstantValue")) {
            return new ConstantValueAttribute(dis, name_index, attribute_length);
        }
        if (name.equals("Exceptions")) {
            return new ExceptionsAttribute(dis, name_index, attribute_length);
        }
        if (name.equals("LineNumberTable")) {
            return new LineNumberTableAttribute(dis, name_index, attribute_length);
        }
        if (name.equals("LocalVariableTable")) {
            return new LocalVariableTableAttribute(dis, name_index, attribute_length);
        }
        if (name.startsWith("ser.")) {
            return SerializableAttribute.read(name, dis, name_index, attribute_length);
        }
        return new CustomAttribute(name, cp, dis, name_index, attribute_length);
    }

    public Attribute(String name) {
        this.name = name;
    }

    public Attribute(String name, short attribute_name_index) {
        this.name = name;
        this.attribute_name_index = attribute_name_index;
    }

    public void writeToStream(DataOutputStream ds) throws IOException {
        ds.writeShort(this.attribute_name_index);
        ds.writeInt(this.getLength());
    }
}

