/*
 * Decompiled with CFR 0.152.
 */
package com.develop.jcfe.attribute;

import com.develop.jcfe.attribute.Attribute;
import com.develop.jcfe.cpool.ConstantPool;
import com.develop.util.HexFormatter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class CustomAttribute
extends Attribute {
    private final byte[] info;

    public CustomAttribute(String name, ConstantPool cp, DataInputStream dis, short attribute_name_index, int attribute_length) throws IOException {
        super(name, attribute_name_index);
        name = cp.getUtf8String(attribute_name_index);
        this.info = new byte[attribute_length];
        dis.readFully(this.info);
    }

    public CustomAttribute(String name, byte[] info) {
        super(name);
        this.info = info;
    }

    public int getLength() {
        return this.info.length;
    }

    public void writeToStream(DataOutputStream ds) throws IOException {
        super.writeToStream(ds);
        ds.write(this.info);
    }

    public String toString() {
        return "Attribute " + this.getName() + "\n" + HexFormatter.convertBytesToString(this.info);
    }
}

