/*
 * Decompiled with CFR 0.152.
 */
package com.develop.reflect;

import com.develop.jcfe.ClassFile;
import com.develop.jcfe.ClassfileConstants;
import com.develop.jcfe.JavaType;
import com.develop.jcfe.MethodType;
import com.develop.jcfe.attribute.Attribute;
import com.develop.jcfe.cpool.CONSTANT_Class_info;
import com.develop.jcfe.cpool.CONSTANT_NameAndType;
import com.develop.jcfe.cpool.ConstantPool;
import com.develop.jcfe.cpool.PoolEntry;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class ClassEx
implements ClassfileConstants {
    private final ClassFile cf;
    private final ClassLoader cl;
    private final ConstantPool cp;

    public ClassEx(ClassFile cf, ClassLoader cl) {
        this.cf = cf;
        this.cl = cl;
        this.cp = cf.getConstantPool();
    }

    public static ClassEx getExtendedInfo(Class cls) throws IOException, ClassNotFoundException {
        return new ClassEx(ClassFile.loadFromVM(cls), cls.getClassLoader());
    }

    private static void maybeAdd(HashSet set, Class cl, boolean showSystemImports) {
        if (!cl.isPrimitive() && (showSystemImports || cl.getClassLoader() != null)) {
            set.add(cl);
        }
    }

    public void addAttribute(Attribute ca) {
        this.cf.addAttribute(ca);
    }

    public Attribute[] getAttributes(String name) {
        short length = this.cf.getAttributesCount();
        ArrayList<Attribute> result = new ArrayList<Attribute>();
        short n = 0;
        while (n < length) {
            Attribute temp = this.cf.getAttribute(n);
            if (temp.getName().equals(name)) {
                result.add(temp);
            }
            n = (short)(n + 1);
        }
        Attribute[] ret = new Attribute[result.size()];
        return result.toArray(ret);
    }

    public Attribute[] getAttributes() {
        return this.cf.getAttributes();
    }

    public void writeClass(OutputStream os) throws IOException {
        DataOutputStream dos = new DataOutputStream(os);
        this.cf.writeToStream(dos);
    }

    public Class[] getImports(boolean showSystemImports) {
        int count = this.cf.getConstantPoolSize();
        HashSet set = new HashSet();
        String name = null;
        Object cls = null;
        try {
            int n = 1;
            while (n < count) {
                PoolEntry inf = this.cp.getConstant(n);
                switch (inf.getType()) {
                    case 7: {
                        name = ((CONSTANT_Class_info)inf).getName(this.cf).replace('/', '.');
                        ClassEx.maybeAdd(set, Class.forName(name, false, this.cl), showSystemImports);
                        break;
                    }
                    case 12: {
                        String desc = ((CONSTANT_NameAndType)inf).getDescriptor(this.cp);
                        if (desc.charAt(0) == '(') {
                            MethodType mt = new MethodType(desc);
                            Class[] paramTypes = mt.getParamClasses(this.cl);
                            int inner = 0;
                            while (inner < paramTypes.length) {
                                ClassEx.maybeAdd(set, paramTypes[inner], showSystemImports);
                                ++inner;
                            }
                            break;
                        }
                        JavaType jt = new JavaType(desc);
                        ClassEx.maybeAdd(set, jt.toClass(this.cl), showSystemImports);
                    }
                }
                ++n;
            }
            Class[] classes = new Class[set.size()];
            return ((AbstractCollection)set).toArray(classes);
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
            throw new NoClassDefFoundError(cnfe.getMessage());
        }
    }

    public Iterator getMethodNames() {
        return this.cf.getMethods().keySet().iterator();
    }
}

