/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker.accesslayer;

import java.util.Collection;
import java.util.Iterator;
import ojb.broker.ManageableCollection;
import ojb.broker.PersistenceBroker;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.PersistenceBrokerFactory;
import ojb.broker.query.Query;

public class CollectionProxy
implements Collection,
ManageableCollection {
    private transient PersistenceBroker broker;
    private Query query;
    private Collection data;
    private Class collectionClass;
    private int size;
    static /* synthetic */ Class class$ojb$broker$util$ManageableVector;

    public CollectionProxy(PersistenceBroker aBroker, Query aQuery) {
        this(class$ojb$broker$util$ManageableVector == null ? (class$ojb$broker$util$ManageableVector = CollectionProxy.class$("ojb.broker.util.ManageableVector")) : class$ojb$broker$util$ManageableVector, aBroker, aQuery);
    }

    public CollectionProxy(Class aCollClass, PersistenceBroker aBroker, Query aQuery) {
        this.setCollectionClass(aCollClass);
        this.setBroker(aBroker);
        this.setQuery(aQuery);
        this.calculateSize();
    }

    protected boolean isLoaded() {
        return this.data != null;
    }

    protected void calculateSize() {
        this.size = this.getBroker().getCount(this.getQuery());
    }

    protected void load() throws PersistenceBrokerException {
        try {
            Collection result = (Collection)this.getCollectionClass().newInstance();
            if (!this.isEmpty()) {
                Iterator iter = this.getBroker().getIteratorByQuery(this.getQuery());
                while (iter.hasNext()) {
                    result.add(iter.next());
                }
            }
            this.setData(result);
        }
        catch (Exception ex) {
            throw new PersistenceBrokerException(ex);
        }
    }

    public int size() {
        if (this.isLoaded()) {
            return this.getData().size();
        }
        return this.size;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean contains(Object o) {
        return this.getData().contains(o);
    }

    public Iterator iterator() {
        return this.getData().iterator();
    }

    public Object[] toArray() {
        return this.getData().toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.getData().toArray(a);
    }

    public boolean add(Object o) {
        return this.getData().add(o);
    }

    public boolean remove(Object o) {
        return this.getData().remove(o);
    }

    public boolean containsAll(Collection c) {
        return this.getData().containsAll(c);
    }

    public boolean addAll(Collection c) {
        return this.getData().addAll(c);
    }

    public boolean removeAll(Collection c) {
        return this.getData().removeAll(c);
    }

    public boolean retainAll(Collection c) {
        return this.getData().retainAll(c);
    }

    public void clear() {
        this.setData(null);
        this.size = 0;
    }

    protected Query getQuery() {
        return this.query;
    }

    protected void setQuery(Query query) {
        this.query = query;
    }

    protected PersistenceBroker getBroker() {
        if (this.broker == null) {
            this.broker = PersistenceBrokerFactory.createPersistenceBroker();
        }
        return this.broker;
    }

    protected void setBroker(PersistenceBroker broker) {
        this.broker = broker;
    }

    protected Collection getData() {
        if (!this.isLoaded()) {
            this.load();
        }
        return this.data;
    }

    protected void setData(Collection data) {
        this.data = data;
    }

    protected Class getCollectionClass() {
        return this.collectionClass;
    }

    protected void setCollectionClass(Class collectionClass) {
        this.collectionClass = collectionClass;
    }

    public void ojbAdd(Object anObject) {
        this.add(anObject);
    }

    public void ojbAddAll(ManageableCollection otherCollection) {
        this.addAll((Collection)((CollectionProxy)otherCollection));
    }

    public Iterator ojbIterator() {
        return this.iterator();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

