/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker.accesslayer;

import java.sql.SQLException;
import ojb.broker.Identity;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.accesslayer.JdbcAccess;
import ojb.broker.accesslayer.RsIterator;
import ojb.broker.metadata.ClassDescriptor;
import ojb.broker.singlevm.PersistenceBrokerImpl;

public class SqlBasedRsIterator
extends RsIterator {
    protected SqlBasedRsIterator() {
    }

    public SqlBasedRsIterator(ClassDescriptor cld, String sqlStatement, PersistenceBrokerImpl broker) throws PersistenceBrokerException {
        this.m_rs = new JdbcAccess(broker).executeSQL(sqlStatement, cld);
        this.m_broker = broker;
        this.m_mif = cld;
        this.itemProxyClass = cld.getProxyClass();
        try {
            this.m_row = new Object[this.m_rs.getMetaData().getColumnCount()];
        }
        catch (SQLException ex) {
            throw new PersistenceBrokerException(ex);
        }
    }

    protected Object getObjectFromResultSet() throws PersistenceBrokerException {
        try {
            return super.getObjectFromResultSet();
        }
        catch (PersistenceBrokerException e) {
            Identity oid = this.getIdentityFromResultSet();
            return this.m_broker.getObjectByIdentity(oid);
        }
    }
}

