/*
 * Decompiled with CFR 0.152.
 */
package ojb.odmg;

import ojb.broker.Identity;
import ojb.broker.PersistenceBroker;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.PersistenceBrokerFactory;
import ojb.broker.metadata.ClassDescriptor;
import ojb.broker.metadata.ClassNotPersistenceCapableException;
import ojb.odmg.NamedRootsMap;
import ojb.odmg.OJB;
import ojb.odmg.TransactionImpl;
import org.odmg.Database;
import org.odmg.DatabaseNotFoundException;
import org.odmg.ODMGException;
import org.odmg.ODMGRuntimeException;
import org.odmg.ObjectNameNotFoundException;
import org.odmg.ObjectNameNotUniqueException;
import org.odmg.Transaction;
import org.odmg.TransactionNotInProgressException;

public class DatabaseImpl
implements Database {
    private PersistenceBroker broker = null;
    private NamedRootsMap nrm = NamedRootsMap.getInstance();

    public void open(String name, int accessMode) throws ODMGException {
        try {
            this.broker = PersistenceBrokerFactory.createPersistenceBroker(name);
        }
        catch (Throwable ex) {
            throw new DatabaseNotFoundException("OJB can't open repository " + name + "\n" + ex.getMessage());
        }
    }

    public void close() throws ODMGException {
        OJB.getInstance().setCurrentDatabase(null);
    }

    public void bind(Object object, String name) throws ObjectNameNotUniqueException {
        Identity identity = new Identity(object);
        this.makePersistent(object);
        this.nrm.put(name, identity);
        TransactionImpl tx = (TransactionImpl)OJB.getInstance().currentTransaction();
        if (tx != null) {
            tx.putNrmEntry(name, identity);
        }
    }

    public Object lookup(String name) throws ObjectNameNotFoundException {
        Identity oid = this.nrm.get(name);
        if (oid == null) {
            oid = this.lookupInTransactionsMap(name);
        }
        if (oid != null) {
            try {
                Object result = this.broker.getObjectByIdentity(oid);
                if (result != null) {
                    OJB.getInstance().currentTransaction().lock(result, 1);
                }
                return result;
            }
            catch (PersistenceBrokerException ex) {
                throw new ObjectNameNotFoundException("Error in lookup of: " + name + ", " + ex.getMessage());
            }
        }
        throw new ObjectNameNotFoundException("Name not found: " + name);
    }

    public void unbind(String name) throws ObjectNameNotFoundException {
        boolean failedPersistent = false;
        boolean failedCurrentTx = false;
        TransactionImpl tx = (TransactionImpl)OJB.getInstance().currentTransaction();
        if (tx != null && !tx.unbindNrmEntry(name)) {
            failedCurrentTx = true;
        }
        try {
            this.nrm.unbind(name);
        }
        catch (ObjectNameNotFoundException ex) {
            failedPersistent = true;
        }
        if (failedCurrentTx && failedPersistent) {
            throw new ObjectNameNotFoundException("don't know about " + name);
        }
    }

    public void makePersistent(Object object) {
        try {
            ClassDescriptor cld = this.getBroker().getClassDescriptor(object.getClass());
            Transaction tx = OJB.getInstance().currentTransaction();
            if (tx == null) {
                throw new TransactionNotInProgressException();
            }
            tx.lock(object, 4);
        }
        catch (ClassNotPersistenceCapableException ex) {
            throw new org.odmg.ClassNotPersistenceCapableException(ex.getMessage());
        }
        catch (Throwable t) {
            throw new ODMGRuntimeException();
        }
    }

    public void deletePersistent(Object object) {
        TransactionImpl tx = (TransactionImpl)OJB.getInstance().currentTransaction();
        if (tx == null) {
            throw new TransactionNotInProgressException();
        }
        tx.lock(object, 4);
        tx.markDelete(object);
    }

    public NamedRootsMap getNamedRootsMap() {
        return this.nrm;
    }

    PersistenceBroker getBroker() {
        return this.broker;
    }

    private Identity lookupInTransactionsMap(String name) {
        TransactionImpl tx = (TransactionImpl)OJB.getInstance().currentTransaction();
        if (tx == null) {
            return null;
        }
        return tx.getNrmEntry(name);
    }
}

