/*
 * Decompiled with CFR 0.152.
 */
package ojb.odmg.states;

import ojb.broker.PersistenceBroker;
import ojb.broker.PersistenceBrokerException;
import ojb.odmg.ObjectEnvelope;
import ojb.odmg.states.ModificationState;
import ojb.odmg.states.StateNewClean;
import ojb.odmg.states.StateNewDelete;
import ojb.odmg.states.StateOldClean;
import ojb.odmg.states.StateOldDirty;

public class StateNewDirty
extends ModificationState {
    private static StateNewDirty _instance = new StateNewDirty();

    public ModificationState markClean() {
        return StateNewClean.getInstance();
    }

    public ModificationState markDelete() {
        return StateNewDelete.getInstance();
    }

    public ModificationState markDirty() {
        return this;
    }

    public ModificationState markNew() {
        return this;
    }

    public ModificationState markOld() {
        return StateOldDirty.getInstance();
    }

    private StateNewDirty() {
    }

    public static StateNewDirty getInstance() {
        return _instance;
    }

    public boolean needsInsert() {
        return true;
    }

    public void checkpoint(ObjectEnvelope mod, PersistenceBroker broker) throws PersistenceBrokerException {
        broker.store(mod.getObject(), mod);
        mod.manage(mod.getObject());
        mod.setModificationState(StateOldClean.getInstance());
    }

    public void commit(ObjectEnvelope mod, PersistenceBroker broker) throws PersistenceBrokerException {
        broker.store(mod.getObject(), mod);
        mod.manage(mod.getObject());
        mod.setModificationState(StateOldClean.getInstance());
    }

    public void rollback(ObjectEnvelope mod, PersistenceBroker broker) {
        this.removeFromCache(mod.getObject(), broker);
    }
}

