/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.timeline;

import com.aimluck.eip.cayenne.om.portlet.EipTTimeline;
import com.aimluck.eip.cayenne.om.portlet.EipTTimelineLike;
import com.aimluck.eip.cayenne.om.social.Activity;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.timeline.TimelineFormData;
import com.aimluck.eip.timeline.TimelineLikeSelectData;
import com.aimluck.eip.timeline.util.TimelineUtils;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class TimelineLikeFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)TimelineFormData.class.getName());
    private int user_id;
    private int timeline_id;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.user_id = ALEipUtils.getUserId((RunData)rundata);
    }

    public void initField() {
    }

    protected void setValidator() {
    }

    protected boolean validate(List<String> msgList) {
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        try {
            int parentid = Integer.parseInt(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid"));
            EipTTimeline parent = (EipTTimeline)Database.get(EipTTimeline.class, (Object)parentid);
            List<EipTTimelineLike> list = TimelineUtils.getEipTTimelineLikeListToDeleteTopic(rundata, context, false);
            if (list == null) {
                logger.debug((Object)"[TimelineFormData] Not found List...");
                throw new ALPageNotFoundException();
            }
            ArrayList<Integer> topicIdList = new ArrayList<Integer>();
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                EipTTimelineLike topic = list.get(i);
                topicIdList.add(topic.getTimelineLikeId());
            }
            SelectQuery query = Database.query(EipTTimelineLike.class);
            Expression exp = ExpressionFactory.inDbExp((String)"TIMELINE_LIKE_ID", topicIdList);
            query.setQualifier(exp);
            List topics = query.fetchList();
            Database.deleteAll((List)topics);
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(parent.getTimelineId().intValue(), 330, TimelineUtils.compressString(parent.getNote()));
        }
        catch (Exception e) {
            Database.rollback();
            logger.error((Object)"[TimelineSelectData]", (Throwable)e);
            throw new ALDBErrorException();
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            SelectQuery query = Database.query(EipTTimelineLike.class);
            Expression exp1 = ExpressionFactory.matchExp((String)"ownerId", (Object)this.user_id);
            Expression exp2 = ExpressionFactory.matchExp((String)"timelineId", (Object)this.timeline_id);
            query.setQualifier(exp1);
            query.andQualifier(exp2);
            List fetchList = query.fetchList();
            int count = fetchList.size();
            if (count == 0) {
                EipTTimelineLike like = (EipTTimelineLike)Database.create(EipTTimelineLike.class);
                like.setOwnerId(Integer.valueOf(this.user_id));
                like.setTimelineId(Integer.valueOf(this.timeline_id));
                like.setCreateDate(Calendar.getInstance().getTime());
                Database.commit();
                if (like.getOwnerId() != 0) {
                    EipTTimeline parententry = TimelineUtils.getEipTTimelineParentEntry(rundata, context);
                    TimelineLikeSelectData likelist = new TimelineLikeSelectData();
                    String loginName = ALEipUtils.getALEipUser((int)this.user_id).getName().getValue();
                    String targetLoginName = ALEipUtils.getALEipUser((int)parententry.getOwnerId()).getName().getValue();
                    if (likelist.getLikeList(this.timeline_id).size() > 1 && !loginName.equals(targetLoginName)) {
                        ALEipUser lastuser = ALEipUtils.getALEipUser((String)loginName);
                        String lastuserName = lastuser.getAliasName().getValue();
                        loginName = ALLocalizationUtils.getl10nFormat((String)"TIMELINE_OTHER", (Object[])new Object[]{lastuserName, likelist.getLikeList(this.timeline_id).size() - 1});
                        SelectQuery dQuery = Database.query(Activity.class);
                        Expression exp3 = ExpressionFactory.matchExp((String)"externalId", (Object)String.valueOf(parententry.getTimelineId()));
                        Expression exp4 = ExpressionFactory.matchExp((String)"appId", (Object)"timeline");
                        dQuery.setQualifier(exp3);
                        dQuery.andQualifier(exp4);
                        List maps = dQuery.fetchList();
                        Database.deleteAll((List)maps);
                        Database.commit();
                    }
                    TimelineUtils.createNewLikeActivity(parententry, loginName, targetLoginName);
                }
            }
        }
        catch (RuntimeException ex) {
            Database.rollback();
            logger.error((Object)"timeline", (Throwable)ex);
            return false;
        }
        catch (ALDBErrorException ex) {
            Database.rollback();
            logger.error((Object)"timeline", (Throwable)ex);
            return false;
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"timeline", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        return res;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        return false;
    }

    public int getUser_id() {
        return this.user_id;
    }

    public void setUser_id(int user_id) {
        this.user_id = user_id;
    }

    public int getTimeline_id() {
        return this.timeline_id;
    }

    public void setTimeline_id(int timeline_id) {
        this.timeline_id = timeline_id;
    }
}

