/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.system;

import com.aimluck.eip.blog.util.BlogUtils;
import com.aimluck.eip.cabinet.util.CabinetUtils;
import com.aimluck.eip.category.util.CommonCategoryUtils;
import com.aimluck.eip.cayenne.om.account.EipMPosition;
import com.aimluck.eip.cayenne.om.account.EipMPost;
import com.aimluck.eip.cayenne.om.portlet.EipMAddressbook;
import com.aimluck.eip.cayenne.om.portlet.EipMAddressbookCompany;
import com.aimluck.eip.cayenne.om.portlet.EipMFacility;
import com.aimluck.eip.cayenne.om.portlet.EipMMailAccount;
import com.aimluck.eip.cayenne.om.portlet.EipTBlog;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogComment;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogEntry;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogFile;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogFootmarkMap;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogThema;
import com.aimluck.eip.cayenne.om.portlet.EipTCabinetFile;
import com.aimluck.eip.cayenne.om.portlet.EipTCabinetFolder;
import com.aimluck.eip.cayenne.om.portlet.EipTCommonCategory;
import com.aimluck.eip.cayenne.om.portlet.EipTMail;
import com.aimluck.eip.cayenne.om.portlet.EipTMemo;
import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardCategory;
import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardFile;
import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardTopic;
import com.aimluck.eip.cayenne.om.portlet.EipTNote;
import com.aimluck.eip.cayenne.om.portlet.EipTNoteMap;
import com.aimluck.eip.cayenne.om.portlet.EipTSchedule;
import com.aimluck.eip.cayenne.om.portlet.EipTScheduleMap;
import com.aimluck.eip.cayenne.om.portlet.EipTTimecard;
import com.aimluck.eip.cayenne.om.portlet.EipTTimeline;
import com.aimluck.eip.cayenne.om.portlet.EipTTimelineFile;
import com.aimluck.eip.cayenne.om.portlet.EipTTimelineLike;
import com.aimluck.eip.cayenne.om.portlet.EipTTimelineMap;
import com.aimluck.eip.cayenne.om.portlet.EipTTimelineUrl;
import com.aimluck.eip.cayenne.om.portlet.EipTTodo;
import com.aimluck.eip.cayenne.om.portlet.EipTTodoCategory;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowRequest;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowRequestMap;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.cayenne.om.security.TurbineUserGroupRole;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALEipUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.om.profile.Entry;
import org.apache.jetspeed.om.profile.Parameter;
import org.apache.jetspeed.om.profile.Portlets;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.profile.ProfileException;
import org.apache.jetspeed.om.profile.psml.PsmlParameter;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.security.JetspeedSecurityException;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class SystemDeleteSampleFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)SystemDeleteSampleFormData.class.getName());
    protected List<String> fpaths = null;
    protected static final String FOLDER_FILEDIR = JetspeedResources.getString((String)"aipo.filedir", (String)"");
    protected static final String FOLDER_MAILDIR = JetspeedResources.getString((String)"aipo.mail.home", (String)"");
    private String orgId;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.orgId = Database.getDomainName();
    }

    public void initField() {
    }

    protected void setValidator() {
    }

    protected boolean validate(List<String> msgList) {
        return true;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            ArrayList<Integer> ids = new ArrayList<Integer>();
            ids.add(4);
            ids.add(5);
            ids.add(6);
            this.fpaths = new ArrayList<String>();
            this.updateBlog(ids);
            this.updateAddressbook(ids);
            this.updateMailaccount(ids);
            this.updateCabinet(ids);
            this.updateMail(ids);
            if (ids != null && ids.size() > 0) {
                int size = ids.size();
                for (int i = 0; i < size; ++i) {
                    this.fpaths.add(FOLDER_MAILDIR + File.separator + this.orgId + File.separator + ((Integer)ids.get(i)).toString());
                }
            }
            this.updateMemo(ids);
            this.updateMsgboard(ids);
            this.updateNote(ids);
            this.updateTimecard(ids);
            this.updateTimeline(ids);
            this.updateTodo(ids);
            this.updateSchedule(ids);
            this.updateWorkflow(ids);
            Database.commit();
            this.deleteFiles(this.fpaths);
            this.updateUserhidden(ids);
            ALEipManager.getInstance().reloadPost();
            ALEipManager.getInstance().reloadCompany();
            ALEipManager.getInstance().reloadPosition();
            this.updateFlag(rundata);
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"system", (Throwable)ex);
            return false;
        }
        return true;
    }

    private void updateCabinet(List<Integer> ids) {
        SelectQuery query = Database.query(EipTCabinetFolder.class);
        Expression exp1 = ExpressionFactory.inExp((String)"createUserId", ids);
        query.setQualifier(exp1);
        List list = query.fetchList();
        for (EipTCabinetFolder folder : list) {
            Integer folderId = folder.getFolderId();
            SelectQuery query1 = Database.query(EipTCabinetFolder.class);
            exp1 = ExpressionFactory.matchDbExp((String)"FOLDER_ID", (Object)folderId);
            Expression exp2 = ExpressionFactory.matchExp((String)"parentId", (Object)folderId);
            query1.setQualifier(exp1.orExp(exp2));
            List list1 = query1.fetchList();
            ArrayList<Integer> folderids = new ArrayList<Integer>();
            for (EipTCabinetFolder folder2 : list1) {
                folderids.add(folder2.getFolderId());
            }
            SelectQuery delfolderquery = Database.query(EipTCabinetFolder.class);
            Expression delfolderexp = ExpressionFactory.inDbExp((String)"FOLDER_ID", folderids);
            delfolderquery.setQualifier(delfolderexp);
            List delFolderList = delfolderquery.fetchList();
            for (EipTCabinetFolder delfolder : delFolderList) {
                List cabinetfiles = CabinetUtils.getEipTCabinetFileList((int)delfolder.getFolderId());
                if (cabinetfiles != null && cabinetfiles.size() > 0) {
                    int tsize = cabinetfiles.size();
                    for (int k = 0; k < tsize; ++k) {
                        this.fpaths.add(((EipTCabinetFile)cabinetfiles.get(k)).getFilePath());
                    }
                }
                Database.delete((Persistent)delfolder);
            }
        }
    }

    private void updateFlag(RunData rundata) throws ProfileException {
        String portletEntryId = rundata.getParameters().getString("js_peid", null);
        String FLAG = "desa";
        Profile profile = ((JetspeedRunData)rundata).getProfile();
        Portlets portlets = profile.getDocument().getPortlets();
        Portlets[] portletList = portlets.getPortletsArray();
        PsmlParameter param = null;
        Parameter[] params = null;
        boolean hasParam = false;
        Entry[] entries = portletList[0].getEntriesArray();
        Entry entry = null;
        int ent_length = entries.length;
        for (int j = 0; j < ent_length; ++j) {
            entry = entries[j];
            if (!entry.getId().equals(portletEntryId)) continue;
            params = entry.getParameter();
            int param_len = params.length;
            for (int k = 0; k < param_len; ++k) {
                if (!params[k].getName().equals(FLAG)) continue;
                params[k].setValue("1");
                entry.setParameter(k, params[k]);
                hasParam = true;
            }
            if (hasParam) break;
            param = new PsmlParameter();
            param.setName(FLAG);
            param.setValue("1");
            entries[j].addParameter((Parameter)param);
            break;
        }
        profile.store();
    }

    private void updateBlog(List<Integer> ids) {
        SelectQuery blogquery2 = Database.query(EipTBlogFootmarkMap.class);
        Expression blogexp2 = ExpressionFactory.inExp((String)"userId", ids);
        blogquery2.setQualifier(blogexp2);
        List bloglist2 = blogquery2.fetchList();
        if (bloglist2 != null && bloglist2.size() > 0) {
            Database.deleteAll((List)bloglist2);
        }
        SelectQuery blogquery3 = Database.query(EipTBlogFile.class);
        Expression blogexp3 = ExpressionFactory.inExp((String)"ownerId", ids);
        blogquery3.setQualifier(blogexp3);
        List Bloglist3 = blogquery3.fetchList();
        if (Bloglist3 != null && Bloglist3.size() > 0) {
            for (EipTBlogFile file : Bloglist3) {
                this.fpaths.add(SystemDeleteSampleFormData.getSaveDirPath(this.orgId, file.getOwnerId(), FOLDER_FILEDIR, "blog") + file.getFilePath());
            }
        }
        if (Bloglist3 != null && Bloglist3.size() > 0) {
            Database.deleteAll((List)Bloglist3);
        }
        SelectQuery blogquery4 = Database.query(EipTBlogComment.class);
        Expression blogexp4 = ExpressionFactory.inExp((String)"ownerId", ids);
        blogquery4.setQualifier(blogexp4);
        List bloglist4 = blogquery4.fetchList();
        if (bloglist4 != null && bloglist4.size() > 0) {
            Database.deleteAll((List)bloglist4);
        }
        ArrayList<EipTBlogThema> deleteThemeList = new ArrayList<EipTBlogThema>();
        SelectQuery Blogquery5 = Database.query(EipTBlogEntry.class);
        Expression blogexp5 = ExpressionFactory.inExp((String)"ownerId", ids);
        Blogquery5.setQualifier(blogexp5);
        List bloglist5 = Blogquery5.fetchList();
        if (bloglist5 != null && bloglist5.size() > 0) {
            for (Object entry : bloglist5) {
                EipTBlogThema theme = entry.getEipTBlogThema();
                if (theme.getThemaId().equals(1)) continue;
                deleteThemeList.add(theme);
            }
            Database.deleteAll((List)bloglist5);
            if (deleteThemeList.size() > 0) {
                ArrayList<Integer> themeIds = new ArrayList<Integer>();
                for (EipTBlogThema theme : deleteThemeList) {
                    themeIds.add(theme.getThemaId());
                }
                Expression themaExp = ExpressionFactory.inExp((String)"eipTBlogThema", themeIds);
                SelectQuery themaQuery = Database.query(EipTBlogEntry.class, (Expression)themaExp);
                List themaEntry = themaQuery.fetchList();
                EipTBlogThema defaultThema = BlogUtils.getEipTBlogThema((Long)1L);
                for (EipTBlogEntry entry : themaEntry) {
                    entry.setEipTBlogThema(defaultThema);
                }
                Database.deleteAll(deleteThemeList);
            }
        }
        SelectQuery blogquery6 = Database.query(EipTBlog.class);
        Expression blogexp6 = ExpressionFactory.inExp((String)"ownerId", ids);
        blogquery6.setQualifier(blogexp6);
        List bloglist6 = blogquery6.fetchList();
        if (bloglist6 != null && bloglist6.size() > 0) {
            Database.deleteAll((List)bloglist6);
        }
    }

    private void updateAddressbook(List<Integer> ids) {
        SelectQuery addressquery1 = Database.query(EipMAddressbookCompany.class);
        Expression addressexp1 = ExpressionFactory.inExp((String)"createUserId", ids);
        addressquery1.setQualifier(addressexp1);
        List addresslist1 = addressquery1.fetchList();
        if (addresslist1 != null && addresslist1.size() > 0) {
            Database.deleteAll((List)addresslist1);
        }
        SelectQuery addressquery2 = Database.query(EipMAddressbook.class);
        Expression addressexp2 = ExpressionFactory.inExp((String)"ownerId", ids);
        addressquery2.setQualifier(addressexp2);
        List addresslist2 = addressquery2.fetchList();
        if (addresslist2 != null && addresslist2.size() > 0) {
            Database.deleteAll((List)addresslist2);
        }
    }

    private void updateMailaccount(List<Integer> ids) {
        SelectQuery mailquery1 = Database.query(EipMMailAccount.class);
        Expression mailexp1 = ExpressionFactory.inExp((String)"userId", ids);
        mailquery1.setQualifier(mailexp1);
        List maillist1 = mailquery1.fetchList();
        if (maillist1 != null && maillist1.size() > 0) {
            Database.deleteAll((List)maillist1);
        }
    }

    private void updateMail(List<Integer> ids) {
        SelectQuery mailquery1 = Database.query(EipTMail.class);
        Expression mailexp1 = ExpressionFactory.inExp((String)"userId", ids);
        mailquery1.setQualifier(mailexp1);
        List maillist1 = mailquery1.fetchList();
        if (maillist1 != null && maillist1.size() > 0) {
            Database.deleteAll((List)maillist1);
        }
    }

    private void updateMemo(List<Integer> ids) {
        SelectQuery memoquery1 = Database.query(EipTMemo.class);
        Expression memoexp1 = ExpressionFactory.inExp((String)"ownerId", ids);
        memoquery1.setQualifier(memoexp1);
        List memolist1 = memoquery1.fetchList();
        if (memolist1 != null && memolist1.size() > 0) {
            Database.deleteAll((List)memolist1);
        }
    }

    private void updateMsgboard(List<Integer> ids) {
        Expression topicExp;
        SelectQuery topicQuery;
        List topicList;
        Expression fileExp = ExpressionFactory.inExp((String)"ownerId", ids);
        SelectQuery fileQuery = Database.query(EipTMsgboardFile.class, (Expression)fileExp);
        List fileList = fileQuery.fetchList();
        if (fileList != null && fileList.size() > 0) {
            for (EipTMsgboardFile file : fileList) {
                this.fpaths.add(SystemDeleteSampleFormData.getSaveDirPath(this.orgId, file.getOwnerId(), FOLDER_FILEDIR, "msgboard") + file.getFilePath());
            }
            Database.deleteAll((List)fileList);
        }
        if ((topicList = (topicQuery = Database.query(EipTMsgboardTopic.class, (Expression)(topicExp = ExpressionFactory.inExp((String)"ownerId", ids)))).fetchList()) != null && topicList.size() > 0) {
            Database.deleteAll((List)topicList);
        }
        Expression defaultCategoryExp = ExpressionFactory.matchDbExp((String)"CATEGORY_ID", (Object)1);
        SelectQuery defaultCategoryQuery = Database.query(EipTMsgboardCategory.class, (Expression)defaultCategoryExp);
        EipTMsgboardCategory defaultCategory = (EipTMsgboardCategory)defaultCategoryQuery.fetchSingle();
        SelectQuery categoryQuery = Database.query(EipTMsgboardCategory.class);
        List categoryList = categoryQuery.fetchList();
        ArrayList<Integer> categoryIdList = new ArrayList<Integer>();
        ArrayList<EipTMsgboardCategory> deleteCategoryList = new ArrayList<EipTMsgboardCategory>();
        if (categoryList != null && categoryList.size() > 0) {
            for (EipTMsgboardCategory category : categoryList) {
                if (!ids.contains(category.getTurbineUser().getUserId()) || categoryIdList.contains(category.getCategoryId())) continue;
                categoryIdList.add(category.getCategoryId());
                deleteCategoryList.add(category);
            }
        }
        if (categoryIdList.size() > 0) {
            Expression deletedCategoryTopicExp = ExpressionFactory.inExp((String)"eipTMsgboardCategory", categoryIdList);
            SelectQuery deletedCategoryTopicQuery = Database.query(EipTMsgboardTopic.class, (Expression)deletedCategoryTopicExp);
            List deletedCategoryTopicList = deletedCategoryTopicQuery.fetchList();
            for (EipTMsgboardTopic topic : deletedCategoryTopicList) {
                topic.setEipTMsgboardCategory(defaultCategory);
            }
            Database.deleteAll(deleteCategoryList);
        }
    }

    private void updateNote(List<Integer> ids) {
        SelectQuery notequery1 = Database.query(EipTNote.class);
        Expression noteexp1 = ExpressionFactory.inExp((String)"ownerId", ids);
        notequery1.setQualifier(noteexp1);
        List notelist1 = notequery1.fetchList();
        if (notelist1 != null && notelist1.size() > 0) {
            Database.deleteAll((List)notelist1);
        }
        SelectQuery notequery2 = Database.query(EipTNoteMap.class);
        Expression noteexp2 = ExpressionFactory.inExp((String)"userId", ids);
        notequery2.setQualifier(noteexp2);
        List notelist2 = notequery2.fetchList();
        if (notelist2 != null && notelist2.size() > 0) {
            Database.deleteAll((List)notelist2);
        }
    }

    private void updateTimecard(List<Integer> ids) {
        SelectQuery timecardquery1 = Database.query(EipTTimecard.class);
        Expression timecardexp1 = ExpressionFactory.inExp((String)"userId", ids);
        timecardquery1.setQualifier(timecardexp1);
        List timecardlist1 = timecardquery1.fetchList();
        if (timecardlist1 != null && timecardlist1.size() > 0) {
            Database.deleteAll((List)timecardlist1);
        }
    }

    private void updateTimeline(List<Integer> ids) {
        SelectQuery timelineQuery1 = Database.query(EipTTimeline.class);
        Expression timelineExp1 = ExpressionFactory.inExp((String)"ownerId", ids);
        timelineQuery1.setQualifier(timelineExp1);
        List timelineList1 = timelineQuery1.fetchList();
        ArrayList<Integer> timelineIds = new ArrayList<Integer>();
        if (timelineList1 != null && timelineList1.size() > 0) {
            for (EipTTimeline tmp : timelineList1) {
                timelineIds.add(tmp.getTimelineId());
            }
            SelectQuery timelineQuery2 = Database.query(EipTTimeline.class);
            Expression timelineExp2 = ExpressionFactory.inDbExp((String)"PARENT_ID", timelineIds);
            timelineQuery2.setQualifier(timelineExp2);
            List timelineList2 = timelineQuery2.fetchList();
            for (EipTTimeline tmp : timelineList2) {
                timelineIds.add(tmp.getTimelineId());
            }
            timelineList1.addAll(timelineList2);
            if (timelineList1.size() > 0) {
                SelectQuery timelineFileQuery1 = Database.query(EipTTimelineFile.class);
                Expression timelineFileExp1 = ExpressionFactory.inExp((String)"ownerId", ids);
                timelineFileQuery1.setQualifier(timelineFileExp1);
                List timelineFileList1 = timelineFileQuery1.fetchList();
                if (timelineFileList1 != null && timelineFileList1.size() > 0) {
                    Database.deleteAll((List)timelineFileList1);
                }
                SelectQuery timelineMapQuery1 = Database.query(EipTTimelineMap.class);
                Expression timelineMapExp1 = ExpressionFactory.inExp((String)"eipTTimeline", ids);
                timelineMapQuery1.setQualifier(timelineMapExp1);
                List timelineMapList1 = timelineMapQuery1.fetchList();
                if (timelineMapList1 != null && timelineMapList1.size() > 0) {
                    Database.deleteAll((List)timelineMapList1);
                }
                SelectQuery timelineUrlQuery1 = Database.query(EipTTimelineUrl.class);
                Expression timelineUrlExp1 = ExpressionFactory.inExp((String)"timelineId", timelineIds);
                timelineUrlQuery1.setQualifier(timelineUrlExp1);
                List timelineUrlList1 = timelineUrlQuery1.fetchList();
                if (timelineUrlList1 != null && timelineUrlList1.size() > 0) {
                    Database.deleteAll((List)timelineUrlList1);
                }
                SelectQuery timelineLikeQuery1 = Database.query(EipTTimelineLike.class);
                Expression timelineLikeExp1 = ExpressionFactory.inDbExp((String)"OWNER_ID", ids);
                Expression timelineLikeExp2 = ExpressionFactory.inDbExp((String)"TIMELINE_ID", timelineIds);
                timelineLikeQuery1.setQualifier(timelineLikeExp1.orExp(timelineLikeExp2));
                List timelineLikeList1 = timelineLikeQuery1.fetchList();
                if (timelineLikeList1 != null && timelineLikeList1.size() > 0) {
                    Database.deleteAll((List)timelineLikeList1);
                }
                Database.deleteAll((List)timelineList1);
            }
        }
    }

    private void updateTodo(List<Integer> ids) {
        SelectQuery todoquery1 = Database.query(EipTTodoCategory.class);
        Expression todoexp1 = ExpressionFactory.inExp((String)"userId", ids);
        todoquery1.setQualifier(todoexp1);
        List todolist1 = todoquery1.fetchList();
        if (todolist1 != null && todolist1.size() > 0) {
            Database.deleteAll((List)todolist1);
        }
        SelectQuery todoquery2 = Database.query(EipTTodo.class);
        Expression todoexp2 = ExpressionFactory.inExp((String)"userId", ids);
        todoquery2.setQualifier(todoexp2);
        List todolist2 = todoquery2.fetchList();
        if (todolist2 != null && todolist2.size() > 0) {
            Database.deleteAll((List)todolist2);
        }
    }

    private void updateSchedule(List<Integer> ids) {
        ArrayList<Integer> deleteFacilityId = new ArrayList<Integer>();
        SelectQuery schedulequery1 = Database.query(EipTSchedule.class);
        Expression scheduleexp1 = ExpressionFactory.inExp((String)"ownerId", ids);
        schedulequery1.setQualifier(scheduleexp1);
        List schedulelist1 = schedulequery1.fetchList();
        if (schedulelist1 != null && schedulelist1.size() > 0) {
            Database.deleteAll((List)schedulelist1);
        }
        SelectQuery schedulequery2 = Database.query(EipTScheduleMap.class);
        Expression scheduleexp2 = ExpressionFactory.inExp((String)"userId", ids);
        schedulequery2.setQualifier(scheduleexp2);
        List schedulelist2 = schedulequery2.fetchList();
        if (schedulelist2 != null && schedulelist2.size() > 0) {
            Expression fexp;
            SelectQuery query;
            List flist;
            for (EipTScheduleMap map : schedulelist2) {
                List maps = map.getEipTSchedule().getEipTScheduleMaps();
                for (EipTScheduleMap map2 : maps) {
                    if (!map2.getType().equals("F")) continue;
                    deleteFacilityId.add(map2.getUserId());
                }
                EipTCommonCategory commonCat = map.getEipTCommonCategory();
                if (commonCat.getCommonCategoryId().equals(1)) continue;
                CommonCategoryUtils.setDefaultCommonCategoryToSchedule((EipTCommonCategory)commonCat);
                Database.delete((Persistent)commonCat);
            }
            Database.deleteAll((List)schedulelist2);
            if (deleteFacilityId.size() > 0 && (flist = (query = Database.query(EipMFacility.class, (Expression)(fexp = ExpressionFactory.inDbExp((String)"FACILITY_ID", deleteFacilityId)))).fetchList()).size() > 0) {
                SelectQuery query1 = Database.query(EipTScheduleMap.class);
                Expression exp1 = ExpressionFactory.inExp((String)"userId", deleteFacilityId);
                Expression exp2 = ExpressionFactory.matchExp((String)"type", (Object)"F");
                query1.setQualifier(exp1.andExp(exp2));
                query1.deleteAll();
                Database.deleteAll((List)flist);
            }
        }
    }

    private void updateWorkflow(List<Integer> ids) {
        SelectQuery workquery1 = Database.query(EipTWorkflowRequestMap.class);
        Expression workexp1 = ExpressionFactory.inExp((String)"userId", ids);
        workquery1.setQualifier(workexp1);
        List worklist1 = workquery1.fetchList();
        if (worklist1 != null && worklist1.size() > 0) {
            Database.deleteAll((List)worklist1);
        }
        SelectQuery workquery2 = Database.query(EipTWorkflowRequest.class);
        Expression workexp2 = ExpressionFactory.inExp((String)"userId", ids);
        workquery2.setQualifier(workexp2);
        List worklist2 = workquery2.fetchList();
        if (worklist2 != null && worklist2.size() > 0) {
            Database.deleteAll((List)worklist2);
        }
    }

    private void deleteFiles(List<String> fpaths) {
        if (fpaths == null) {
            return;
        }
        if (fpaths.size() > 0) {
            File file = null;
            for (String path : fpaths) {
                file = new File(path);
                if (!file.exists()) continue;
                this.deleteFolder(file);
            }
        }
    }

    protected boolean deleteFolder(File parent_folder) {
        boolean flag = true;
        try {
            String[] folders_path;
            if (!parent_folder.exists()) {
                return false;
            }
            if (parent_folder.isFile() && !parent_folder.delete()) {
                flag = false;
            }
            if ((folders_path = parent_folder.list()).length == 0) {
                return true;
            }
            int length = folders_path.length;
            for (int i = 0; i < length; ++i) {
                File folder = new File(parent_folder.getAbsolutePath() + File.separator + folders_path[i]);
                if (folder.isDirectory()) {
                    if (!this.deleteFolder(folder)) {
                        flag = false;
                        continue;
                    }
                    if (folder.delete()) continue;
                    flag = false;
                    continue;
                }
                if (folder.delete()) continue;
                flag = false;
            }
        }
        catch (Exception e) {
            logger.error((Object)"[SystemDeleteSampleFormData]", (Throwable)e);
            return false;
        }
        return flag;
    }

    public static String getSaveDirPath(String orgId, int uid, String filter, String type) {
        if (uid > 0) {
            return filter + File.separator + orgId + File.separator + type + File.separator + Integer.toString(uid);
        }
        return filter + File.separator + orgId + File.separator + type;
    }

    private void updateUserhidden(List<Integer> ids) throws JetspeedSecurityException {
        Expression exp;
        SelectQuery postQuery;
        List list;
        ArrayList<EipMPost> delpost = new ArrayList<EipMPost>();
        ArrayList<Integer> delpositionId = new ArrayList<Integer>();
        Expression gexp = ExpressionFactory.inDbExp((String)"USER_ID", ids);
        SelectQuery gquery = Database.query(TurbineUserGroupRole.class, (Expression)gexp);
        List map = gquery.fetchList();
        if (map != null && map.size() > 0) {
            for (TurbineUserGroupRole tugr : map) {
                EipMPost post = tugr.getTurbineGroup().getEipMPost();
                if (post == null || delpost.contains(post)) continue;
                delpost.add(post);
            }
            Database.deleteAll((List)map);
            if (delpost.size() > 0) {
                for (EipMPost post : delpost) {
                    List users = ALEipUtils.getUsers((String)post.getGroupName());
                    for (ALEipUser user : users) {
                        JetspeedSecurity.unjoinGroup((String)user.getName().getValue(), (String)post.getGroupName());
                    }
                    JetspeedSecurity.removeGroup((String)post.getGroupName());
                }
                Database.deleteAll(delpost);
            }
        }
        SelectQuery tquery = Database.query(TurbineUser.class);
        Expression texp = ExpressionFactory.inDbExp((String)"USER_ID", ids);
        tquery.setQualifier(texp);
        List tusers = tquery.fetchList();
        if (tusers != null && tusers.size() > 0) {
            for (TurbineUser tuser : tusers) {
                tuser.setDisabled("T");
                Integer positionId = tuser.getPositionId();
                if (positionId == null || positionId <= 0) continue;
                delpositionId.add(positionId);
            }
            Database.commit();
        }
        if (delpositionId.size() > 0 && (list = (postQuery = new SelectQuery(EipMPosition.class, exp = ExpressionFactory.inDbExp((String)"POSITION_ID", delpositionId))).fetchList()).size() > 0) {
            for (EipMPosition record : list) {
                int positionId = record.getPositionId();
                Database.delete((Persistent)record);
                String sql = "UPDATE turbine_user set POSITION_ID = 0 where POSITION_ID = " + positionId;
                Database.sql(TurbineUser.class, (String)sql).execute();
            }
        }
    }
}

