/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.system.util;

import com.aimluck.commons.utils.ALStringUtil;
import com.aimluck.eip.cayenne.om.portlet.EipMMailAccount;
import com.aimluck.eip.cayenne.om.portlet.EipTMailFilter;
import com.aimluck.eip.cayenne.om.portlet.EipTMailFolder;
import com.aimluck.eip.mail.ALMailFactoryService;
import com.aimluck.eip.mail.ALMailHandler;
import com.aimluck.eip.mail.ALMailReceiverContext;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.system.SystemWebMailFolderResultData;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class SystemWebMailUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)SystemWebMailUtils.class.getName());
    public static final String FOLDER_ID = "folderid";
    public static final String FILTER_ID = "filterid";
    public static final String TAB_RECEIVE = "receive";
    public static final String TAB_SENT = "sent";
    public static final String DATE_TIME_FORMAT = "yyyy/MM/dd HH:mm";
    public static final String CREATED_DATE_FORMAT = "yyyy/MM/dd";
    public static final String ACCOUNT_ID = "accountid";
    public static final String ACCOUNT_NAME = "accountname";
    public static final String MAIL_TYPE = "mailtype";
    public static final String CONFIRM_LAST_TIME = "confirmlasttime";
    public static final String FILTER_TYPE_MAILADDRESS = "M";
    public static final String FILTER_TYPE_DOMAIN = "D";
    public static final String FILTER_TYPE_SUBJECT = "S";
    public static final String FILTER_TYPE_TO = "T";
    public static final String WEBMAIL_PORTLET_NAME = "WebMail";
    public static final String WEBMAIL_ADMIN_PORTLET_NAME = "WebMailAdmin";
    public static final String UNREAD_MAIL = "unreadmailsummap";

    public static final List<EipMMailAccount> getMailAccountNameList(int userId) {
        SelectQuery query = Database.query(EipMMailAccount.class);
        query.select("ACCOUNT_ID");
        query.select("ACCOUNT_NAME");
        Expression exp = ExpressionFactory.matchExp((String)"userId", (Object)userId);
        return query.setQualifier(exp).fetchList();
    }

    public static boolean checkAddress(String argstr, String delim) {
        if (argstr == null || argstr.trim().length() == 0) {
            return false;
        }
        String[] addresses = ALMailUtils.getTokens((String)argstr, (String)delim);
        for (int i = 0; i < addresses.length; ++i) {
            String str = addresses[i].trim();
            if (str.length() == 0) continue;
            if (str.charAt(str.length() - 1) == '>') {
                int idx = str.indexOf("<");
                if (idx == -1) {
                    return false;
                }
                String address = str.substring(idx + 1, str.length() - 1);
                if (ALStringUtil.isCellPhoneMailAddress((String)address)) continue;
                return false;
            }
            if (ALStringUtil.isCellPhoneMailAddress((String)str)) continue;
            return false;
        }
        return true;
    }

    public static String checkUnusualChar(String str) {
        ArrayList<Character> unusualChars = new ArrayList<Character>();
        char[] unusualchars = new char[]{'\u2460', '\u2461', '\u2462', '\u2463', '\u2464', '\u2465', '\u2466', '\u2467', '\u2468', '\u2469', '\u246a', '\u246b', '\u246c', '\u246d', '\u246e', '\u246f', '\u2470', '\u2471', '\u2472', '\u2473', '\u2160', '\u2161', '\u2162', '\u2163', '\u2164', '\u2165', '\u2166', '\u2167', '\u2168', '\u2169', '\u3349', '\u3314', '\u3322', '\u334d', '\u3318', '\u3327', '\u3303', '\u3336', '\u3351', '\u3357', '\u330d', '\u30fb', '\u3323', '\u332b', '\u334a', '\u333b', '\u339c', '\u339d', '\u339e', '\u338e', '\u338f', '\u33c4', '\u33a1', '\u337b', '\u301d', '\u301f', '\u2116', '\u33cd', '\u2121', '\u32a4', '\u32a5', '\u32a6', '\u32a7', '\u32a8', '\u3231', '\u3232', '\u3239', '\u337e', '\u337d', '\u337c', '\u222e', '\u2211', '\u221f', '\u22bf'};
        int unusuallen = unusualchars.length;
        int length = str.length();
        Character cha = null;
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < unusuallen; ++j) {
                if (str.charAt(i) != unusualchars[j] || unusualChars.contains(cha = Character.valueOf(unusualchars[j]))) continue;
                unusualChars.add(cha);
            }
        }
        StringBuffer sb = new StringBuffer();
        if (unusualChars.size() < 1) {
            return null;
        }
        length = unusualChars.size() - 1;
        for (int i = 0; i < length; ++i) {
            sb.append("\"").append(unusualChars.get(i)).append("\"").append(",");
        }
        sb.append("\"").append(unusualChars.get(length)).append("\"");
        return sb.toString();
    }

    public static int getUnreadMailNumber(RunData rundata, int userId, int accountId) {
        String orgId = Database.getDomainName();
        EipMMailAccount account = ALMailUtils.getMailAccount((int)userId, (int)accountId);
        ALMailHandler handler = ALMailFactoryService.getInstance().getMailHandler();
        ALMailReceiverContext rcontext = ALMailUtils.getALPop3MailReceiverContext((String)orgId, (EipMMailAccount)account);
        return handler.getUnReadMailSum(rcontext);
    }

    public static Map<Integer, Integer> getUnreadMailNumberMap(RunData rundata, int userId, int accountId) {
        String orgId = Database.getDomainName();
        EipMMailAccount account = ALMailUtils.getMailAccount((int)userId, (int)accountId);
        ALMailHandler handler = ALMailFactoryService.getInstance().getMailHandler();
        ALMailReceiverContext rcontext = ALMailUtils.getALPop3MailReceiverContext((String)orgId, (EipMMailAccount)account);
        return handler.getUnReadMailSumMap(rcontext);
    }

    public static boolean isNewMessage(RunData rundata, Context context) {
        String accountId = rundata.getParameters().getString(ACCOUNT_ID);
        if (accountId == null || "".equals(accountId)) {
            return true;
        }
        EipMMailAccount account = ALMailUtils.getMailAccount((int)ALEipUtils.getUserId((RunData)rundata), (int)Integer.parseInt(accountId));
        String orgId = Database.getDomainName();
        ALMailHandler handler = ALMailFactoryService.getInstance().getMailHandler();
        ALMailReceiverContext rcontext = ALMailUtils.getALPop3MailReceiverContext((String)orgId, (EipMMailAccount)account);
        int res = -1;
        try {
            res = handler.getNewMailSum(rcontext);
        }
        catch (Exception e) {
            res = -1;
            logger.error((Object)"[SystemWebMailUtils]", (Throwable)e);
        }
        return res > 0;
    }

    public static EipTMailFolder getEipTMailFolder(RunData rundata, Context context) {
        try {
            int folderId;
            int accountId;
            try {
                accountId = Integer.parseInt(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)ACCOUNT_ID));
                folderId = Integer.parseInt(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)FOLDER_ID));
            }
            catch (Exception e) {
                logger.debug((Object)"[Mail] Empty ID...");
                return null;
            }
            SelectQuery query = Database.query(EipTMailFolder.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"FOLDER_ID", (Object)folderId);
            Expression exp2 = ExpressionFactory.matchDbExp((String)"eipMMailAccount.ACCOUNT_ID", (Object)accountId);
            EipTMailFolder folder = (EipTMailFolder)query.setQualifier(exp.andExp(exp2)).fetchSingle();
            if (folder == null) {
                logger.debug((Object)"[WebMail Folder] Not found ID...");
                return null;
            }
            return folder;
        }
        catch (Exception ex) {
            logger.error((Object)"system", (Throwable)ex);
            return null;
        }
    }

    public static EipTMailFolder getEipTMailFolder(EipMMailAccount account, String folderId) {
        try {
            Expression exp2;
            Expression exp;
            SelectQuery query;
            EipTMailFolder folder;
            if (account == null) {
                logger.debug((Object)"[WebMail Folder] Empty Account...");
                return null;
            }
            if (folderId == null || Integer.valueOf(folderId) == null) {
                folderId = account.getDefaultFolderId().toString();
            }
            if ((folder = (EipTMailFolder)(query = Database.query(EipTMailFolder.class)).setQualifier((exp = ExpressionFactory.matchDbExp((String)"FOLDER_ID", (Object)folderId)).andExp(exp2 = ExpressionFactory.matchDbExp((String)"eipMMailAccount", (Object)account))).fetchSingle()) == null) {
                logger.debug((Object)"[WebMail Folder] Not found ID...");
                return null;
            }
            return folder;
        }
        catch (Exception ex) {
            logger.error((Object)"system", (Throwable)ex);
            return null;
        }
    }

    public static EipTMailFilter getEipTMailFilter(EipMMailAccount account, String filterId) {
        try {
            Expression exp2;
            Expression exp;
            if (account == null) {
                logger.debug((Object)"[WebMail Filter] Empty Account...");
                return null;
            }
            SelectQuery query = Database.query(EipTMailFilter.class);
            EipTMailFilter filter = (EipTMailFilter)query.setQualifier((exp = ExpressionFactory.matchDbExp((String)"FILTER_ID", (Object)filterId)).andExp(exp2 = ExpressionFactory.matchDbExp((String)"eipMMailAccount", (Object)account))).fetchSingle();
            if (filter == null) {
                logger.debug((Object)"[WebMail Filter] Not found ID...");
                return null;
            }
            return filter;
        }
        catch (Exception ex) {
            logger.error((Object)"system", (Throwable)ex);
            return null;
        }
    }

    public static EipTMailFilter getEipTMailFilter(RunData rundata, Context context) {
        try {
            int filterId;
            int accountId;
            try {
                accountId = Integer.parseInt(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)ACCOUNT_ID));
                filterId = Integer.parseInt(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)FILTER_ID));
            }
            catch (Exception e) {
                logger.debug((Object)"[WebMail Filter] Empty ID...");
                return null;
            }
            SelectQuery query = Database.query(EipTMailFilter.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"FILTER_ID", (Object)filterId);
            Expression exp2 = ExpressionFactory.matchDbExp((String)"eipMMailAccount.ACCOUNT_ID", (Object)accountId);
            EipTMailFilter filter = (EipTMailFilter)query.setQualifier(exp.andExp(exp2)).fetchSingle();
            if (filter == null) {
                logger.debug((Object)"[WebMail Filter] Not found ID...");
                return null;
            }
            return filter;
        }
        catch (Exception ex) {
            logger.error((Object)"system", (Throwable)ex);
            return null;
        }
    }

    public static int getMailFilterLastSortOrder(EipMMailAccount account) {
        try {
            if (account == null) {
                logger.debug((Object)"[WebMail Filter] Empty Account...");
                return 0;
            }
            SelectQuery query = Database.query(EipTMailFilter.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"eipMMailAccount", (Object)account);
            query.setQualifier(exp).orderDesending("sortOrder");
            EipTMailFilter filter = (EipTMailFilter)query.fetchSingle();
            if (filter == null) {
                logger.debug((Object)"[WebMail Filter] Not found ID...");
                return 0;
            }
            return filter.getSortOrder();
        }
        catch (Exception ex) {
            logger.error((Object)"system", (Throwable)ex);
            return 0;
        }
    }

    public static HashMap<Integer, Integer> getUnreadMailSumMapFromString(String str) {
        HashMap<Integer, Integer> unreadSumMap = new HashMap<Integer, Integer>();
        try {
            String[] entries;
            for (String entry : entries = str.split("\\{")[1].split("\\}")[0].split(",")) {
                entry = entry.trim();
                String[] keyValue = entry.split("=");
                unreadSumMap.put((int)Integer.valueOf(keyValue[0]), (int)Integer.valueOf(keyValue[1]));
            }
            return unreadSumMap;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void clearWebMailAccountSession(RunData rundata, Context context) {
        ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)ACCOUNT_ID);
        ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)FOLDER_ID);
    }

    public static List<SystemWebMailFolderResultData> getMailFolderAll(EipMMailAccount account) {
        List folderList = ALMailUtils.getEipTMailFolderAll((EipMMailAccount)account);
        ArrayList<SystemWebMailFolderResultData> list = new ArrayList<SystemWebMailFolderResultData>();
        for (EipTMailFolder folder : folderList) {
            SystemWebMailFolderResultData data = new SystemWebMailFolderResultData(folder);
            list.add(data);
        }
        return list;
    }
}

