/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.mail;

import com.aimluck.eip.mail.ALMailMessage;
import com.aimluck.eip.mail.util.ALAttachmentsExtractor;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.mail.util.UnicodeCorrecter;
import com.aimluck.eip.services.storage.ALStorageService;
import com.sk_jp.mail.MailUtility;
import com.sk_jp.mail.MultipartUtility;
import com.sk_jp.mail.PartHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;

public class ALLocalMailMessage
extends MimeMessage
implements ALMailMessage {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALLocalMailMessage.class.getName());
    public static final String MESSAGE_ID = "Message-ID";
    public static final String RETURN_PATH = "Return-Path";
    public static final String DELIVERED_TO = "Delivered-To";
    public static final String RECEIVED = "Received";
    public static final String DATE = "Date";
    public static final String FROM = "From";
    public static final String MIME_VERSION = "MIME-Version";
    public static final String TO = "To";
    public static final String CC = "Cc";
    public static final String BCC = "Bcc";
    public static final String SUBJECT = "Subject";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_TRANSFER_ENCORDING = "Content-Transfer-Encoding";
    public static final String X_Mailer = "X-Mailer";
    public static final String X_Mailer_Value = "Groupware Aipo";
    public static final String X_AIPO_ATTACHMENT_FILE = "X-AIPO-Attachment-File";
    private String fileName = null;

    public ALLocalMailMessage(MimeMessage source, String fileName) throws MessagingException {
        super(source);
        this.fileName = fileName;
    }

    public ALLocalMailMessage(String fileName) throws MessagingException {
        super(Session.getDefaultInstance((Properties)new Properties()));
        this.fileName = fileName;
    }

    public ALLocalMailMessage(Session session) throws MessagingException {
        super(session);
    }

    public ALLocalMailMessage(Session session, InputStream is) throws MessagingException {
        super(session, is);
    }

    public String getMailMassageFileName() {
        return this.fileName;
    }

    public void addHeaderLine(String line) throws MessagingException {
        StringTokenizer st = new StringTokenizer(line, ":");
        if (!st.hasMoreTokens()) {
            return;
        }
        String key = st.nextToken();
        if (!st.hasMoreTokens()) {
            return;
        }
        String value = st.nextToken().trim();
        this.addHeader(key, value);
    }

    public void readMail(String folderPath) {
        try {
            this.parse(ALStorageService.getFile((String)(folderPath + ALStorageService.separator() + this.getMailMassageFileName())));
        }
        catch (Exception e) {
            logger.error((Object)"ALLocalMailMessage.readMail", (Throwable)e);
        }
    }

    public void saveMail(String folderPath) {
        try {
            ALStorageService.createNewFile((InputStream)this.getInputStream(), (String)folderPath, (String)this.getMailMassageFileName());
        }
        catch (Exception e) {
            logger.error((Object)"ALLocalMailMessage.saveMail", (Throwable)e);
        }
    }

    public void saveAttachmentFile(String folderPath, String fileName, byte[] fileBytes) {
        try {
            ALStorageService.createNewFile((InputStream)new ByteArrayInputStream(fileBytes), (String)folderPath, (String)fileName);
        }
        catch (Exception e) {
            logger.error((Object)"ALLocalMailMessage.saveAttachmentFile", (Throwable)e);
        }
    }

    public String getBodyText() {
        String text = null;
        try {
            String contentType = this.getContentType();
            this.setHeader(CONTENT_TYPE, contentType.replace("cp932", "Windows-31J"));
            text = MultipartUtility.getFirstPlainText((Part)this);
            this.setHeader(CONTENT_TYPE, contentType);
        }
        catch (Exception e) {
            logger.error((Object)"ALLocalMailMessage.getBodyText", (Throwable)e);
        }
        return text;
    }

    public String getHeader() {
        StringBuffer sb = new StringBuffer();
        try {
            Enumeration enu = this.getAllHeaderLines();
            while (enu.hasMoreElements()) {
                String line = (String)enu.nextElement();
                sb.append(MailUtility.decodeText((String)line)).append(ALMailUtils.CR);
            }
        }
        catch (Exception e) {
            logger.error((Object)"ALLocalMailMessage.getHeader", (Throwable)e);
            return "";
        }
        return UnicodeCorrecter.correctToCP932(sb.toString());
    }

    public String[] getHeaderArray() {
        return ALMailUtils.getLines(this.getHeader());
    }

    public String[] getBodyTextArray() {
        return ALMailUtils.getLines(this.getBodyText());
    }

    public String[] getAttachmentFileNameArray() {
        String[] filenames = null;
        ALAttachmentsExtractor h = new ALAttachmentsExtractor();
        try {
            MultipartUtility.process((Part)this, (PartHandler)h);
            filenames = h.getFileNames();
        }
        catch (Exception e) {
            logger.error((Object)"ALLocalMailMessage.getAttachmentFileNameArray", (Throwable)e);
            return null;
        }
        return filenames;
    }

    protected void updateHeaders() throws MessagingException {
        super.updateHeaders();
        this.setHeader(MESSAGE_ID, "<" + this.getMessageId() + ">");
    }

    private String getMessageId() {
        GregorianCalendar cal = new GregorianCalendar();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSS");
        sdf.setTimeZone(TimeZone.getDefault());
        String time = sdf.format(cal.getTime());
        Random random = new Random(cal.getTimeInMillis());
        int tmp = random.nextInt();
        int randomNumber = tmp != Integer.MIN_VALUE ? Math.abs(tmp) : Math.abs(tmp + 1);
        String smtpHostName = this.session.getProperty("mail.smtp.host");
        StringBuffer messageId = new StringBuffer();
        messageId.append(time).append(".").append(randomNumber).append("@").append(smtpHostName);
        return messageId.toString();
    }

    public String getSubject() throws MessagingException {
        String subject = UnicodeCorrecter.correctToCP932(MailUtility.decodeText((String)super.getSubject()));
        if (subject == null || subject.equals("")) {
            subject = "";
        }
        return subject;
    }

    public boolean isHtmlMail() {
        try {
            ALAttachmentsExtractor h = new ALAttachmentsExtractor();
            MultipartUtility.process((Part)this, (PartHandler)h);
            boolean hasAttachments = h.getCount() > 0;
            return hasAttachments;
        }
        catch (Exception e) {
            logger.error((Object)"ALLocalMailMessage.isHtmlMail", (Throwable)e);
            return false;
        }
    }

    public boolean hasAttachments() {
        ALAttachmentsExtractor h = new ALAttachmentsExtractor();
        try {
            MultipartUtility.process((Part)this, (PartHandler)h);
            if (h.getCount() > 0) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"ALLocalMailMessage.hasAttachments", (Throwable)e);
            return false;
        }
        return false;
    }

    public InputStream getInputStream(int attachmentIndex) {
        InputStream in = null;
        ALAttachmentsExtractor h = new ALAttachmentsExtractor();
        try {
            MultipartUtility.process((Part)this, (PartHandler)h);
            in = h.getInputStream(attachmentIndex);
        }
        catch (Exception e) {
            logger.error((Object)"ALLocalMailMessage.getInputStream", (Throwable)e);
            return null;
        }
        return in;
    }

    public String getFileName(int attachmentIndex) {
        String filename = null;
        ALAttachmentsExtractor h = new ALAttachmentsExtractor();
        try {
            MultipartUtility.process((Part)this, (PartHandler)h);
            filename = h.getFileName(attachmentIndex);
        }
        catch (Exception e) {
            logger.error((Object)"ALLocalMailMessage.getFileName", (Throwable)e);
            return null;
        }
        return filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        byte[] b = null;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            this.writeTo(output);
            b = output.toByteArray();
        }
        catch (Exception e) {
            logger.error((Object)"ALLocalMailMessage.getSize", (Throwable)e);
            int n = -1;
            return n;
        }
        finally {
            try {
                output.close();
            }
            catch (IOException ioee) {
                return -1;
            }
        }
        return b.length;
    }

    public Date getSentDate() throws MessagingException {
        return MailUtility.parseDate((String)this.getHeader(DATE, null));
    }

    public Address[] getRecipients(Message.RecipientType recipienttype) throws MessagingException {
        String recipients = MailUtility.decodeText((String)this.getHeader(recipienttype.toString(), null));
        if (recipients == null) {
            return super.getRecipients(recipienttype);
        }
        StringTokenizer st = new StringTokenizer(recipients, ",;");
        String token = null;
        boolean found = false;
        while (st.hasMoreTokens()) {
            token = st.nextToken();
            if (token.indexOf(60) >= 0 && token.indexOf(62) == -1 || token.indexOf(60) == -1 && token.indexOf(62) >= 0 || token.indexOf(40) >= 0 && token.indexOf(62) == -1 || token.indexOf(40) == -1 && token.indexOf(41) >= 0) {
                found = true;
                continue;
            }
            if (!(token.indexOf(60) >= 0 && token.indexOf(60) != token.lastIndexOf(60) || token.indexOf(62) >= 0 && token.indexOf(62) != token.lastIndexOf(62) || token.indexOf(40) >= 0 && token.indexOf(41) != token.lastIndexOf(40)) && (token.indexOf(41) < 0 || token.indexOf(41) == token.lastIndexOf(41))) continue;
            found = true;
        }
        if (found) {
            int index = 0;
            st = new StringTokenizer(recipients, ",;");
            InternetAddress[] addresses = new InternetAddress[st.countTokens()];
            while (st.hasMoreTokens()) {
                token = st.nextToken();
                try {
                    addresses[index] = new InternetAddress(token, false);
                }
                catch (AddressException ae) {
                    addresses[index] = new InternetAddress();
                    if (index > 0 && token.contains("\r\n\t")) {
                        token = token.substring(4);
                    }
                    addresses[index].setAddress(token);
                }
                ++index;
            }
            return addresses;
        }
        return super.getRecipients(recipienttype);
    }

    public Address[] getRecipients(Message.RecipientType recipienttype, boolean strict) throws MessagingException {
        Address[] addresses;
        if (strict) {
            return this.getRecipients(recipienttype);
        }
        try {
            addresses = super.getRecipients(recipienttype);
        }
        catch (AddressException e) {
            String recipients = MailUtility.decodeText((String)this.getHeader(recipienttype.toString(), null));
            if (recipients == null) {
                return super.getRecipients(recipienttype);
            }
            int index = 0;
            String token = null;
            StringTokenizer st = new StringTokenizer(recipients, ",;");
            addresses = new InternetAddress[st.countTokens()];
            while (st.hasMoreTokens()) {
                token = st.nextToken();
                try {
                    addresses[index] = new InternetAddress(token, false);
                }
                catch (AddressException ae) {
                    addresses[index] = new InternetAddress();
                    ((InternetAddress)addresses[index]).setAddress(token);
                }
                ++index;
            }
        }
        return addresses;
    }

    @Override
    public void clearContents() {
    }
}

