/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.mail.file;

import com.aimluck.eip.mail.ALFolder;
import com.aimluck.eip.mail.ALMailHandler;
import com.aimluck.eip.mail.ALMailReceiver;
import com.aimluck.eip.mail.ALMailReceiverContext;
import com.aimluck.eip.mail.ALMailSender;
import com.aimluck.eip.mail.ALMailSenderContext;
import com.aimluck.eip.mail.file.ALFileLocalFolder;
import com.aimluck.eip.mail.file.ALFilePop3MailReceiver;
import com.aimluck.eip.mail.file.ALFileSmtpMailSender;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.services.storage.ALStorageService;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;

public class ALFileMailHandler
extends ALMailHandler {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALFileMailHandler.class.getName());
    protected String categoryKey = null;

    public static ALMailHandler getInstance() {
        return new ALFileMailHandler();
    }

    @Override
    protected ALMailReceiver getALMailReceiver(ALMailReceiverContext rcontext) {
        return new ALFilePop3MailReceiver(rcontext);
    }

    @Override
    public ALMailSender getALMailSender(ALMailSenderContext scontext) {
        return new ALFileSmtpMailSender(scontext);
    }

    @Override
    public ALMailSender getALAdminMailSender(ALMailSenderContext scontext) {
        return new ALFileSmtpMailSender(scontext);
    }

    @Override
    public ALFolder getALFolder(int type_mail, String org_id, int user_id, int account_id) {
        return new ALFileLocalFolder(type_mail, org_id, user_id, account_id);
    }

    protected String getCategoryKey() {
        return this.categoryKey != null && !"".equals(this.categoryKey) ? this.categoryKey : ALMailUtils.categoryKey;
    }

    @Override
    public boolean removeAccount(String org_id, int user_id, int account_id) {
        StringBuilder key = new StringBuilder();
        String categoryKeytmp = this.getCategoryKey();
        if (categoryKeytmp != null && !"".equals(categoryKeytmp)) {
            key.append(categoryKeytmp);
        }
        key.append(ALStorageService.separator());
        key.append(user_id);
        key.append(ALStorageService.separator());
        key.append(account_id);
        return ALStorageService.deleteFolder((String)ALMailUtils.rootFolderPath, (String)key.toString());
    }

    @Override
    public long getFolderSize(String org_id, int user_id, int account_id) {
        StringBuilder key = new StringBuilder();
        String categoryKeytmp = this.getCategoryKey();
        if (categoryKeytmp != null && !"".equals(categoryKeytmp)) {
            key.append(categoryKeytmp);
        }
        key.append(ALStorageService.separator());
        key.append(user_id);
        key.append(ALStorageService.separator());
        key.append(account_id);
        return ALStorageService.getFolderSize((String)ALMailUtils.rootFolderPath, (String)key.toString());
    }
}

