/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.mail.util;

import com.aimluck.eip.mail.util.CharCodeConverter;
import com.aimluck.eip.mail.util.UnicodeCorrecter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.activation.DataSource;

public class JISDataSource
implements DataSource {
    private byte[] data;

    public JISDataSource(String s) {
        try {
            this.data = CharCodeConverter.sjisToJis(UnicodeCorrecter.correctToCP932(s).getBytes("Windows-31J"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("CANT HAPPEN");
        }
    }

    public String getContentType() {
        return "text/plain; charset=ISO-2022-JP";
    }

    public InputStream getInputStream() throws IOException {
        if (this.data == null) {
            throw new IOException("no data");
        }
        return new ByteArrayInputStream(this.data);
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException("cannot do this");
    }

    public String getName() {
        return "dummy";
    }
}

