/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.layout.client;

import com.google.gwt.animation.client.Animation;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.layout.client.LayoutImpl;
import java.util.ArrayList;
import java.util.List;

public class Layout {
    private LayoutImpl impl = (LayoutImpl)GWT.create(LayoutImpl.class);
    private List<Layer> layers = new ArrayList<Layer>();
    private final Element parentElem;
    private Animation animation;

    public Layout(Element parent) {
        this.parentElem = parent;
        this.impl.initParent(parent);
    }

    public void assertIsChild(Element elem) {
        assert (elem.getParentElement().getParentElement() == this.parentElem) : "Element is not a child of this layout";
    }

    public Layer attachChild(Element child) {
        return this.attachChild(child, null);
    }

    public Layer attachChild(Element child, Element before) {
        return this.attachChild(child, before, null);
    }

    public Layer attachChild(Element child, Object userObject) {
        return this.attachChild(child, null, userObject);
    }

    public Layer attachChild(Element child, Element before, Object userObject) {
        Element container = this.impl.attachChild(this.parentElem, child, before);
        Layer layer = new Layer(container, child, userObject);
        this.layers.add(layer);
        return layer;
    }

    public void fillParent() {
        this.impl.fillParent(this.parentElem);
    }

    public double getUnitSize(Style.Unit unit, boolean vertical) {
        return this.impl.getUnitSizeInPixels(this.parentElem, unit, vertical);
    }

    public void layout() {
        this.layout(0);
    }

    public void layout(int duration) {
        this.layout(duration, null);
    }

    public void layout(int duration, final AnimationCallback callback) {
        if (this.animation != null) {
            this.animation.cancel();
        }
        if (duration == 0) {
            for (Layer l : this.layers) {
                l.left = l.sourceLeft = l.targetLeft;
                l.top = l.sourceTop = l.targetTop;
                l.right = l.sourceRight = l.targetRight;
                l.bottom = l.sourceBottom = l.targetBottom;
                l.width = l.sourceWidth = l.targetWidth;
                l.height = l.sourceHeight = l.targetHeight;
                l.setLeft = l.setTargetLeft;
                l.setTop = l.setTargetTop;
                l.setRight = l.setTargetRight;
                l.setBottom = l.setTargetBottom;
                l.setWidth = l.setTargetWidth;
                l.setHeight = l.setTargetHeight;
                l.leftUnit = l.targetLeftUnit;
                l.topUnit = l.targetTopUnit;
                l.rightUnit = l.targetRightUnit;
                l.bottomUnit = l.targetBottomUnit;
                l.widthUnit = l.targetWidthUnit;
                l.heightUnit = l.targetHeightUnit;
                this.impl.layout(l);
            }
            this.impl.finalizeLayout(this.parentElem);
            if (callback != null) {
                callback.onAnimationComplete();
            }
            return;
        }
        int parentWidth = this.parentElem.getClientWidth();
        int parentHeight = this.parentElem.getClientHeight();
        for (Layer l : this.layers) {
            this.adjustHorizontalConstraints(parentWidth, l);
            this.adjustVerticalConstraints(parentHeight, l);
        }
        this.animation = new Animation(){

            @Override
            protected void onCancel() {
                this.onComplete();
            }

            @Override
            protected void onComplete() {
                Layout.this.animation = null;
                Layout.this.layout();
                if (callback != null) {
                    callback.onAnimationComplete();
                }
            }

            @Override
            protected void onUpdate(double progress) {
                for (Layer l : Layout.this.layers) {
                    if (l.setTargetLeft) {
                        l.left = l.sourceLeft + (l.targetLeft - l.sourceLeft) * progress;
                    }
                    if (l.setTargetRight) {
                        l.right = l.sourceRight + (l.targetRight - l.sourceRight) * progress;
                    }
                    if (l.setTargetTop) {
                        l.top = l.sourceTop + (l.targetTop - l.sourceTop) * progress;
                    }
                    if (l.setTargetBottom) {
                        l.bottom = l.sourceBottom + (l.targetBottom - l.sourceBottom) * progress;
                    }
                    if (l.setTargetWidth) {
                        l.width = l.sourceWidth + (l.targetWidth - l.sourceWidth) * progress;
                    }
                    if (l.setTargetHeight) {
                        l.height = l.sourceHeight + (l.targetHeight - l.sourceHeight) * progress;
                    }
                    Layout.this.impl.layout(l);
                    if (callback == null) continue;
                    callback.onLayout(l, progress);
                }
                Layout.this.impl.finalizeLayout(Layout.this.parentElem);
            }
        };
        this.animation.run(duration, this.parentElem);
    }

    public void onAttach() {
        this.impl.onAttach(this.parentElem);
    }

    public void onDetach() {
        this.impl.onDetach(this.parentElem);
    }

    public void removeChild(Layer layer) {
        this.impl.removeChild(layer.container, layer.child);
        this.layers.remove(layer);
    }

    private void adjustHorizontalConstraints(int parentWidth, Layer l) {
        double leftPx = l.left * this.getUnitSize(l.leftUnit, false);
        double rightPx = l.right * this.getUnitSize(l.rightUnit, false);
        double widthPx = l.width * this.getUnitSize(l.widthUnit, false);
        if (l.setLeft && !l.setTargetLeft) {
            l.setLeft = false;
            if (!l.setWidth) {
                l.setTargetWidth = true;
                l.sourceWidth = ((double)parentWidth - (leftPx + rightPx)) / this.getUnitSize(l.targetWidthUnit, false);
            } else {
                l.setTargetRight = true;
                l.sourceRight = ((double)parentWidth - (leftPx + widthPx)) / this.getUnitSize(l.targetRightUnit, false);
            }
        } else if (l.setWidth && !l.setTargetWidth) {
            l.setWidth = false;
            if (!l.setLeft) {
                l.setTargetLeft = true;
                l.sourceLeft = ((double)parentWidth - (rightPx + widthPx)) / this.getUnitSize(l.targetLeftUnit, false);
            } else {
                l.setTargetRight = true;
                l.sourceRight = ((double)parentWidth - (leftPx + widthPx)) / this.getUnitSize(l.targetRightUnit, false);
            }
        } else if (l.setRight && !l.setTargetRight) {
            l.setRight = false;
            if (!l.setWidth) {
                l.setTargetWidth = true;
                l.sourceWidth = ((double)parentWidth - (leftPx + rightPx)) / this.getUnitSize(l.targetWidthUnit, false);
            } else {
                l.setTargetLeft = true;
                l.sourceLeft = ((double)parentWidth - (rightPx + widthPx)) / this.getUnitSize(l.targetLeftUnit, false);
            }
        }
        l.setLeft = l.setTargetLeft;
        l.setRight = l.setTargetRight;
        l.setWidth = l.setTargetWidth;
        l.leftUnit = l.targetLeftUnit;
        l.rightUnit = l.targetRightUnit;
        l.widthUnit = l.targetWidthUnit;
    }

    private void adjustVerticalConstraints(int parentHeight, Layer l) {
        double topPx = l.top * this.getUnitSize(l.topUnit, true);
        double bottomPx = l.bottom * this.getUnitSize(l.bottomUnit, true);
        double heightPx = l.height * this.getUnitSize(l.heightUnit, true);
        if (l.setTop && !l.setTargetTop) {
            l.setTop = false;
            if (!l.setHeight) {
                l.setTargetHeight = true;
                l.sourceHeight = ((double)parentHeight - (topPx + bottomPx)) / this.getUnitSize(l.targetHeightUnit, true);
            } else {
                l.setTargetBottom = true;
                l.sourceBottom = ((double)parentHeight - (topPx + heightPx)) / this.getUnitSize(l.targetBottomUnit, true);
            }
        } else if (l.setHeight && !l.setTargetHeight) {
            l.setHeight = false;
            if (!l.setTop) {
                l.setTargetTop = true;
                l.sourceTop = ((double)parentHeight - (bottomPx + heightPx)) / this.getUnitSize(l.targetTopUnit, true);
            } else {
                l.setTargetBottom = true;
                l.sourceBottom = ((double)parentHeight - (topPx + heightPx)) / this.getUnitSize(l.targetBottomUnit, true);
            }
        } else if (l.setBottom && !l.setTargetBottom) {
            l.setBottom = false;
            if (!l.setHeight) {
                l.setTargetHeight = true;
                l.sourceHeight = ((double)parentHeight - (topPx + bottomPx)) / this.getUnitSize(l.targetHeightUnit, true);
            } else {
                l.setTargetTop = true;
                l.sourceTop = ((double)parentHeight - (bottomPx + heightPx)) / this.getUnitSize(l.targetTopUnit, true);
            }
        }
        l.setTop = l.setTargetTop;
        l.setBottom = l.setTargetBottom;
        l.setHeight = l.setTargetHeight;
        l.topUnit = l.targetTopUnit;
        l.bottomUnit = l.targetBottomUnit;
        l.heightUnit = l.targetHeightUnit;
    }

    public class Layer {
        final Element container;
        final Element child;
        Object userObject;
        boolean setLeft;
        boolean setRight;
        boolean setTop;
        boolean setBottom;
        boolean setWidth;
        boolean setHeight;
        boolean setTargetLeft = true;
        boolean setTargetRight = true;
        boolean setTargetTop = true;
        boolean setTargetBottom = true;
        boolean setTargetWidth;
        boolean setTargetHeight;
        Style.Unit leftUnit;
        Style.Unit topUnit;
        Style.Unit rightUnit;
        Style.Unit bottomUnit;
        Style.Unit widthUnit;
        Style.Unit heightUnit;
        Style.Unit targetLeftUnit = Style.Unit.PX;
        Style.Unit targetTopUnit = Style.Unit.PX;
        Style.Unit targetRightUnit = Style.Unit.PX;
        Style.Unit targetBottomUnit = Style.Unit.PX;
        Style.Unit targetWidthUnit;
        Style.Unit targetHeightUnit;
        double left;
        double top;
        double right;
        double bottom;
        double width;
        double height;
        double sourceLeft;
        double sourceTop;
        double sourceRight;
        double sourceBottom;
        double sourceWidth;
        double sourceHeight;
        double targetLeft;
        double targetTop;
        double targetRight;
        double targetBottom;
        double targetWidth;
        double targetHeight;
        Alignment hPos = Alignment.STRETCH;
        Alignment vPos = Alignment.STRETCH;
        boolean visible = true;

        Layer(Element container, Element child, Object userObject) {
            this.container = container;
            this.child = child;
            this.userObject = userObject;
        }

        public Element getContainerElement() {
            return this.container;
        }

        public Object getUserObject() {
            return this.userObject;
        }

        public void setBottomHeight(double bottom, Style.Unit bottomUnit, double height, Style.Unit heightUnit) {
            this.setTargetHeight = true;
            this.setTargetBottom = true;
            this.setTargetTop = false;
            this.targetBottom = bottom;
            this.targetHeight = height;
            this.targetBottomUnit = bottomUnit;
            this.targetHeightUnit = heightUnit;
        }

        public void setChildHorizontalPosition(Alignment position) {
            this.hPos = position;
        }

        public void setChildVerticalPosition(Alignment position) {
            this.vPos = position;
        }

        public void setLeftRight(double left, Style.Unit leftUnit, double right, Style.Unit rightUnit) {
            this.setTargetRight = true;
            this.setTargetLeft = true;
            this.setTargetWidth = false;
            this.targetLeft = left;
            this.targetRight = right;
            this.targetLeftUnit = leftUnit;
            this.targetRightUnit = rightUnit;
        }

        public void setLeftWidth(double left, Style.Unit leftUnit, double width, Style.Unit widthUnit) {
            this.setTargetWidth = true;
            this.setTargetLeft = true;
            this.setTargetRight = false;
            this.targetLeft = left;
            this.targetWidth = width;
            this.targetLeftUnit = leftUnit;
            this.targetWidthUnit = widthUnit;
        }

        public void setRightWidth(double right, Style.Unit rightUnit, double width, Style.Unit widthUnit) {
            this.setTargetWidth = true;
            this.setTargetRight = true;
            this.setTargetLeft = false;
            this.targetRight = right;
            this.targetWidth = width;
            this.targetRightUnit = rightUnit;
            this.targetWidthUnit = widthUnit;
        }

        public void setTopBottom(double top, Style.Unit topUnit, double bottom, Style.Unit bottomUnit) {
            this.setTargetBottom = true;
            this.setTargetTop = true;
            this.setTargetHeight = false;
            this.targetTop = top;
            this.targetBottom = bottom;
            this.targetTopUnit = topUnit;
            this.targetBottomUnit = bottomUnit;
        }

        public void setTopHeight(double top, Style.Unit topUnit, double height, Style.Unit heightUnit) {
            this.setTargetHeight = true;
            this.setTargetTop = true;
            this.setTargetBottom = false;
            this.targetTop = top;
            this.targetHeight = height;
            this.targetTopUnit = topUnit;
            this.targetHeightUnit = heightUnit;
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
        }
    }

    public static interface AnimationCallback {
        public void onAnimationComplete();

        public void onLayout(Layer var1, double var2);
    }

    public static enum Alignment {
        BEGIN,
        END,
        STRETCH;

    }
}

