/*
 * Decompiled with CFR 0.152.
 */
package tokyocabinet;

import java.io.File;
import java.io.PrintStream;
import java.util.Random;
import tokyocabinet.HDB;
import tokyocabinet.Util;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class HDBTest {
    private static final PrintStream STDOUT = System.out;
    private static final PrintStream STDERR = System.err;
    private static final Random RND = new Random();
    static /* synthetic */ Class class$tokyocabinet$HDBTest;

    public static void main(String[] stringArray) {
        int n = 0;
        if (stringArray.length < 1) {
            HDBTest.usage();
        }
        if (stringArray[0].equals("write")) {
            n = HDBTest.runwrite(stringArray);
        } else if (stringArray[0].equals("read")) {
            n = HDBTest.runread(stringArray);
        } else if (stringArray[0].equals("remove")) {
            n = HDBTest.runremove(stringArray);
        } else if (stringArray[0].equals("misc")) {
            n = HDBTest.runmisc(stringArray);
        } else {
            HDBTest.usage();
        }
        System.gc();
        System.exit(n);
    }

    private static final void usage() {
        STDERR.println("test cases of the hash database API");
        STDERR.println("");
        STDERR.println("synopsis:");
        StringBuffer stringBuffer = new StringBuffer("  java ");
        Class clazz = class$tokyocabinet$HDBTest;
        if (clazz == null) {
            clazz = class$tokyocabinet$HDBTest = HDBTest.class("[Ltokyocabinet.HDBTest;", false);
        }
        STDERR.println(stringBuffer.append(clazz.getName()).append(" arguments...").toString());
        STDERR.println("");
        STDERR.println("arguments:");
        STDERR.println("  tchtest.rb write [-tl] [-td|-tb] [-nl|-nb] [-as] path rnum [bnum [apow [fpow]]]");
        STDERR.println("  tchtest.rb read [-nl|-nb] path");
        STDERR.println("  tchtest.rb remove [-nl|-nb] path");
        STDERR.println("  tchtest.rb misc [-tl] [-td|-tb] [-nl|-nb] path rnum");
        STDERR.println("");
        System.exit(1);
    }

    private static final void eprint(HDB hDB, String string) {
        String string2 = hDB.path();
        StringBuffer stringBuffer = new StringBuffer();
        Class clazz = class$tokyocabinet$HDBTest;
        if (clazz == null) {
            clazz = class$tokyocabinet$HDBTest = HDBTest.class("[Ltokyocabinet.HDBTest;", false);
        }
        STDERR.println(stringBuffer.append(clazz.getName()).append(": ").append(string2).append(": ").append(string).append(": ").append(hDB.errmsg()).toString());
    }

    private static final int runwrite(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        int n3 = 1;
        while (n3 < stringArray.length) {
            String string6 = stringArray[n3];
            if (string == null && string6.startsWith("-")) {
                if (string6.equals("-tl")) {
                    n |= 1;
                } else if (string6.equals("-td")) {
                    n |= 2;
                } else if (string6.equals("-tb")) {
                    n |= 4;
                } else if (string6.equals("-tt")) {
                    n |= 8;
                } else if (string6.equals("-nl")) {
                    n2 |= 0x10;
                } else if (string6.equals("-nb")) {
                    n2 |= 0x20;
                } else if (string6.equals("-as")) {
                    bl = true;
                } else {
                    HDBTest.usage();
                }
            } else if (string == null) {
                string = string6;
            } else if (string2 == null) {
                string2 = string6;
            } else if (string3 == null) {
                string3 = string6;
            } else if (string4 == null) {
                string4 = string6;
            } else if (string5 == null) {
                string5 = string6;
            } else {
                HDBTest.usage();
            }
            ++n3;
        }
        if (string == null || string2 == null) {
            HDBTest.usage();
        }
        if ((n3 = Util.atoi(string2)) < 1) {
            HDBTest.usage();
        }
        int n4 = string3 != null ? Util.atoi(string3) : -1;
        int n5 = string4 != null ? Util.atoi(string4) : -1;
        int n6 = string5 != null ? Util.atoi(string5) : -1;
        int n7 = HDBTest.procwrite(string, n3, n4, n5, n6, n, n2, bl);
        return n7;
    }

    private static final int runread(String[] stringArray) {
        String string = null;
        int n = 0;
        int n2 = 1;
        while (n2 < stringArray.length) {
            String string2 = stringArray[n2];
            if (string == null && string2.startsWith("-")) {
                if (string2.equals("-nl")) {
                    n |= 0x10;
                } else if (string2.equals("-nb")) {
                    n |= 0x20;
                } else {
                    HDBTest.usage();
                }
            } else if (string == null) {
                string = string2;
            } else {
                HDBTest.usage();
            }
            ++n2;
        }
        if (string == null) {
            HDBTest.usage();
        }
        n2 = HDBTest.procread(string, n);
        return n2;
    }

    private static final int runremove(String[] stringArray) {
        String string = null;
        int n = 0;
        int n2 = 1;
        while (n2 < stringArray.length) {
            String string2 = stringArray[n2];
            if (string == null && string2.startsWith("-")) {
                if (string2.equals("-nl")) {
                    n |= 0x10;
                } else if (string2.equals("-nb")) {
                    n |= 0x20;
                } else {
                    HDBTest.usage();
                }
            } else if (string == null) {
                string = string2;
            } else {
                HDBTest.usage();
            }
            ++n2;
        }
        if (string == null) {
            HDBTest.usage();
        }
        n2 = HDBTest.procremove(string, n);
        return n2;
    }

    private static final int runmisc(String[] stringArray) {
        String string = null;
        String string2 = null;
        int n = 0;
        int n2 = 0;
        int n3 = 1;
        while (n3 < stringArray.length) {
            String string3 = stringArray[n3];
            if (string == null && string3.startsWith("-")) {
                if (string3.equals("-tl")) {
                    n |= 1;
                } else if (string3.equals("-td")) {
                    n |= 2;
                } else if (string3.equals("-tb")) {
                    n |= 4;
                } else if (string3.equals("-tt")) {
                    n |= 8;
                } else if (string3.equals("-nl")) {
                    n2 |= 0x10;
                } else if (string3.equals("-nb")) {
                    n2 |= 0x20;
                } else {
                    HDBTest.usage();
                }
            } else if (string == null) {
                string = string3;
            } else if (string2 == null) {
                string2 = string3;
            } else {
                HDBTest.usage();
            }
            ++n3;
        }
        if (string == null || string2 == null) {
            HDBTest.usage();
        }
        if ((n3 = Util.atoi(string2)) < 1) {
            HDBTest.usage();
        }
        int n4 = HDBTest.procmisc(string, n3, n, n2);
        return n4;
    }

    private static final int procwrite(String string, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        STDOUT.println("<Writing Test>");
        STDOUT.println("  path=" + string + "  rnum=" + n + "  bnum=" + n2 + "  apow=" + n3 + "  fpow=" + n4 + "  opts=" + n5 + "  omode=" + n6 + "  as=" + bl);
        STDOUT.println("");
        int n7 = 0;
        double d = Util.time();
        HDB hDB = new HDB();
        if (!hDB.tune(n2, n3, n4, n5)) {
            HDBTest.eprint(hDB, "tune");
            n7 = 1;
        }
        if (!hDB.open(string, 0xE | n6)) {
            HDBTest.eprint(hDB, "open");
            n7 = 1;
        }
        int n8 = 1;
        while (n8 <= n) {
            String string2 = Util.itoa(n8, 8, '0');
            if (bl) {
                if (!hDB.putasync(string2, string2)) {
                    HDBTest.eprint(hDB, "putasync");
                    n7 = 1;
                    break;
                }
            } else if (!hDB.put(string2, string2)) {
                HDBTest.eprint(hDB, "put");
                n7 = 1;
                break;
            }
            if (n > 250 && n8 % (n / 250) == 0) {
                STDOUT.print('.');
                if (n8 == n || n8 % (n / 10) == 0) {
                    STDOUT.println(" (" + string2 + ')');
                }
            }
            ++n8;
        }
        STDOUT.println("record number: " + hDB.rnum());
        STDOUT.println("size: " + hDB.fsiz());
        if (!hDB.close()) {
            HDBTest.eprint(hDB, "close");
            n7 = 1;
        }
        STDOUT.println("time: " + (Util.time() - d));
        STDOUT.println(n7 != 0 ? "error" : "ok");
        STDOUT.println("");
        return n7;
    }

    private static final int procread(String string, int n) {
        STDOUT.println("<Reading Test>");
        STDOUT.println("  path=" + string + "  omode=" + n);
        STDOUT.println("");
        int n2 = 0;
        double d = Util.time();
        HDB hDB = new HDB();
        if (!hDB.open(string, 1 | n)) {
            HDBTest.eprint(hDB, "open");
            n2 = 1;
        }
        int n3 = (int)hDB.rnum();
        int n4 = 1;
        while (n4 <= n3) {
            String string2 = Util.itoa(n4, 8, '0');
            if (hDB.get(string2) == null) {
                HDBTest.eprint(hDB, "get");
                n2 = 1;
                break;
            }
            if (n3 > 250 && n4 % (n3 / 250) == 0) {
                STDOUT.print('.');
                if (n4 == n3 || n4 % (n3 / 10) == 0) {
                    STDOUT.println(" (" + string2 + ')');
                }
            }
            ++n4;
        }
        STDOUT.println("record number: " + hDB.rnum());
        STDOUT.println("size: " + hDB.fsiz());
        if (!hDB.close()) {
            HDBTest.eprint(hDB, "close");
            n2 = 1;
        }
        STDOUT.println("time: " + (Util.time() - d));
        STDOUT.println(n2 != 0 ? "error" : "ok");
        STDOUT.println("");
        return n2;
    }

    private static final int procremove(String string, int n) {
        STDOUT.println("<Removing Test>");
        STDOUT.println("  path=" + string + "  omode=" + n);
        STDOUT.println("");
        int n2 = 0;
        double d = Util.time();
        HDB hDB = new HDB();
        if (!hDB.open(string, 2 | n)) {
            HDBTest.eprint(hDB, "open");
            n2 = 1;
        }
        int n3 = (int)hDB.rnum();
        int n4 = 1;
        while (n4 <= n3) {
            String string2 = Util.itoa(n4, 8, '0');
            if (!hDB.out(string2)) {
                HDBTest.eprint(hDB, "out");
                n2 = 1;
                break;
            }
            if (n3 > 250 && n4 % (n3 / 250) == 0) {
                STDOUT.print('.');
                if (n4 == n3 || n4 % (n3 / 10) == 0) {
                    STDOUT.println(" (" + string2 + ')');
                }
            }
            ++n4;
        }
        STDOUT.println("record number: " + hDB.rnum());
        STDOUT.println("size: " + hDB.fsiz());
        if (!hDB.close()) {
            HDBTest.eprint(hDB, "close");
            n2 = 1;
        }
        STDOUT.println("time: " + (Util.time() - d));
        STDOUT.println(n2 != 0 ? "error" : "ok");
        STDOUT.println("");
        return n2;
    }

    private static final int procmisc(String string, int n, int n2, int n3) {
        String string2;
        Object object;
        String string3;
        STDOUT.println("<Miscellaneous Test>");
        STDOUT.println("  path=" + string + "  rnum=" + n + "  opts=" + n2 + "  omode=" + n3);
        STDOUT.println("");
        int n4 = 0;
        double d = Util.time();
        HDB hDB = new HDB();
        if (!hDB.tune(n / 50, 2, -1, n2)) {
            HDBTest.eprint(hDB, "tune");
            n4 = 1;
        }
        if (!hDB.setcache(n / 10)) {
            HDBTest.eprint(hDB, "setcache");
            n4 = 1;
        }
        if (!hDB.setxmsiz(n * 4)) {
            HDBTest.eprint(hDB, "setxmsiz");
            n4 = 1;
        }
        if (!hDB.setdfunit(8)) {
            HDBTest.eprint(hDB, "setdfunit");
            n4 = 1;
        }
        if (!hDB.open(string, 0xE | n3)) {
            HDBTest.eprint(hDB, "open");
            n4 = 1;
        }
        STDOUT.println("writing:");
        int n5 = 1;
        while (n5 <= n) {
            string3 = Util.itoa(n5, 8, '0');
            if (!hDB.put(string3, string3)) {
                HDBTest.eprint(hDB, "put");
                n4 = 1;
                break;
            }
            if (n > 250 && n5 % (n / 250) == 0) {
                STDOUT.print('.');
                if (n5 == n || n5 % (n / 10) == 0) {
                    STDOUT.println(" (" + string3 + ')');
                }
            }
            ++n5;
        }
        STDOUT.println("reading:");
        n5 = 1;
        while (n5 <= n) {
            string3 = Util.itoa(n5, 8, '0');
            if (hDB.get(string3) == null) {
                HDBTest.eprint(hDB, "get");
                n4 = 1;
                break;
            }
            if (n > 250 && n5 % (n / 250) == 0) {
                STDOUT.print('.');
                if (n5 == n || n5 % (n / 10) == 0) {
                    STDOUT.println(" (" + string3 + ')');
                }
            }
            ++n5;
        }
        STDOUT.println("removing:");
        n5 = 1;
        while (n5 <= n) {
            string3 = Util.itoa(n5, 8, '0');
            if (RND.nextInt(2) == 0 && !hDB.out(string3)) {
                HDBTest.eprint(hDB, "get");
                n4 = 1;
                break;
            }
            if (n > 250 && n5 % (n / 250) == 0) {
                STDOUT.print('.');
                if (n5 == n || n5 % (n / 10) == 0) {
                    STDOUT.println(" (" + string3 + ')');
                }
            }
            ++n5;
        }
        STDOUT.println("checking iterator:");
        if (!hDB.iterinit()) {
            HDBTest.eprint(hDB, "iterinit");
            n4 = 1;
        }
        n5 = 0;
        while ((string3 = hDB.iternext2()) != null) {
            object = hDB.get(string3);
            if (object == null) {
                HDBTest.eprint(hDB, "get");
                n4 = 1;
            }
            if (n5 > 0 && n > 250 && n5 % (n / 250) == 0) {
                STDOUT.print('.');
                if (n5 == n || n5 % (n / 10) == 0) {
                    STDOUT.println(" (" + Util.itoa(n5, 8, '0') + ')');
                }
            }
            ++n5;
        }
        if (n > 250) {
            STDOUT.println(" (" + Util.itoa(n5, 8, '0') + ')');
        }
        if (hDB.ecode() != 22 || (long)n5 != hDB.rnum()) {
            HDBTest.eprint(hDB, "(validation)");
            n4 = 1;
        }
        object = hDB.fwmkeys("0", 10);
        if (hDB.rnum() >= 10L && object.size() != 10) {
            HDBTest.eprint(hDB, "fwmkeys");
            n4 = 1;
        }
        STDOUT.println("checking counting:");
        int n6 = 1;
        while (n6 <= n) {
            String string4 = "[" + RND.nextInt(n) + ']';
            if (RND.nextInt(2) == 0) {
                if (hDB.addint(string4, 1) == Integer.MIN_VALUE && hDB.ecode() != 21) {
                    HDBTest.eprint(hDB, "addint");
                    n4 = 1;
                    break;
                }
            } else if (hDB.adddouble(string4, 1.0) == -2.147483648E9 && hDB.ecode() != 21) {
                HDBTest.eprint(hDB, "adddouble");
                n4 = 1;
                break;
            }
            if (n > 250 && n6 % (n / 250) == 0) {
                STDOUT.print('.');
                if (n6 == n || n6 % (n / 10) == 0) {
                    STDOUT.println(" (" + Util.itoa(n6, 8, '0') + ')');
                }
            }
            ++n6;
        }
        if (!hDB.sync()) {
            HDBTest.eprint(hDB, "sync");
            n4 = 1;
        }
        if (!hDB.optimize()) {
            HDBTest.eprint(hDB, "optimize");
            n4 = 1;
        }
        if (!hDB.copy(string2 = string + "-tmp")) {
            HDBTest.eprint(hDB, "copy");
            n4 = 1;
        }
        new File(string2).delete();
        if (!hDB.vanish()) {
            HDBTest.eprint(hDB, "vanish");
            n4 = 1;
        }
        STDOUT.println("checking transaction commit:");
        if (!hDB.tranbegin()) {
            HDBTest.eprint(hDB, "tranbegin");
            n4 = 1;
        }
        int n7 = 1;
        while (n7 <= n) {
            String string5 = "" + n7;
            if (RND.nextInt(2) == 0) {
                if (!hDB.putcat(string5, string5)) {
                    HDBTest.eprint(hDB, "putcat");
                    n4 = 1;
                    break;
                }
            } else if (!hDB.out(string5) && hDB.ecode() != 22) {
                HDBTest.eprint(hDB, "out");
                n4 = 1;
                break;
            }
            if (n > 250 && n7 % (n / 250) == 0) {
                STDOUT.print('.');
                if (n7 == n || n7 % (n / 10) == 0) {
                    STDOUT.println(" (" + Util.itoa(n7, 8, '0') + ')');
                }
            }
            ++n7;
        }
        if (!hDB.trancommit()) {
            HDBTest.eprint(hDB, "trancommit");
            n4 = 1;
        }
        STDOUT.println("checking transaction abort:");
        long l = hDB.rnum();
        long l2 = hDB.fsiz();
        if (!hDB.tranbegin()) {
            HDBTest.eprint(hDB, "tranbegin");
            n4 = 1;
        }
        int n8 = 1;
        while (n8 <= n) {
            String string6 = "" + n8;
            if (RND.nextInt(2) == 0) {
                if (!hDB.putcat(string6, string6)) {
                    HDBTest.eprint(hDB, "putcat");
                    n4 = 1;
                    break;
                }
            } else if (!hDB.out(string6) && hDB.ecode() != 22) {
                HDBTest.eprint(hDB, "out");
                n4 = 1;
                break;
            }
            if (n > 250 && n8 % (n / 250) == 0) {
                STDOUT.print('.');
                if (n8 == n || n8 % (n / 10) == 0) {
                    STDOUT.println(" (" + Util.itoa(n8, 8, '0') + ')');
                }
            }
            ++n8;
        }
        if (!hDB.tranabort()) {
            HDBTest.eprint(hDB, "trancommit");
            n4 = 1;
        }
        if (hDB.rnum() != l || hDB.fsiz() != l2) {
            HDBTest.eprint(hDB, "(validation)");
            n4 = 1;
        }
        STDOUT.println("checking common interface:");
        HDB hDB2 = hDB;
        int n9 = 1;
        while (n9 <= n) {
            String string7 = "[" + Util.itoa(RND.nextInt(n), 8, '0') + ']';
            int n10 = RND.nextInt(3);
            if (n10 == 0) {
                hDB2.put(string7, string7);
            } else if (n10 == 1) {
                hDB2.get(string7);
            } else {
                hDB2.out(string7);
            }
            if (n > 250 && n9 % (n / 250) == 0) {
                STDOUT.print('.');
                if (n9 == n || n9 % (n / 10) == 0) {
                    STDOUT.println(" (" + Util.itoa(n9, 8, '0') + ')');
                }
            }
            ++n9;
        }
        STDOUT.println("checking iterator:");
        n5 = 0;
        if (!hDB2.iterinit()) {
            HDBTest.eprint(hDB, "iterinit");
            n4 = 1;
        }
        while ((string3 = hDB2.iternext2()) != null) {
            String string8 = hDB2.get(string3);
            if (string8 == null) {
                HDBTest.eprint(hDB, "get");
                n4 = 1;
            }
            if (n5 > 0 && n > 250 && n5 % (n / 250) == 0) {
                STDOUT.print('.');
                if (n5 == n || n5 % (n / 10) == 0) {
                    STDOUT.println(" (" + Util.itoa(n5, 8, '0') + ')');
                }
            }
            ++n5;
        }
        if (n > 250) {
            STDOUT.println(" (" + Util.itoa(n5, 8, '0') + ')');
        }
        STDOUT.println("record number: " + hDB.rnum());
        STDOUT.println("size: " + hDB.fsiz());
        if (!hDB.close()) {
            HDBTest.eprint(hDB, "close");
            n4 = 1;
        }
        STDOUT.println("time: " + (Util.time() - d));
        STDOUT.println(n4 != 0 ? "error" : "ok");
        STDOUT.println("");
        return n4;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private HDBTest() throws NoSuchMethodException {
        throw new NoSuchMethodException();
    }
}

