#ifndef ZKRB_WRAPPER_H
#define ZKRB_WRAPPER_H
#if 0

  AUTOGENERATED BY generate_gvl_code.rb 

#endif

#include "ruby.h"
#include "zookeeper/zookeeper.h"
#include "zkrb_wrapper_compat.h"
#include "dbg.h"

#define ZKRB_FAIL -1

typedef struct {
  zhandle_t *zh;
  int rc;
} zkrb_zoo_recv_timeout_args_t;

typedef struct {
  zhandle_t *zh;
  int rc;
} zkrb_zoo_state_args_t;

typedef struct {
  zhandle_t *zh;
  const char *path;
  const char *value;
  int valuelen;
  const struct ACL_vector *acl;
  int flags;
  string_completion_t completion;
  const void *data;
  int rc;
} zkrb_zoo_acreate_args_t;

typedef struct {
  zhandle_t *zh;
  const char *path;
  int version;
  void_completion_t completion;
  const void *data;
  int rc;
} zkrb_zoo_adelete_args_t;

typedef struct {
  zhandle_t *zh;
  const char *path;
  int watch;
  stat_completion_t completion;
  const void *data;
  int rc;
} zkrb_zoo_aexists_args_t;

typedef struct {
  zhandle_t *zh;
  const char *path;
  watcher_fn watcher;
  void* watcherCtx;
  stat_completion_t completion;
  const void *data;
  int rc;
} zkrb_zoo_awexists_args_t;

typedef struct {
  zhandle_t *zh;
  const char *path;
  int watch;
  data_completion_t completion;
  const void *data;
  int rc;
} zkrb_zoo_aget_args_t;

typedef struct {
  zhandle_t *zh;
  const char *path;
  watcher_fn watcher;
  void* watcherCtx;
  data_completion_t completion;
  const void *data;
  int rc;
} zkrb_zoo_awget_args_t;

typedef struct {
  zhandle_t *zh;
  const char *path;
  const char *buffer;
  int buflen;
  int version;
  stat_completion_t completion;
  const void *data;
  int rc;
} zkrb_zoo_aset_args_t;

typedef struct {
  zhandle_t *zh;
  const char *path;
  int watch;
  strings_completion_t completion;
  const void *data;
  int rc;
} zkrb_zoo_aget_children_args_t;

typedef struct {
  zhandle_t *zh;
  const char *path;
  watcher_fn watcher;
  void* watcherCtx;
  strings_completion_t completion;
  const void *data;
  int rc;
} zkrb_zoo_awget_children_args_t;

typedef struct {
  zhandle_t *zh;
  const char *path;
  int watch;
  strings_stat_completion_t completion;
  const void *data;
  int rc;
} zkrb_zoo_aget_children2_args_t;

typedef struct {
  zhandle_t *zh;
  const char *path;
  watcher_fn watcher;
  void* watcherCtx;
  strings_stat_completion_t completion;
  const void *data;
  int rc;
} zkrb_zoo_awget_children2_args_t;

typedef struct {
  zhandle_t *zh;
  const char *path;
  string_completion_t completion;
  const void *data;
  int rc;
} zkrb_zoo_async_args_t;

typedef struct {
  zhandle_t *zh;
  const char *path;
  acl_completion_t completion;
  const void *data;
  int rc;
} zkrb_zoo_aget_acl_args_t;

typedef struct {
  zhandle_t *zh;
  const char *path;
  int version;
  struct ACL_vector *acl;
  void_completion_t completion;
  const void *data;
  int rc;
} zkrb_zoo_aset_acl_args_t;

typedef struct {
  zhandle_t *zh;
  int count;
  const zoo_op_t *ops;
  zoo_op_result_t *results;
  void_completion_t completion;
  const void *data;
  int rc;
} zkrb_zoo_amulti_args_t;

typedef struct {
  zhandle_t *zh;
  const char* scheme;
  const char* cert;
  int certLen;
  void_completion_t completion;
  const void *data;
  int rc;
} zkrb_zoo_add_auth_args_t;

typedef struct {
  zhandle_t *zh;
  const char *path;
  const char *value;
  int valuelen;
  const struct ACL_vector *acl;
  int flags;
  char *path_buffer;
  int path_buffer_len;
  int rc;
} zkrb_zoo_create_args_t;

typedef struct {
  zhandle_t *zh;
  const char *path;
  int version;
  int rc;
} zkrb_zoo_delete_args_t;

typedef struct {
  zhandle_t *zh;
  const char *path;
  int watch;
  struct Stat *stat;
  int rc;
} zkrb_zoo_exists_args_t;

typedef struct {
  zhandle_t *zh;
  const char *path;
  watcher_fn watcher;
  void* watcherCtx;
  struct Stat *stat;
  int rc;
} zkrb_zoo_wexists_args_t;

typedef struct {
  zhandle_t *zh;
  const char *path;
  int watch;
  char *buffer;
  int* buffer_len;
  struct Stat *stat;
  int rc;
} zkrb_zoo_get_args_t;

typedef struct {
  zhandle_t *zh;
  const char *path;
  watcher_fn watcher;
  void* watcherCtx;
  char *buffer;
  int* buffer_len;
  struct Stat *stat;
  int rc;
} zkrb_zoo_wget_args_t;

typedef struct {
  zhandle_t *zh;
  const char *path;
  const char *buffer;
  int buflen;
  int version;
  int rc;
} zkrb_zoo_set_args_t;

typedef struct {
  zhandle_t *zh;
  const char *path;
  const char *buffer;
  int buflen;
  int version;
  struct Stat *stat;
  int rc;
} zkrb_zoo_set2_args_t;

typedef struct {
  zhandle_t *zh;
  const char *path;
  int watch;
  struct String_vector *strings;
  int rc;
} zkrb_zoo_get_children_args_t;

typedef struct {
  zhandle_t *zh;
  const char *path;
  watcher_fn watcher;
  void* watcherCtx;
  struct String_vector *strings;
  int rc;
} zkrb_zoo_wget_children_args_t;

typedef struct {
  zhandle_t *zh;
  const char *path;
  int watch;
  struct String_vector *strings;
  struct Stat *stat;
  int rc;
} zkrb_zoo_get_children2_args_t;

typedef struct {
  zhandle_t *zh;
  const char *path;
  watcher_fn watcher;
  void* watcherCtx;
  struct String_vector *strings;
  struct Stat *stat;
  int rc;
} zkrb_zoo_wget_children2_args_t;

typedef struct {
  zhandle_t *zh;
  const char *path;
  struct ACL_vector *acl;
  struct Stat *stat;
  int rc;
} zkrb_zoo_get_acl_args_t;

typedef struct {
  zhandle_t *zh;
  const char *path;
  int version;
  const struct ACL_vector *acl;
  int rc;
} zkrb_zoo_set_acl_args_t;

typedef struct {
  zhandle_t *zh;
  int count;
  const zoo_op_t *ops;
  zoo_op_result_t *results;
  int rc;
} zkrb_zoo_multi_args_t;

int zkrb_call_zoo_recv_timeout(zhandle_t *zh);
int zkrb_call_zoo_state(zhandle_t *zh);
int zkrb_call_zoo_acreate(zhandle_t *zh, const char *path, const char *value, int valuelen, const struct ACL_vector *acl, int flags, string_completion_t completion, const void *data);
int zkrb_call_zoo_adelete(zhandle_t *zh, const char *path, int version, void_completion_t completion, const void *data);
int zkrb_call_zoo_aexists(zhandle_t *zh, const char *path, int watch, stat_completion_t completion, const void *data);
int zkrb_call_zoo_awexists(zhandle_t *zh, const char *path, watcher_fn watcher, void* watcherCtx, stat_completion_t completion, const void *data);
int zkrb_call_zoo_aget(zhandle_t *zh, const char *path, int watch, data_completion_t completion, const void *data);
int zkrb_call_zoo_awget(zhandle_t *zh, const char *path, watcher_fn watcher, void* watcherCtx, data_completion_t completion, const void *data);
int zkrb_call_zoo_aset(zhandle_t *zh, const char *path, const char *buffer, int buflen, int version, stat_completion_t completion, const void *data);
int zkrb_call_zoo_aget_children(zhandle_t *zh, const char *path, int watch, strings_completion_t completion, const void *data);
int zkrb_call_zoo_awget_children(zhandle_t *zh, const char *path, watcher_fn watcher, void* watcherCtx, strings_completion_t completion, const void *data);
int zkrb_call_zoo_aget_children2(zhandle_t *zh, const char *path, int watch, strings_stat_completion_t completion, const void *data);
int zkrb_call_zoo_awget_children2(zhandle_t *zh, const char *path, watcher_fn watcher, void* watcherCtx, strings_stat_completion_t completion, const void *data);
int zkrb_call_zoo_async(zhandle_t *zh, const char *path, string_completion_t completion, const void *data);
int zkrb_call_zoo_aget_acl(zhandle_t *zh, const char *path, acl_completion_t completion, const void *data);
int zkrb_call_zoo_aset_acl(zhandle_t *zh, const char *path, int version, struct ACL_vector *acl, void_completion_t completion, const void *data);
int zkrb_call_zoo_amulti(zhandle_t *zh, int count, const zoo_op_t *ops, zoo_op_result_t *results, void_completion_t completion, const void *data);
int zkrb_call_zoo_add_auth(zhandle_t *zh, const char* scheme, const char* cert, int certLen, void_completion_t completion, const void *data);
int zkrb_call_zoo_create(zhandle_t *zh, const char *path, const char *value, int valuelen, const struct ACL_vector *acl, int flags, char *path_buffer, int path_buffer_len);
int zkrb_call_zoo_delete(zhandle_t *zh, const char *path, int version);
int zkrb_call_zoo_exists(zhandle_t *zh, const char *path, int watch, struct Stat *stat);
int zkrb_call_zoo_wexists(zhandle_t *zh, const char *path, watcher_fn watcher, void* watcherCtx, struct Stat *stat);
int zkrb_call_zoo_get(zhandle_t *zh, const char *path, int watch, char *buffer, int* buffer_len, struct Stat *stat);
int zkrb_call_zoo_wget(zhandle_t *zh, const char *path, watcher_fn watcher, void* watcherCtx, char *buffer, int* buffer_len, struct Stat *stat);
int zkrb_call_zoo_set(zhandle_t *zh, const char *path, const char *buffer, int buflen, int version);
int zkrb_call_zoo_set2(zhandle_t *zh, const char *path, const char *buffer, int buflen, int version, struct Stat *stat);
int zkrb_call_zoo_get_children(zhandle_t *zh, const char *path, int watch, struct String_vector *strings);
int zkrb_call_zoo_wget_children(zhandle_t *zh, const char *path, watcher_fn watcher, void* watcherCtx, struct String_vector *strings);
int zkrb_call_zoo_get_children2(zhandle_t *zh, const char *path, int watch, struct String_vector *strings, struct Stat *stat);
int zkrb_call_zoo_wget_children2(zhandle_t *zh, const char *path, watcher_fn watcher, void* watcherCtx, struct String_vector *strings, struct Stat *stat);
int zkrb_call_zoo_get_acl(zhandle_t *zh, const char *path, struct ACL_vector *acl, struct Stat *stat);
int zkrb_call_zoo_set_acl(zhandle_t *zh, const char *path, int version, const struct ACL_vector *acl);
int zkrb_call_zoo_multi(zhandle_t *zh, int count, const zoo_op_t *ops, zoo_op_result_t *results);

#endif /* ZKRB_WRAPPER_H */
