/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.dockbar.event;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import org.flexdock.dockbar.Dockbar;
import org.flexdock.dockbar.DockbarLabel;
import org.flexdock.dockbar.DockbarManager;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.props.PropertyChangeListenerFactory;
import org.flexdock.util.DockingUtility;

public class DockablePropertyChangeHandler
implements PropertyChangeListener {
    public static final DockablePropertyChangeHandler DEFAULT_INSTANCE = new DockablePropertyChangeHandler();

    public void propertyChange(PropertyChangeEvent evt) {
        if (!(evt.getSource() instanceof Dockable)) {
            return;
        }
        Dockable dockable = (Dockable)evt.getSource();
        if (!DockingUtility.isMinimized(dockable)) {
            return;
        }
        String pName = evt.getPropertyName();
        DockbarLabel label = this.getDockbarLabel(dockable);
        if (label == null) {
            return;
        }
        if ("Dockable.TAB_ICON".equals(pName) || "Dockable.DOCKBAR_ICON".equals(pName)) {
            Icon icon = dockable.getDockingProperties().getDockbarIcon();
            if (icon == null) {
                icon = dockable.getDockingProperties().getTabIcon();
            }
            label.setIcon(icon);
        } else if ("Dockable.DESCRIPTION".equals(pName)) {
            label.setText(dockable.getDockingProperties().getDockableDesc());
        }
    }

    private DockbarLabel getDockbarLabel(Dockable dockable) {
        DockbarManager mgr = DockbarManager.getCurrent();
        Dockbar dockbar = mgr == null ? null : mgr.getDockbar(dockable);
        return dockbar == null ? null : dockbar.getLabel(dockable);
    }

    public static class Factory
    extends PropertyChangeListenerFactory {
        public PropertyChangeListener getListener() {
            return DEFAULT_INSTANCE;
        }
    }
}

