/*
 * Decompiled with CFR 0.152.
 */
package jmapps.util;

import com.sun.media.rtp.RTPSessionMgr;
import com.sun.media.util.JMFI18N;
import java.awt.Frame;
import java.io.IOException;
import java.net.InetAddress;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.Codec;
import javax.media.Effect;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.NoDataSourceException;
import javax.media.Player;
import javax.media.Processor;
import javax.media.bean.playerbean.MediaPlayer;
import javax.media.control.FormatControl;
import javax.media.control.TrackControl;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.DataSource;
import javax.media.rtp.RTPManager;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.SessionAddress;
import jmapps.ui.MessageDialog;
import jmapps.util.StateHelper;

public class JMFUtils {
    public static MediaPlayer createMediaPlayer(String nameUrl, Frame frame, String audioEffect, String videoEffect) {
        Processor player;
        MediaPlayer mediaPlayer;
        MediaLocator mediaLocator;
        block13: {
            mediaLocator = null;
            mediaPlayer = null;
            player = null;
            mediaLocator = new MediaLocator(nameUrl);
            if (mediaLocator == null || nameUrl.equals("")) {
                MessageDialog.createErrorDialog(frame, JMFI18N.getResource("jmstudio.error.buildurlfor") + " " + nameUrl);
                return null;
            }
            if (audioEffect != null || videoEffect != null) {
                try {
                    Processor proc = Manager.createProcessor(mediaLocator);
                    StateHelper sh = new StateHelper(proc);
                    if (sh.configure()) {
                        TrackControl[] tc = proc.getTrackControls();
                        int i2 = 0;
                        while (i2 < tc.length) {
                            if (audioEffect != null && tc[i2].isEnabled() && tc[i2].getFormat() instanceof AudioFormat) {
                                JMFUtils.assignEffect(tc[i2], audioEffect);
                            } else if (videoEffect != null && tc[i2].isEnabled() && tc[i2].getFormat() instanceof VideoFormat) {
                                JMFUtils.assignEffect(tc[i2], videoEffect);
                            }
                            ++i2;
                        }
                        proc.setContentDescriptor(null);
                        if (sh.realize()) {
                            player = proc;
                        }
                    }
                }
                catch (Throwable t) {
                    if (!(t instanceof ThreadDeath)) break block13;
                    throw (ThreadDeath)t;
                }
            }
        }
        mediaPlayer = new MediaPlayer();
        if (player == null) {
            mediaPlayer.setMediaLocator(mediaLocator);
        } else {
            mediaPlayer.setControlPanelVisible(false);
            mediaPlayer.setPlayer(player);
        }
        if (mediaPlayer.getPlayer() == null) {
            MessageDialog.createErrorDialog(frame, JMFI18N.getResource("jmstudio.error.player.createfor") + " " + nameUrl);
            return null;
        }
        return mediaPlayer;
    }

    public static MediaPlayer createMediaPlayer(DataSource dataSource, Frame frame) {
        MediaPlayer mediaPlayer = null;
        if (dataSource == null) {
            MessageDialog.createErrorDialog(frame, JMFI18N.getResource("jmstudio.error.player.createfor") + " " + dataSource);
            return null;
        }
        mediaPlayer = new MediaPlayer();
        mediaPlayer.setDataSource(dataSource);
        if (mediaPlayer.getPlayer() == null) {
            MessageDialog.createErrorDialog(frame, JMFI18N.getResource("jmstudio.error.player.createfor") + " " + dataSource);
            return null;
        }
        return mediaPlayer;
    }

    public static MediaPlayer createMediaPlayer(Player player, Frame frame) {
        MediaPlayer mediaPlayer = null;
        if (player == null) {
            MessageDialog.createErrorDialog(frame, JMFI18N.getResource("jmstudio.error.player.createfor") + " " + player);
            return null;
        }
        mediaPlayer = new MediaPlayer();
        mediaPlayer.setPlayer(player);
        if (mediaPlayer.getPlayer() == null) {
            MessageDialog.createErrorDialog(frame, JMFI18N.getResource("jmstudio.error.player.createfor") + " " + player);
            return null;
        }
        return mediaPlayer;
    }

    private static void assignEffect(TrackControl tc, String effect) {
        block2: {
            try {
                Class<?> cl = Class.forName(effect);
                Effect ef = (Effect)cl.newInstance();
                Codec[] codecs = new Codec[]{ef};
                tc.setCodecChain(codecs);
            }
            catch (Throwable t) {
                if (!(t instanceof ThreadDeath)) break block2;
                throw (ThreadDeath)t;
            }
        }
    }

    public static DataSource createCaptureDataSource(String strAudioDevice, Format audioFormat, String strVideoDevice, Format videoFormat) {
        DataSource dsOne = null;
        DataSource dsTwo = null;
        DataSource merged = null;
        if (strAudioDevice == null && strVideoDevice == null) {
            return null;
        }
        if (strAudioDevice == null || strVideoDevice == null) {
            dsOne = strAudioDevice != null ? JMFUtils.initializeCaptureDataSource(null, strAudioDevice, audioFormat) : JMFUtils.initializeCaptureDataSource(null, strVideoDevice, videoFormat);
        } else if (!strAudioDevice.equals(strVideoDevice)) {
            dsOne = JMFUtils.initializeCaptureDataSource(null, strAudioDevice, audioFormat);
            if (dsOne == null) {
                return null;
            }
            dsTwo = JMFUtils.initializeCaptureDataSource(null, strVideoDevice, videoFormat);
            if (dsTwo == null) {
                return null;
            }
            DataSource[] sources = new DataSource[]{dsOne, dsTwo};
            try {
                merged = Manager.createMergingDataSource(sources);
            }
            catch (IncompatibleSourceException ise) {
                // empty catch block
            }
            dsOne = merged;
        } else {
            dsOne = JMFUtils.initializeCaptureDataSource(null, strAudioDevice, audioFormat);
            if (dsOne == null) {
                return null;
            }
            dsOne = JMFUtils.initializeCaptureDataSource(dsOne, strVideoDevice, videoFormat);
        }
        if (dsOne == null) {
            return null;
        }
        try {
            dsOne.connect();
        }
        catch (IOException ioe) {
            return null;
        }
        return dsOne;
    }

    public static DataSource initializeCaptureDataSource(DataSource ds, String deviceName, Format format) {
        DataSource dataSource = ds;
        if (ds == null) {
            CaptureDeviceInfo cdi = CaptureDeviceManager.getDevice(deviceName);
            if (cdi == null) {
                return null;
            }
            MediaLocator deviceURL = cdi.getLocator();
            try {
                dataSource = Manager.createDataSource(deviceURL);
                if (dataSource == null) {
                    return null;
                }
            }
            catch (NoDataSourceException ndse) {
                return null;
            }
            catch (IOException ioe) {
                return null;
            }
        }
        if (format == null) {
            return dataSource;
        }
        if (format != null && !(dataSource instanceof CaptureDevice)) {
            return null;
        }
        FormatControl[] formatControls = ((CaptureDevice)((Object)dataSource)).getFormatControls();
        if (formatControls == null || formatControls.length == 0) {
            return null;
        }
        int i2 = 0;
        while (i2 < formatControls.length) {
            if (formatControls[i2] != null) {
                Format[] formats = formatControls[i2].getSupportedFormats();
                if (formats == null) {
                    return null;
                }
                if (JMFUtils.matches(format, formats) != null) {
                    formatControls[i2].setFormat(format);
                    return dataSource;
                }
            }
            ++i2;
        }
        return null;
    }

    private static Format matches(Format format, Format[] supported) {
        if (supported == null) {
            return null;
        }
        int i2 = 0;
        while (i2 < supported.length) {
            if (supported[i2].matches(format)) {
                return supported[i2];
            }
            ++i2;
        }
        return null;
    }

    public static RTPSessionMgr createSessionManager(String strAddress, String strPort, String strTtl, ReceiveStreamListener listener) {
        int nPort = Integer.valueOf(strPort);
        int nTtl = Integer.valueOf(strTtl);
        RTPSessionMgr mngrSession = JMFUtils.createSessionManager(strAddress, nPort, nTtl, listener);
        return mngrSession;
    }

    public static RTPSessionMgr createSessionManager(String strAddress, int nPort, int nTtl, ReceiveStreamListener listener) {
        String nameUser = null;
        RTPSessionMgr mngrSession = (RTPSessionMgr)RTPManager.newInstance();
        if (mngrSession == null) {
            return null;
        }
        if (listener != null) {
            mngrSession.addReceiveStreamListener(listener);
        }
        String cname = mngrSession.generateCNAME();
        try {
            nameUser = System.getProperty("user.name");
        }
        catch (SecurityException e2) {
            nameUser = "jmf-user";
        }
        SessionAddress addrLocal = new SessionAddress();
        try {
            SessionAddress destAddr;
            SessionAddress localAddr;
            InetAddress addrDest = InetAddress.getByName(strAddress);
            SessionAddress addrSession = new SessionAddress(addrDest, nPort, addrDest, nPort + 1);
            if (addrDest.isMulticastAddress()) {
                localAddr = new SessionAddress(addrDest, nPort, nTtl);
                destAddr = new SessionAddress(addrDest, nPort, nTtl);
            } else {
                localAddr = new SessionAddress(InetAddress.getLocalHost(), nPort);
                destAddr = new SessionAddress(addrDest, nPort);
            }
            mngrSession.initialize(localAddr);
            mngrSession.addTarget(destAddr);
        }
        catch (Exception e3) {
            return null;
        }
        return mngrSession;
    }
}

