/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.expiry;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationResult;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationStatus;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationStrategy;

public class AllDaemonExpirationStrategy
implements DaemonExpirationStrategy {
    private Iterable<DaemonExpirationStrategy> expirationStrategies;

    public AllDaemonExpirationStrategy(List<DaemonExpirationStrategy> expirationStrategies) {
        this.expirationStrategies = expirationStrategies;
    }

    @Override
    public DaemonExpirationResult checkExpiration() {
        DaemonExpirationResult expirationResult = DaemonExpirationResult.NOT_TRIGGERED;
        DaemonExpirationStatus expirationStatus = DaemonExpirationStatus.DO_NOT_EXPIRE;
        ArrayList<String> reasons = new ArrayList<String>();
        for (DaemonExpirationStrategy expirationStrategy : this.expirationStrategies) {
            expirationResult = expirationStrategy.checkExpiration();
            if (expirationResult.getStatus() == DaemonExpirationStatus.DO_NOT_EXPIRE) {
                return DaemonExpirationResult.NOT_TRIGGERED;
            }
            reasons.add(expirationResult.getReason());
            expirationStatus = DaemonExpirationStatus.highestPriorityOf((DaemonExpirationStatus)expirationResult.getStatus(), (DaemonExpirationStatus)expirationStatus);
        }
        if (expirationResult.getStatus() == DaemonExpirationStatus.DO_NOT_EXPIRE) {
            return DaemonExpirationResult.NOT_TRIGGERED;
        }
        return new DaemonExpirationResult(expirationStatus, Joiner.on((String)" and ").skipNulls().join(reasons));
    }
}

