/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.factories;

import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.factories.ExcludeFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeEverything;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeNothing;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeSpec;

public abstract class Optimizations {
    public static ExcludeSpec optimizeAnyOf(ExcludeSpec one, ExcludeSpec two, BiFunction<ExcludeSpec, ExcludeSpec, ExcludeSpec> onMiss) {
        if (one == null) {
            return two;
        }
        if (two == null) {
            return one;
        }
        if (one.equals(two)) {
            return one;
        }
        if (one instanceof ExcludeEverything) {
            return one;
        }
        if (one instanceof ExcludeNothing) {
            return two;
        }
        if (two instanceof ExcludeEverything) {
            return two;
        }
        if (two instanceof ExcludeNothing) {
            return one;
        }
        return onMiss.apply(one, two);
    }

    public static ExcludeSpec optimizeAllOf(ExcludeFactory factory, ExcludeSpec one, ExcludeSpec two, BiFunction<ExcludeSpec, ExcludeSpec, ExcludeSpec> onMiss) {
        if (one == null) {
            return two;
        }
        if (two == null) {
            return one;
        }
        if (one.equals(two)) {
            return one;
        }
        if (one instanceof ExcludeEverything) {
            return two;
        }
        if (one instanceof ExcludeNothing) {
            return factory.nothing();
        }
        if (two instanceof ExcludeEverything) {
            return one;
        }
        if (two instanceof ExcludeNothing) {
            return factory.nothing();
        }
        return onMiss.apply(one, two);
    }

    public static <T extends Collection<ExcludeSpec>> ExcludeSpec optimizeCollection(ExcludeFactory factory, T specs, Function<T, ExcludeSpec> onMiss) {
        if (specs.isEmpty()) {
            return factory.nothing();
        }
        if (specs.size() == 1) {
            return specs.iterator().next();
        }
        return onMiss.apply(specs);
    }
}

