/*
 * Decompiled with CFR 0.152.
 */
package free.jin.ui;

import free.jin.I18n;
import free.jin.Jin;
import free.jin.Preferences;
import free.jin.SessionEvent;
import free.jin.plugin.Plugin;
import free.jin.plugin.PluginUIContainer;
import free.jin.plugin.PluginUIEvent;
import free.jin.ui.AbstractPluginUIContainer;
import free.jin.ui.AbstractUiProvider;
import free.jin.ui.ActionsMenu;
import free.jin.ui.DialogPanel;
import free.jin.ui.HelpMenu;
import free.jin.ui.PluginContainersMenu;
import free.jin.ui.PrefsMenu;
import free.util.AWTUtilities;
import free.util.RectDouble;
import free.workarounds.FixedJFrame;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Enumeration;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;

public class SdiUiProvider
extends AbstractUiProvider {
    private int openDialogsCount = 0;
    static /* synthetic */ Class class$free$jin$ui$SdiUiProvider;
    static /* synthetic */ Class class$free$jin$Jin;

    public void start() {
        super.start();
        Jin.getInstance().getConnManager().start();
    }

    public void sessionClosed(SessionEvent sessionEvent) {
        super.sessionClosed(sessionEvent);
        if (sessionEvent.getSession().getPort() != -1) {
            Jin.getInstance().quit(false);
        }
    }

    public PluginUIContainer createPluginUIContainer(Plugin plugin, String string, int n) {
        FramePluginUIContainer framePluginUIContainer = new FramePluginUIContainer(plugin, string, n);
        this.addPluginContainer(plugin, string, framePluginUIContainer);
        return framePluginUIContainer;
    }

    public void showDialog(DialogPanel dialogPanel, Component component) {
        Frame frame = component == null ? null : AWTUtilities.frameForComponent(component);
        JDialog jDialog = new JDialog(frame);
        jDialog.addWindowListener(new WindowAdapter(){
            private boolean isOpen = false;

            public void windowOpened(WindowEvent windowEvent) {
                if (!this.isOpen) {
                    this.isOpen = true;
                    SdiUiProvider.this.openDialogsCount++;
                }
            }

            public void windowClosed(WindowEvent windowEvent) {
                if (this.isOpen) {
                    this.isOpen = false;
                    SdiUiProvider.this.openDialogsCount--;
                }
            }
        });
        dialogPanel.show(jDialog, component);
    }

    public boolean isUiVisible() {
        Enumeration enumeration = this.getExistingPluginUIContainers();
        while (enumeration.hasMoreElements()) {
            PluginUIContainer pluginUIContainer = (PluginUIContainer)enumeration.nextElement();
            if (!pluginUIContainer.isVisible()) continue;
            return true;
        }
        return this.openDialogsCount > 0;
    }

    public void stop() {
    }

    private class FramePluginUIContainer
    extends AbstractPluginUIContainer
    implements WindowListener {
        private final JFrame frame;
        private final JMenuBar menubar;

        public FramePluginUIContainer(Plugin plugin, String string, int n) {
            super(plugin, string, n);
            this.frame = new FixedJFrame("");
            this.frame.setDefaultCloseOperation(0);
            this.frame.addWindowListener(this);
            this.menubar = new JMenuBar();
            I18n i18n = I18n.get(class$free$jin$ui$SdiUiProvider == null ? (class$free$jin$ui$SdiUiProvider = SdiUiProvider.class$("free.jin.ui.SdiUiProvider")) : class$free$jin$ui$SdiUiProvider);
            PluginContainersMenu pluginContainersMenu = new PluginContainersMenu(SdiUiProvider.this.getExistingPluginUIContainers());
            i18n.initAbstractButton(pluginContainersMenu, "windowsMenu");
            SdiUiProvider.this.addPluginUIContainerCreationListener(pluginContainersMenu);
            ActionsMenu actionsMenu = new ActionsMenu();
            this.menubar.add(actionsMenu);
            this.menubar.add(new PrefsMenu());
            this.menubar.add(pluginContainersMenu);
            this.menubar.add(new HelpMenu());
            this.frame.setJMenuBar(this.menubar);
            this.setIconImpl(Toolkit.getDefaultToolkit().getImage((class$free$jin$Jin == null ? (class$free$jin$Jin = SdiUiProvider.class$("free.jin.Jin")) : class$free$jin$Jin).getResource("resources/icon.gif")));
            JRootPane jRootPane = this.frame.getRootPane();
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    FramePluginUIContainer.this.close();
                }
            };
            KeyStroke keyStroke = KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
            jRootPane.registerKeyboardAction(actionListener, keyStroke, 2);
        }

        public void disposeImpl() {
            this.setVisible(false);
            this.frame.dispose();
        }

        public void addMenu(JMenu jMenu) {
            this.insertMenu(jMenu, this.getMenuCount() - 1);
        }

        protected void insertMenu(JMenu jMenu, int n) {
            JMenuBar jMenuBar = this.frame.getJMenuBar();
            if (jMenuBar == null) {
                jMenuBar = new JMenuBar();
                this.frame.setJMenuBar(jMenuBar);
            }
            jMenuBar.add((Component)jMenu, n);
        }

        protected int getMenuCount() {
            JMenuBar jMenuBar = this.frame.getJMenuBar();
            return jMenuBar == null ? 0 : jMenuBar.getMenuCount();
        }

        public void setActive(boolean bl) {
            if (bl) {
                if (!this.isVisible()) {
                    this.setVisible(true);
                }
                this.frame.toFront();
            } else {
                this.frame.toBack();
            }
        }

        public boolean isActive() {
            return this.frame.isShowing() && this.frame.getFocusOwner() != null;
        }

        public void setResizable(boolean bl) {
            this.frame.setResizable(bl);
        }

        public boolean isResizable() {
            return this.frame.isResizable();
        }

        public Container getContentPane() {
            return this.frame.getContentPane();
        }

        public void setTitleImpl(String string) {
            this.frame.setTitle(string);
            this.frame.repaint();
        }

        public void setIconImpl(Image image) {
            this.frame.setIconImage(image);
        }

        public void setVisible(boolean bl) {
            if (bl == this.isVisible()) {
                return;
            }
            if (bl) {
                this.show();
            } else {
                this.hide();
            }
        }

        public boolean isVisible() {
            return this.frame.isVisible();
        }

        private void show() {
            this.loadState();
            this.frame.setVisible(true);
            this.firePluginUIEvent(new PluginUIEvent(this, 1));
        }

        private void hide() {
            this.saveState();
            this.frame.setVisible(false);
            this.firePluginUIEvent(new PluginUIEvent(this, 2));
        }

        protected void saveState() {
            String string = this.getId();
            if (string == null) {
                return;
            }
            Preferences preferences = this.getPlugin().getPrefs();
            String string2 = this.getPrefsPrefix();
            SdiUiProvider.this.saveFrameGeometry(preferences, this.frame, string2);
        }

        protected void loadState() {
            String string = this.getPrefsPrefix();
            Preferences preferences = this.getPlugin().getPrefs();
            Dimension dimension = AWTUtilities.getUsableScreenBounds().getSize();
            double d = 1.0 + 100.0 / (double)dimension.width;
            double d2 = 1.0 + 100.0 / (double)dimension.height;
            dimension.width = (int)((double)dimension.width / d);
            dimension.height = (int)((double)dimension.height / d2);
            RectDouble rectDouble = this.getInitialBounds(this.frame, dimension);
            rectDouble.scale(1.0 / d, 1.0 / d2);
            rectDouble.setX(rectDouble.getX() + (d - 1.0) / 2.0);
            rectDouble.setY(rectDouble.getY() + (d2 - 1.0) / 2.0);
            SdiUiProvider.this.restoreFrameGeometry(preferences, this.frame, string, rectDouble);
        }

        private void close() {
            switch (this.getMode()) {
                case 1: 
                case 2: {
                    this.setVisible(false);
                    break;
                }
                case 0: {
                    this.closeSession(this.frame);
                    break;
                }
                case -1: {
                    this.firePluginUIEvent(new PluginUIEvent(this, 3));
                }
            }
        }

        public void windowActivated(WindowEvent windowEvent) {
            this.firePluginUIEvent(new PluginUIEvent(this, 4));
        }

        public void windowDeactivated(WindowEvent windowEvent) {
            this.firePluginUIEvent(new PluginUIEvent(this, 5));
        }

        public void windowClosing(WindowEvent windowEvent) {
            this.close();
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }
    }
}

