/*
 * Decompiled with CFR 0.152.
 */
package free.jin.board;

import free.chess.Position;
import free.jin.I18n;
import free.jin.board.BoardManager;
import free.jin.board.JinBoard;
import free.jin.board.prefs.BoardLooksPanel;
import free.jin.board.prefs.BoardModifyingPrefsPanel;
import free.jin.board.prefs.MoveInputPanel;
import free.jin.board.prefs.SquareCoordinatesPanel;
import free.jin.ui.CompositePreferencesPanel;
import free.jin.ui.PreferencesPanel;
import free.util.SquareLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class BoardPreferencesPanel
extends CompositePreferencesPanel {
    protected final BoardManager boardManager;
    protected final JinBoard previewBoard;
    private final JTabbedPane tabs = new JTabbedPane();

    public BoardPreferencesPanel(BoardManager boardManager) {
        this.boardManager = boardManager;
        this.previewBoard = this.createPreviewBoard();
        I18n i18n = I18n.get((Class)BoardPreferencesPanel.class);
        JPanel jPanel = new JPanel((LayoutManager)new SquareLayout());
        jPanel.add((Component)((Object)this.previewBoard));
        this.previewBoard.setAlignmentX(0.5f);
        this.previewBoard.setAlignmentY(0.5f);
        this.previewBoard.setPreferredSize(new Dimension(320, 320));
        JButton jButton = i18n.createButton("resetPositionButton");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BoardPreferencesPanel.this.initPreviewBoard();
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBorder(BorderFactory.createCompoundBorder(i18n.createTitledBorder("testBoardPanel"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        jPanel.setAlignmentX(0.5f);
        jButton.setAlignmentX(0.5f);
        jPanel2.add(jPanel);
        jPanel2.add(Box.createVerticalStrut(7));
        jPanel2.add(jButton);
        this.setLayout(new BorderLayout(5, 0));
        this.add(this.tabs, "West");
        this.add(jPanel2, "Center");
        this.addPanel(this.createBoardLooksPanel(), i18n.getString("boardLooksPanel.title"), i18n.getString("boardLooksPanel.tooltip"));
        this.addPanel(this.createMoveInputPanel(), i18n.getString("moveInputPanel.title"), i18n.getString("moveInputPanel.tooltip"));
        this.addPanel(this.createSquareCoordsPanel(), i18n.getString("coordsPanel.title"), i18n.getString("coordsPanel.tooltip"));
        this.initPreviewBoard();
    }

    protected void addPanelToUi(PreferencesPanel preferencesPanel, String string, String string2) {
        this.tabs.addTab(string, null, (Component)preferencesPanel, string2);
    }

    protected JinBoard createPreviewBoard() {
        return new JinBoard(new Position());
    }

    protected void initPreviewBoard() {
        Position position = this.previewBoard.getPosition();
        position.setLexigraphic("rn-qkbnrPPP-pppp-------------b---------------------PPPPPRNBQKBNR");
        for (int i = 0; i < this.panels.size(); ++i) {
            ((BoardModifyingPrefsPanel)((Object)this.panels.elementAt(i))).initPreviewBoard();
        }
    }

    protected BoardModifyingPrefsPanel createBoardLooksPanel() {
        return new BoardLooksPanel(this.boardManager, this.previewBoard);
    }

    protected BoardModifyingPrefsPanel createMoveInputPanel() {
        return new MoveInputPanel(this.boardManager, this.previewBoard);
    }

    protected BoardModifyingPrefsPanel createSquareCoordsPanel() {
        return new SquareCoordinatesPanel(this.boardManager, this.previewBoard);
    }
}

