/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.peer.ChoicePeer;
import java.io.Serializable;
import java.util.EventListener;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Choice
extends Component
implements ItemSelectable,
Serializable,
Accessible {
    private static final long serialVersionUID = -4075310674757313071L;
    Vector pItems;
    private int selectedIndex;
    private ItemListener item_listeners;
    static /* synthetic */ Class class$java$awt$event$ItemListener;

    public int getItemCount() {
        return this.countItems();
    }

    public int countItems() {
        return this.pItems.size();
    }

    public String getItem(int n) {
        return (String)this.pItems.elementAt(n);
    }

    public synchronized void add(String string) {
        if (string == null) {
            throw new NullPointerException("item must be non-null");
        }
        this.pItems.addElement(string);
        int n = this.pItems.size() - 1;
        if (this.peer != null) {
            ChoicePeer choicePeer = (ChoicePeer)this.peer;
            choicePeer.add(string, n);
        } else if (this.selectedIndex == -1) {
            this.select(0);
        }
    }

    public synchronized void addItem(String string) {
        this.add(string);
    }

    public synchronized void insert(String string, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index may not be less then 0");
        }
        if (n > this.getItemCount()) {
            n = this.getItemCount();
        }
        this.pItems.insertElementAt(string, n);
        if (this.peer != null) {
            ChoicePeer choicePeer = (ChoicePeer)this.peer;
            choicePeer.add(string, n);
        } else if (this.selectedIndex == -1 || this.selectedIndex >= n) {
            this.select(0);
        }
    }

    public synchronized void remove(String string) {
        int n = this.pItems.indexOf(string);
        if (n == -1) {
            throw new IllegalArgumentException("item \"" + string + "\" not found in Choice");
        }
        this.remove(n);
    }

    public synchronized void remove(int n) {
        if (n < 0 || n > this.getItemCount()) {
            throw new IllegalArgumentException("Bad index: " + n);
        }
        this.pItems.removeElementAt(n);
        if (this.peer != null) {
            ChoicePeer choicePeer = (ChoicePeer)this.peer;
            choicePeer.remove(n);
        } else if (this.getItemCount() == 0) {
            this.selectedIndex = -1;
        } else if (n == this.selectedIndex) {
            this.select(0);
        }
        if (this.selectedIndex > n) {
            --this.selectedIndex;
        }
    }

    public synchronized void removeAll() {
        if (this.getItemCount() <= 0) {
            return;
        }
        this.pItems.removeAllElements();
        if (this.peer != null) {
            ChoicePeer choicePeer = (ChoicePeer)this.peer;
            choicePeer.removeAll();
        }
        this.selectedIndex = -1;
    }

    public synchronized String getSelectedItem() {
        return this.selectedIndex == -1 ? null : (String)this.pItems.elementAt(this.selectedIndex);
    }

    public synchronized Object[] getSelectedObjects() {
        if (this.selectedIndex == -1) {
            return null;
        }
        Object[] objectArray = new Object[]{this.pItems.elementAt(this.selectedIndex)};
        return objectArray;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public synchronized void select(int n) {
        if (n < 0 || n >= this.getItemCount()) {
            throw new IllegalArgumentException("Bad index: " + n);
        }
        if (this.pItems.size() > 0) {
            this.selectedIndex = n;
            ChoicePeer choicePeer = (ChoicePeer)this.peer;
            if (choicePeer != null) {
                choicePeer.select(n);
            }
        }
    }

    public synchronized void select(String string) {
        int n = this.pItems.indexOf(string);
        if (n >= 0) {
            this.select(n);
        }
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createChoice(this);
        }
        super.addNotify();
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        this.item_listeners = AWTEventMulticaster.add(this.item_listeners, itemListener);
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        this.item_listeners = AWTEventMulticaster.remove(this.item_listeners, itemListener);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)aWTEvent);
        } else {
            super.processEvent(aWTEvent);
        }
    }

    protected void processItemEvent(ItemEvent itemEvent) {
        int n = this.pItems.indexOf((String)itemEvent.getItem());
        if (itemEvent.getStateChange() == 1) {
            this.selectedIndex = n;
        }
        if (this.item_listeners != null) {
            this.item_listeners.itemStateChanged(itemEvent);
        }
    }

    protected String paramString() {
        return "selectedIndex=" + this.selectedIndex + ',' + super.paramString();
    }

    public EventListener[] getListeners(Class clazz) {
        Class clazz2 = class$java$awt$event$ItemListener;
        if (clazz2 == null) {
            clazz2 = class$java$awt$event$ItemListener = Choice.class("[Ljava.awt.event.ItemListener;", false);
        }
        if (clazz == clazz2) {
            return AWTEventMulticaster.getListeners(this.item_listeners, clazz);
        }
        return super.getListeners(clazz);
    }

    public ItemListener[] getItemListeners() {
        Class clazz = class$java$awt$event$ItemListener;
        if (clazz == null) {
            clazz = class$java$awt$event$ItemListener = Choice.class("[Ljava.awt.event.ItemListener;", false);
        }
        return (ItemListener[])this.getListeners(clazz);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTChoice();
        }
        return this.accessibleContext;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.pItems = new Vector();
        this.selectedIndex = -1;
    }

    public Choice() {
        this.this();
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class AccessibleAWTChoice
    extends Component.AccessibleAWTComponent
    implements AccessibleAction {
        private static final long serialVersionUID = 7175603582428509322L;

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.COMBO_BOX;
        }

        public int getAccessibleActionCount() {
            return Choice.this.pItems.size();
        }

        public String getAccessibleActionDescription(int n) {
            return (String)Choice.this.pItems.get(n);
        }

        public boolean doAccessibleAction(int n) {
            if (n < 0 || n >= Choice.this.pItems.size()) {
                return false;
            }
            Choice.this.processItemEvent(new ItemEvent(Choice.this, 701, this, 1));
            return true;
        }
    }
}

