type token =
  | End_of_input
  | Change_type_add
  | Change_type_modrdn
  | Change_type_modify
  | Change_type_delete
  | Dash
  | Newline
  | AttributeType of (string)
  | Dn of (string)
  | Add of (string)
  | Delete of (string)
  | Replace of (string)
  | Attr of (string * string)

open Parsing;;
let _ = parse_error;;
# 22 "src/ldif/ldif_changerec_parser.mly"
  open Ldap_ooclient

  let check_attrs attr attrs =
    List.rev_map
      (fun (declared_attr, valu) ->
         if declared_attr = attr then
           valu
         else
           failwith
             ("declared attribute " ^
                "modifies the wrong" ^
                "attribute, " ^
                "attribute: " ^ attr ^
                "declared: " ^
                declared_attr))
      attrs

  let check_empty op attr =
    match op with
        `DELETE -> (op, attr, [])
      | `ADD -> failwith "non sensical empty add"
      | `REPLACE -> failwith "non sensical empty replace"
# 42 "src/ldif/ldif_changerec_parser.ml"
let yytransl_const = [|
  257 (* End_of_input *);
  258 (* Change_type_add *);
  259 (* Change_type_modrdn *);
  260 (* Change_type_modify *);
  261 (* Change_type_delete *);
  262 (* Dash *);
  263 (* Newline *);
    0|]

let yytransl_block = [|
  264 (* AttributeType *);
  265 (* Dn *);
  266 (* Add *);
  267 (* Delete *);
  268 (* Replace *);
  269 (* Attr *);
    0|]

let yylhs = "\255\255\
\002\000\002\000\002\000\003\000\003\000\004\000\004\000\005\000\
\005\000\006\000\006\000\006\000\006\000\007\000\007\000\001\000\
\001\000\001\000\001\000\001\000\000\000"

let yylen = "\002\000\
\001\000\001\000\001\000\002\000\001\000\001\000\001\000\002\000\
\001\000\004\000\003\000\003\000\002\000\002\000\002\000\003\000\
\003\000\003\000\005\000\001\000\002\000"

let yydefred = "\000\000\
\000\000\000\000\020\000\000\000\021\000\000\000\000\000\000\000\
\000\000\000\000\017\000\000\000\001\000\002\000\003\000\000\000\
\016\000\007\000\006\000\018\000\015\000\014\000\000\000\000\000\
\000\000\000\000\009\000\013\000\019\000\008\000\011\000\004\000\
\000\000\012\000\010\000"

let yydgoto = "\002\000\
\005\000\016\000\026\000\027\000\028\000\017\000\011\000"

let yysindex = "\002\000\
\024\255\000\000\000\000\034\255\000\000\249\254\000\255\030\255\
\028\255\004\255\000\000\007\255\000\000\000\000\000\000\003\255\
\000\000\000\000\000\000\000\000\000\000\000\000\028\255\011\255\
\014\255\001\255\000\000\000\000\000\000\000\000\000\000\000\000\
\011\255\000\000\000\000"

let yyrindex = "\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\025\255\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000"

let yygindex = "\000\000\
\000\000\000\000\005\000\247\255\008\000\251\255\033\000"

let yytablesize = 43
let yytable = "\020\000\
\021\000\018\000\001\000\018\000\018\000\010\000\033\000\019\000\
\024\000\019\000\019\000\018\000\012\000\029\000\030\000\025\000\
\010\000\019\000\031\000\023\000\013\000\014\000\015\000\030\000\
\003\000\005\000\025\000\035\000\018\000\032\000\005\000\005\000\
\004\000\034\000\019\000\006\000\007\000\008\000\009\000\013\000\
\014\000\015\000\022\000"

let yycheck = "\009\000\
\010\000\001\001\001\000\001\001\001\001\013\001\006\001\007\001\
\006\001\007\001\007\001\001\001\013\001\023\000\024\000\013\001\
\013\001\007\001\024\000\013\001\010\001\011\001\012\001\033\000\
\001\001\001\001\013\001\033\000\001\001\025\000\006\001\007\001\
\009\001\026\000\007\001\002\001\003\001\004\001\005\001\010\001\
\011\001\012\001\010\000"

let yynames_const = "\
  End_of_input\000\
  Change_type_add\000\
  Change_type_modrdn\000\
  Change_type_modify\000\
  Change_type_delete\000\
  Dash\000\
  Newline\000\
  "

let yynames_block = "\
  AttributeType\000\
  Dn\000\
  Add\000\
  Delete\000\
  Replace\000\
  Attr\000\
  "

let yyact = [|
  (fun _ -> failwith "parser")
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 55 "src/ldif/ldif_changerec_parser.mly"
      ((`ADD, _1))
# 142 "src/ldif/ldif_changerec_parser.ml"
               : 'operation))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 56 "src/ldif/ldif_changerec_parser.mly"
         ((`DELETE, _1))
# 149 "src/ldif/ldif_changerec_parser.ml"
               : 'operation))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 57 "src/ldif/ldif_changerec_parser.mly"
          ((`REPLACE, _1))
# 156 "src/ldif/ldif_changerec_parser.ml"
               : 'operation))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : string * string) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'attrlst) in
    Obj.repr(
# 61 "src/ldif/ldif_changerec_parser.mly"
               (_1 :: _2)
# 164 "src/ldif/ldif_changerec_parser.ml"
               : 'attrlst))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * string) in
    Obj.repr(
# 62 "src/ldif/ldif_changerec_parser.mly"
       ([_1])
# 171 "src/ldif/ldif_changerec_parser.ml"
               : 'attrlst))
; (fun __caml_parser_env ->
    Obj.repr(
# 65 "src/ldif/ldif_changerec_parser.mly"
          ()
# 177 "src/ldif/ldif_changerec_parser.ml"
               : 'newline))
; (fun __caml_parser_env ->
    Obj.repr(
# 66 "src/ldif/ldif_changerec_parser.mly"
               ()
# 183 "src/ldif/ldif_changerec_parser.ml"
               : 'newline))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'newline) in
    Obj.repr(
# 69 "src/ldif/ldif_changerec_parser.mly"
               ()
# 190 "src/ldif/ldif_changerec_parser.ml"
               : 'modificationterminator))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'newline) in
    Obj.repr(
# 70 "src/ldif/ldif_changerec_parser.mly"
          ()
# 197 "src/ldif/ldif_changerec_parser.ml"
               : 'modificationterminator))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'operation) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'attrlst) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'modifications) in
    Obj.repr(
# 74 "src/ldif/ldif_changerec_parser.mly"
                                       (let (op, attr) = _1 in
                                          (op,
                                           attr,
                                           check_attrs attr _2) :: _4)
# 209 "src/ldif/ldif_changerec_parser.ml"
               : 'modifications))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'operation) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'modifications) in
    Obj.repr(
# 78 "src/ldif/ldif_changerec_parser.mly"
                               (let (op, attr) = _1 in
                                  (check_empty op attr) :: _3)
# 218 "src/ldif/ldif_changerec_parser.ml"
               : 'modifications))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'operation) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'attrlst) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'modificationterminator) in
    Obj.repr(
# 80 "src/ldif/ldif_changerec_parser.mly"
                                           (let (op, attr) = _1 in
                                              [(op, attr,
                                                check_attrs attr _2)])
# 229 "src/ldif/ldif_changerec_parser.ml"
               : 'modifications))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'operation) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'modificationterminator) in
    Obj.repr(
# 83 "src/ldif/ldif_changerec_parser.mly"
                                   (let (op, attr) = _1 in
                                      [(check_empty op attr)])
# 238 "src/ldif/ldif_changerec_parser.ml"
               : 'modifications))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : string * string) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'entry) in
    Obj.repr(
# 88 "src/ldif/ldif_changerec_parser.mly"
             (let (a, v) = _1 in (a, [v]) :: _2)
# 246 "src/ldif/ldif_changerec_parser.ml"
               : 'entry))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : string * string) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'newline) in
    Obj.repr(
# 89 "src/ldif/ldif_changerec_parser.mly"
               (let (a, v) = _1 in [(a, [v])])
# 254 "src/ldif/ldif_changerec_parser.ml"
               : 'entry))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : string) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'modifications) in
    Obj.repr(
# 92 "src/ldif/ldif_changerec_parser.mly"
                                      (`Modification (_1, List.rev _3))
# 262 "src/ldif/ldif_changerec_parser.ml"
               : Ldap_ooclient.changerec))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : string) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'entry) in
    Obj.repr(
# 93 "src/ldif/ldif_changerec_parser.mly"
                           (let e = new ldapentry in
                              e#set_dn _1;e#add _3;`Addition e)
# 271 "src/ldif/ldif_changerec_parser.ml"
               : Ldap_ooclient.changerec))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : string) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'newline) in
    Obj.repr(
# 95 "src/ldif/ldif_changerec_parser.mly"
                                (`Delete _1)
# 279 "src/ldif/ldif_changerec_parser.ml"
               : Ldap_ooclient.changerec))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : string) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : string * string) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : string * string) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : 'newline) in
    Obj.repr(
# 96 "src/ldif/ldif_changerec_parser.mly"
                                          (`Modrdn
                                             (_1,
                                              int_of_string (snd _3),
                                              snd _4))
# 292 "src/ldif/ldif_changerec_parser.ml"
               : Ldap_ooclient.changerec))
; (fun __caml_parser_env ->
    Obj.repr(
# 100 "src/ldif/ldif_changerec_parser.mly"
               (raise Ldif_types.Changerec_parser_end)
# 298 "src/ldif/ldif_changerec_parser.ml"
               : Ldap_ooclient.changerec))
(* Entry changerec *)
; (fun __caml_parser_env -> raise (Parsing.YYexit (Parsing.peek_val __caml_parser_env 0)))
|]
let yytables =
  { Parsing.actions=yyact;
    Parsing.transl_const=yytransl_const;
    Parsing.transl_block=yytransl_block;
    Parsing.lhs=yylhs;
    Parsing.len=yylen;
    Parsing.defred=yydefred;
    Parsing.dgoto=yydgoto;
    Parsing.sindex=yysindex;
    Parsing.rindex=yyrindex;
    Parsing.gindex=yygindex;
    Parsing.tablesize=yytablesize;
    Parsing.table=yytable;
    Parsing.check=yycheck;
    Parsing.error_function=parse_error;
    Parsing.names_const=yynames_const;
    Parsing.names_block=yynames_block }
let changerec (lexfun : Lexing.lexbuf -> token) (lexbuf : Lexing.lexbuf) =
   (Parsing.yyparse yytables 1 lexfun lexbuf : Ldap_ooclient.changerec)
