/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecodecvssnap;

import gnu.bytecodecvssnap.ArrayType;
import gnu.bytecodecvssnap.ClassType;
import gnu.bytecodecvssnap.CodeAttr;
import gnu.bytecodecvssnap.Method;
import gnu.bytecodecvssnap.ObjectType;
import gnu.bytecodecvssnap.PrimType;
import java.util.Hashtable;

public abstract class Type {
    static Hashtable mapClassToType;
    static Hashtable mapNameToType;
    public static final PrimType byte_type;
    public static final PrimType short_type;
    public static final PrimType int_type;
    public static final PrimType long_type;
    public static final PrimType float_type;
    public static final PrimType double_type;
    public static final PrimType boolean_type;
    public static final PrimType char_type;
    public static final PrimType void_type;
    public static final PrimType neverReturnsType;
    public static final ObjectType nullType;
    public static ClassType string_type;
    public static final ClassType tostring_type;
    public static final ClassType pointer_type;
    public static final ClassType boolean_ctype;
    public static final ClassType throwable_type;
    public static final Type[] typeArray0;
    public static final Method toString_method;
    public static final ClassType number_type;
    public static final Method intValue_method;
    public static final Method longValue_method;
    public static final Method floatValue_method;
    public static final Method doubleValue_method;
    public static final Method booleanValue_method;
    public static final ClassType java_lang_Class_type;
    String signature;
    String this_name;
    int size;
    ArrayType array_type;
    protected Class reflectClass;

    public Type getImplementationType() {
        return this;
    }

    public static Type lookupType(String string) {
        return (Type)mapNameToType.get(string);
    }

    public static Type getType(String string) {
        Type type = Type.lookupType(string);
        if (type == null) {
            if (string.endsWith("[]")) {
                type = ArrayType.make(string);
            } else {
                ClassType classType = new ClassType(string);
                classType.flags |= 4;
                type = classType;
            }
            mapNameToType.put(string, type);
        }
        return type;
    }

    public static void registerTypeForClass(Class clazz, Type type) {
        if (mapClassToType == null) {
            mapClassToType = new Hashtable(100);
        }
        mapClassToType.put(clazz, type);
        type.reflectClass = clazz;
    }

    public static Type make(Class clazz) {
        Type type;
        Object object;
        if (mapClassToType != null && (object = mapClassToType.get(clazz)) != null) {
            return (Type)object;
        }
        if (clazz.isArray()) {
            type = ArrayType.make(Type.make(clazz.getComponentType()));
        } else {
            if (clazz.isPrimitive()) {
                throw new Error("internal error - primitive type not found");
            }
            object = clazz.getName();
            type = Type.lookupType((String)object);
            if (type == null || type.reflectClass != clazz && type.reflectClass != null) {
                ClassType classType = new ClassType((String)object);
                classType.flags |= 4;
                type = classType;
                mapNameToType.put(object, type);
            }
        }
        type.reflectClass = clazz;
        Type.registerTypeForClass(clazz, type);
        return type;
    }

    public final String getSignature() {
        return this.signature;
    }

    protected void setSignature(String string) {
        this.signature = string;
    }

    public Type promote() {
        return this.size < 4 ? int_type : this;
    }

    public final int getSize() {
        return this.size;
    }

    public final boolean isVoid() {
        boolean bl = false;
        if (this.size == 0) {
            bl = true;
        }
        return bl;
    }

    public static PrimType signatureToPrimitive(char c) {
        switch (c) {
            case 'B': {
                return byte_type;
            }
            case 'C': {
                return char_type;
            }
            case 'D': {
                return double_type;
            }
            case 'F': {
                return float_type;
            }
            case 'S': {
                return short_type;
            }
            case 'I': {
                return int_type;
            }
            case 'J': {
                return long_type;
            }
            case 'Z': {
                return boolean_type;
            }
            case 'V': {
                return void_type;
            }
        }
        return null;
    }

    public static Type signatureToType(String string, int n, int n2) {
        Type type;
        if (n2 == 0) {
            return null;
        }
        char c = string.charAt(n);
        if (n2 == 1 && (type = Type.signatureToPrimitive(c)) != null) {
            return type;
        }
        if (c == '[') {
            type = Type.signatureToType(string, n + 1, n2 - 1);
            return type == null ? null : ArrayType.make(type);
        }
        if (c == 'L' && n2 > 2 && string.indexOf(59, n) == n2 - 1 + n) {
            return ClassType.make(string.substring(n + 1, n2 - 1 + n).replace('/', '.'));
        }
        return null;
    }

    public static Type signatureToType(String string) {
        return Type.signatureToType(string, 0, string.length());
    }

    public static int signatureLength(String string, int n) {
        int n2;
        int n3 = string.length();
        if (n3 <= n) {
            return -1;
        }
        char c = string.charAt(n);
        int n4 = 0;
        while (c == '[') {
            ++n4;
            c = string.charAt(++n);
        }
        if (Type.signatureToPrimitive(c) != null) {
            return n4 + 1;
        }
        if (c == 'L' && (n2 = string.indexOf(59, n)) > 0) {
            return n4 + n2 + 1 - n;
        }
        return -1;
    }

    public static int signatureLength(String string) {
        return Type.signatureLength(string, 0);
    }

    public static String signatureToName(String string) {
        PrimType primType;
        int n = string.length();
        if (n == 0) {
            return null;
        }
        char c = string.charAt(0);
        if (n == 1 && (primType = Type.signatureToPrimitive(c)) != null) {
            return primType.getName();
        }
        if (c == '[') {
            int n2 = 1;
            if (n2 < n && string.charAt(n2) == '[') {
                ++n2;
            }
            if ((string = Type.signatureToName(string.substring(n2))) == null) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer(50);
            stringBuffer.append(string);
            while (--n2 >= 0) {
                stringBuffer.append("[]");
            }
            return stringBuffer.toString();
        }
        if (c == 'L' && n > 2 && string.indexOf(59) == n - 1) {
            return string.substring(1, n - 1).replace('/', '.');
        }
        return null;
    }

    public final String getName() {
        return this.this_name;
    }

    protected void setName(String string) {
        this.this_name = string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isValidJavaTypeName(String string) {
        boolean bl = false;
        int n = string.length();
        while (n > 2 && string.charAt(n - 1) == ']' && string.charAt(n - 2) == '[') {
            n -= 2;
        }
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '.') {
                if (!bl) return false;
                bl = false;
            } else {
                if (bl) {
                    if (!Character.isJavaIdentifierPart(c)) return false;
                } else if (!Character.isJavaIdentifierStart(c)) return false;
                bl = true;
            }
            ++n2;
        }
        boolean bl2 = false;
        if (n2 != n) return bl2;
        return true;
    }

    public boolean isInstance(Object object) {
        return this.getReflectClass().isInstance(object);
    }

    public final boolean isSubtype(Type type) {
        int n = this.compare(type);
        boolean bl = false;
        if (n == -1 || n == 0) {
            bl = true;
        }
        return bl;
    }

    public static Type lowestCommonSuperType(Type type, Type type2) {
        if (type == neverReturnsType) {
            return type2;
        }
        if (type2 == neverReturnsType) {
            return type;
        }
        if (type == null || type2 == null) {
            return null;
        }
        if (type.isSubtype(type2)) {
            return type2;
        }
        if (type2.isSubtype(type)) {
            return type;
        }
        if (!(type instanceof ClassType) || !(type2 instanceof ClassType)) {
            return null;
        }
        ClassType classType = (ClassType)type;
        ClassType classType2 = (ClassType)type2;
        if (classType.isInterface()) {
            return pointer_type;
        }
        if (classType2.isInterface()) {
            return pointer_type;
        }
        return Type.lowestCommonSuperType(classType.getSuperclass(), classType2.getSuperclass());
    }

    public abstract int compare(Type var1);

    protected static int swappedCompareResult(int n) {
        int n2;
        if (n == 1) {
            n2 = -1;
        } else {
            n2 = 1;
            if (n != -1) {
                n2 = n;
            }
        }
        return n2;
    }

    public static boolean isMoreSpecific(Type[] typeArray, Type[] typeArray2) {
        if (typeArray.length != typeArray2.length) {
            return false;
        }
        int n = typeArray.length;
        while (--n >= 0) {
            if (typeArray[n].isSubtype(typeArray2[n])) continue;
            return false;
        }
        return true;
    }

    public void emitIsInstance(CodeAttr codeAttr) {
        codeAttr.emitInstanceof(this);
    }

    public abstract Object coerceFromObject(Object var1);

    public Object coerceToObject(Object object) {
        return object;
    }

    public void emitCoerceToObject(CodeAttr codeAttr) {
    }

    public void emitCoerceFromObject(CodeAttr codeAttr) {
        throw new Error("unimplemented emitCoerceFromObject for " + this);
    }

    public Class getReflectClass() {
        return this.reflectClass;
    }

    public void setReflectClass(Class clazz) {
        this.reflectClass = clazz;
    }

    public String toString() {
        return "Type " + this.getName();
    }

    public int hashCode() {
        String string = this.toString();
        int n = 0;
        if (string != null) {
            n = string.hashCode();
        }
        return n;
    }

    protected Type() {
    }

    Type(String string, String string2) {
        this.this_name = string;
        this.signature = string2;
    }

    static {
        byte_type = new PrimType("byte", "B", 1, Byte.TYPE);
        short_type = new PrimType("short", "S", 2, Short.TYPE);
        int_type = new PrimType("int", "I", 4, Integer.TYPE);
        long_type = new PrimType("long", "J", 8, Long.TYPE);
        float_type = new PrimType("float", "F", 4, Float.TYPE);
        double_type = new PrimType("double", "D", 8, Double.TYPE);
        boolean_type = new PrimType("boolean", "Z", 1, Boolean.TYPE);
        char_type = new PrimType("char", "C", 2, Character.TYPE);
        void_type = new PrimType("void", "V", 0, Void.TYPE);
        mapNameToType = new Hashtable();
        mapNameToType.put("byte", byte_type);
        mapNameToType.put("short", short_type);
        mapNameToType.put("int", int_type);
        mapNameToType.put("long", long_type);
        mapNameToType.put("float", float_type);
        mapNameToType.put("double", double_type);
        mapNameToType.put("boolean", boolean_type);
        mapNameToType.put("char", char_type);
        mapNameToType.put("void", void_type);
        neverReturnsType = new PrimType(void_type);
        Type.neverReturnsType.this_name = "(never-returns)";
        nullType = new ObjectType("(type of null)");
        string_type = ClassType.make("java.lang.String");
        tostring_type = new ClassType("java.lang.String");
        pointer_type = ClassType.make("java.lang.Object");
        boolean_ctype = ClassType.make("java.lang.Boolean");
        throwable_type = ClassType.make("java.lang.Throwable");
        typeArray0 = new Type[0];
        toString_method = pointer_type.getDeclaredMethod("toString", 0);
        number_type = ClassType.make("java.lang.Number");
        intValue_method = number_type.addMethod("intValue", typeArray0, int_type, 1);
        longValue_method = number_type.addMethod("longValue", typeArray0, long_type, 1);
        floatValue_method = number_type.addMethod("floatValue", typeArray0, float_type, 1);
        doubleValue_method = number_type.addMethod("doubleValue", typeArray0, double_type, 1);
        booleanValue_method = boolean_ctype.addMethod("booleanValue", typeArray0, boolean_type, 1);
        java_lang_Class_type = ClassType.make("java.lang.Class");
    }
}

