/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.ExpressionImage;
import gnu.jel.OP;
import gnu.jel.OP_convert;
import gnu.jel.OP_function;
import gnu.jel.OP_load;
import gnu.jel.OPlist;

class OP_conditional
extends OP_function {
    OPlist trueList;
    OPlist falseList;

    OP_conditional() {
    }

    boolean canInterpret() {
        return false;
    }

    void compile(ExpressionImage expressionImage) {
        expressionImage.asm_branch_start_true();
        this.trueList.compile(expressionImage);
        expressionImage.asm_branch_start_false();
        this.falseList.compile(expressionImage);
        expressionImage.asm_branch_end();
    }

    void interpret(OPlist oPlist) throws Throwable {
    }

    public boolean optimize(OPlist oPlist) throws Throwable {
        boolean bl;
        if (this.prev instanceof OP_load) {
            boolean bl2 = (Boolean)((OP_load)this.prev).what;
            oPlist.remove(this.prev);
            bl = true;
            OPlist oPlist2 = bl2 ? this.trueList : this.falseList;
            oPlist2.optimize();
            OP oP = oPlist2.getFirst();
            while (oP != null) {
                OP oP2 = oP.next;
                oPlist2.remove(oP);
                oPlist.addBefore(this, oP);
                oP = oP2;
            }
            oPlist.remove(this);
        } else {
            bl = this.trueList.optimize();
            bl = this.falseList.optimize() || bl;
        }
        return bl;
    }

    public void setFalseList(OPlist oPlist) {
        this.falseList = oPlist;
    }

    public void setTrueList(OPlist oPlist) {
        this.trueList = oPlist;
    }

    public void setType(Class clazz) {
        OP oP = this.trueList.getLast();
        if (oP instanceof OP_convert) {
            ((OP_convert)oP).setType(clazz);
        } else {
            this.trueList.addLast(new OP_convert(clazz));
        }
        OP oP2 = this.falseList.getLast();
        if (oP2 instanceof OP_convert) {
            ((OP_convert)oP2).setType(clazz);
        } else {
            this.falseList.addLast(new OP_convert(clazz));
        }
    }

    public String toString() {
        return "[?" + this.trueList.toString() + ":" + this.falseList.toString() + "]";
    }
}

