/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.engine;

import com.xerox.VTM.engine.AccEView;
import com.xerox.VTM.engine.AccIView;
import com.xerox.VTM.engine.AnimManager;
import com.xerox.VTM.engine.AppletView;
import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.EView;
import com.xerox.VTM.engine.GLEView;
import com.xerox.VTM.engine.IView;
import com.xerox.VTM.engine.IViewContainer;
import com.xerox.VTM.engine.JPanelView;
import com.xerox.VTM.engine.LongPoint;
import com.xerox.VTM.engine.View;
import com.xerox.VTM.engine.VirtualSpace;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.RectangularShape;
import com.xerox.VTM.glyphs.VPath;
import com.xerox.VTM.glyphs.VText;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import net.claribole.zvtm.engine.Location;
import net.claribole.zvtm.engine.Portal;
import net.claribole.zvtm.engine.PostAnimationAction;
import net.claribole.zvtm.engine.RepaintListener;
import net.claribole.zvtm.glyphs.CGlyph;
import net.claribole.zvtm.lens.Lens;

public class VirtualSpaceManager
implements AWTEventListener {
    static Font mainFont = new Font("Dialog", 0, 10);
    public static short VIS_AND_SENS_GLYPHS = 0;
    public static short VISIBLE_GLYPHS = 1;
    public static short SENSITIVE_GLYPHS = (short)2;
    public static short ALL_GLYPHS = (short)3;
    static boolean debug = false;
    private long nextID;
    private int nextcID;
    protected int nextlID;
    protected int nextpID;
    private int nextmID;
    protected Hashtable allGlyphs;
    protected Hashtable allCameras;
    protected Hashtable allPortals;
    protected Hashtable allLenses;
    protected Hashtable allVirtualSpaces;
    protected View[] allViews;
    protected Hashtable name2viewIndex;
    public View activeView;
    protected int activeViewIndex = -1;
    boolean generalRepaintPolicy = true;
    boolean defaultMultiFill = false;
    float textAsLineCoef = 0.5f;
    public boolean mouseSync;
    public AnimManager animator;
    protected int zoomFloor = 0;
    Color mouseInsideColor = Color.white;
    Object activeJFrame = null;

    public static Font getMainFont() {
        return mainFont;
    }

    public void setMainFont(Font f) {
        mainFont = f;
        for (int i = 0; i < this.allViews.length; ++i) {
            this.allViews[i].updateFont();
        }
        Enumeration e = this.allGlyphs.elements();
        while (e.hasMoreElements()) {
            Object g = e.nextElement();
            if (!(g instanceof VText)) continue;
            ((VText)g).invalidate();
        }
        this.repaintNow();
    }

    public VirtualSpaceManager() {
        if (debug) {
            System.out.println("Debug mode ON");
        }
        this.nextID = 1L;
        this.nextcID = 1;
        this.nextpID = 1;
        this.nextlID = 1;
        this.nextmID = 1;
        this.allGlyphs = new Hashtable();
        this.allCameras = new Hashtable();
        this.allPortals = new Hashtable();
        this.allLenses = new Hashtable();
        this.allVirtualSpaces = new Hashtable();
        this.allViews = new View[0];
        this.name2viewIndex = new Hashtable();
        this.animator = new AnimManager(this);
        this.mouseSync = true;
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 64L);
    }

    public VirtualSpaceManager(boolean applet) {
        if (debug) {
            System.out.println("Debug mode ON");
        }
        this.nextID = 1L;
        this.nextcID = 1;
        this.nextpID = 1;
        this.nextlID = 1;
        this.nextmID = 1;
        this.allGlyphs = new Hashtable();
        this.allCameras = new Hashtable();
        this.allPortals = new Hashtable();
        this.allLenses = new Hashtable();
        this.allVirtualSpaces = new Hashtable();
        this.allViews = new View[0];
        this.name2viewIndex = new Hashtable();
        this.animator = new AnimManager(this);
        this.mouseSync = true;
        if (!applet) {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 64L);
        }
    }

    public static void setDebug(boolean b) {
        debug = b;
    }

    public static boolean debugModeON() {
        return debug;
    }

    public void setRepaintPolicy(boolean b) {
        if (b != this.generalRepaintPolicy) {
            this.generalRepaintPolicy = b;
            for (int i = 0; i < this.allViews.length; ++i) {
                this.allViews[i].setRepaintPolicy(this.generalRepaintPolicy);
            }
        }
    }

    public boolean getRepaintPolicy() {
        return this.generalRepaintPolicy;
    }

    public void setDefaultMultiFills(boolean b) {
        this.defaultMultiFill = b;
    }

    public boolean getDefaultMultiFills() {
        return this.defaultMultiFill;
    }

    public void setZoomLimit(int a) {
        this.zoomFloor = a;
    }

    public int getZoomLimit() {
        return this.zoomFloor;
    }

    public void setMouseSync(boolean b) {
        this.mouseSync = b;
        this.activeView.mouse.setSync(this.mouseSync);
    }

    public void setMouseInsideGlyphColor(Color c) {
        this.setMouseInsideGlyphColor(c, false);
    }

    public void setMouseInsideGlyphColor(Color c, boolean propagate) {
        this.mouseInsideColor = c;
        if (propagate) {
            Enumeration e = this.allGlyphs.elements();
            while (e.hasMoreElements()) {
                ((Glyph)e.nextElement()).setMouseInsideHighlightColor(this.mouseInsideColor);
            }
        }
    }

    public Glyph addGlyph(Glyph g, String vs) {
        return this.addGlyph(g, vs, true);
    }

    public Glyph addGlyph(Glyph g, VirtualSpace vs) {
        return this.addGlyph(g, vs, true);
    }

    public Glyph addGlyph(Glyph g, String vs, boolean repaint) {
        if (g != null) {
            if (this.allVirtualSpaces.containsKey(vs)) {
                VirtualSpace tvs = (VirtualSpace)this.allVirtualSpaces.get(vs);
                return this.addGlyph(g, tvs, true, repaint);
            }
            System.err.println("ZVTM Error:VirtualSpaceManager:addGlyph:unknown virtual space: " + vs);
            return null;
        }
        System.err.println("ZVTM Error:VirtualSpaceManager:addGlyph:attempting to add a null Glyph in space: " + vs);
        return null;
    }

    public Glyph addGlyph(Glyph g, VirtualSpace vs, boolean repaint) {
        return this.addGlyph(g, vs, true, repaint);
    }

    public Glyph addGlyph(Glyph g, VirtualSpace vs, boolean initColors, boolean repaint) {
        if (g != null && vs != null) {
            vs.addGlyph(g);
            g.setID(new Long(this.nextID++));
            g.setVSM(this);
            if (initColors) {
                g.setMouseInsideHighlightColor(this.mouseInsideColor);
            }
            this.allGlyphs.put(g.getID(), g);
            if (repaint) {
                this.repaintNow();
            }
            return g;
        }
        System.err.println("ZVTM Error:VirtualSpaceManager:addGlyph:attempting to add a null Glyph in space: " + vs);
        return null;
    }

    public void addGlyphs(Glyph[] gs, VirtualSpace vs, boolean repaint) {
        for (int i = 0; i < gs.length; ++i) {
            this.addGlyph(gs[i], vs, false);
        }
        this.repaintNow();
    }

    public CGlyph addCGlyph(CGlyph c, String vs) {
        if (c != null) {
            if (this.allVirtualSpaces.containsKey(vs)) {
                c.setID(new Long(this.nextID++));
                c.setVSM(this);
                this.allGlyphs.put(c.getID(), c);
                return c;
            }
            System.err.println("Error:VirtualSpaceManager:addCGlyph:unknown virtual space: " + vs);
            return null;
        }
        System.err.println("Error:VirtualSpaceManager:addCGlyph:attempting to add a null composite glyph in space: " + vs);
        return null;
    }

    public Glyph getGlyph(Long id) {
        return (Glyph)this.allGlyphs.get(id);
    }

    public Enumeration getAllGlyphs() {
        return this.allGlyphs.elements();
    }

    public void destroyGlyphsInSpace(String spaceName) {
        this.removeGlyphsFromSpace(spaceName);
    }

    public void removeGlyphsFromSpace(String spaceName) {
        VirtualSpace vs = this.getVirtualSpace(spaceName);
        Vector entClone = (Vector)vs.getAllGlyphs().clone();
        for (int i = 0; i < entClone.size(); ++i) {
            Glyph g = (Glyph)entClone.elementAt(i);
            vs.removeGlyph(g, false);
            this.allGlyphs.remove(g);
        }
        this.repaintNow();
    }

    public Camera addCamera(String vs) {
        return this.addCamera((VirtualSpace)this.allVirtualSpaces.get(vs));
    }

    public Camera addCamera(VirtualSpace vs) {
        Camera c = vs.createCamera();
        c.setID(new Integer(this.nextcID++));
        this.allCameras.put(c.getID(), c);
        return c;
    }

    public Camera addCamera(String vs, boolean lazy) {
        return this.addCamera((VirtualSpace)this.allVirtualSpaces.get(vs), lazy);
    }

    public Camera addCamera(VirtualSpace vs, boolean lazy) {
        Camera c = vs.createCamera();
        c.setLaziness(lazy);
        c.setID(new Integer(this.nextcID++));
        this.allCameras.put(c.getID(), c);
        return c;
    }

    public Camera getCamera(Integer id) {
        return (Camera)this.allCameras.get(id);
    }

    public Camera getActiveCamera() {
        return this.activeView != null ? this.activeView.getActiveCamera() : null;
    }

    public Portal addPortal(Portal p, View v) {
        p.setID(new Integer(this.nextpID++));
        this.allPortals.put(p.getID(), p);
        return v.addPortal(p);
    }

    public void destroyPortal(Portal p) {
        View v = p.getOwningView();
        v.removePortal(p);
        this.allPortals.remove(p.getID());
    }

    public Portal getPortal(Integer id) {
        return (Portal)this.allPortals.get(id);
    }

    public Lens getLens(Integer id) {
        try {
            return (Lens)((Vector)this.allLenses.get(id)).elementAt(0);
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public View getOwningView(Integer id) {
        try {
            return (View)((Vector)this.allLenses.get(id)).elementAt(1);
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public View addExternalView(Vector c, String name, short viewType, int w, int h, boolean bar, boolean visible) {
        return this.addExternalView(c, name, viewType, w, h, bar, visible, null);
    }

    public View addExternalView(Vector c, String name, short viewType, int w, int h, boolean bar, boolean visible, JMenuBar mnb) {
        return this.addExternalView(c, name, viewType, w, h, bar, visible, true, mnb);
    }

    public View addExternalView(Vector c, String name, short viewType, int w, int h, boolean bar, boolean visible, boolean decorated, JMenuBar mnb) {
        View v = null;
        switch (viewType) {
            case 0: {
                v = mnb != null ? new EView(c, name, w, h, bar, visible, decorated, this, mnb) : new EView(c, name, w, h, bar, visible, decorated, this);
                v.mouse.setID(new Long(this.nextmID++));
                this.addView(v);
                v.setRepaintPolicy(this.generalRepaintPolicy);
                if (this.animator.started) break;
                this.animator.start();
                break;
            }
            case 2: {
                v = mnb != null ? new GLEView(c, name, w, h, bar, visible, this, mnb) : new GLEView(c, name, w, h, bar, visible, this);
                v.mouse.setID(new Long(this.nextmID++));
                this.addView(v);
                v.setRepaintPolicy(this.generalRepaintPolicy);
                if (this.animator.started) break;
                this.animator.start();
                break;
            }
            case 1: {
                v = mnb != null ? new AccEView(c, name, w, h, bar, visible, this, mnb) : new AccEView(c, name, w, h, bar, visible, this);
                v.mouse.setID(new Long(this.nextmID++));
                this.addView(v);
                v.setRepaintPolicy(this.generalRepaintPolicy);
                if (this.animator.started) break;
                this.animator.start();
            }
        }
        return v;
    }

    public IView addInternalView(Vector c, String name, int w, int h, boolean bar, boolean visible, IViewContainer ivc, Integer layer) {
        return this.addInternalView(c, name, w, h, bar, visible, null, ivc, layer);
    }

    public AccIView addInternalAccView(Vector c, String name, int w, int h, boolean bar, boolean visible, IViewContainer ivc, Integer layer) {
        return this.addInternalAccView(c, name, w, h, bar, visible, null, ivc, layer);
    }

    public IView addInternalView(Vector c, String name, int w, int h, boolean bar, boolean visible, JMenuBar mnb, IViewContainer ivc, Integer layer) {
        IView tvi = mnb != null ? new IView(c, name, w, h, bar, visible, this, ivc, mnb, layer) : new IView(c, name, w, h, bar, visible, this, ivc, layer);
        tvi.mouse.setID(new Long(this.nextmID++));
        this.addView(tvi);
        tvi.setRepaintPolicy(this.generalRepaintPolicy);
        if (!this.animator.started) {
            this.animator.start();
        }
        return tvi;
    }

    public AccIView addInternalAccView(Vector c, String name, int w, int h, boolean bar, boolean visible, JMenuBar mnb, IViewContainer ivc, Integer layer) {
        AccIView tvi = mnb != null ? new AccIView(c, name, w, h, bar, visible, this, ivc, mnb, layer) : new AccIView(c, name, w, h, bar, visible, this, ivc, layer);
        tvi.mouse.setID(new Long(this.nextmID++));
        this.addView(tvi);
        tvi.setRepaintPolicy(this.generalRepaintPolicy);
        if (!this.animator.started) {
            this.animator.start();
        }
        return tvi;
    }

    public IViewContainer createIViewContainer(String name, int w, int h) {
        IViewContainer ivc = w == 0 && h == 0 ? new IViewContainer(name) : new IViewContainer(name, w, h);
        return ivc;
    }

    public JPanel addPanelView(Vector c, String name, int w, int h) {
        AppletView tvi = new AppletView(c, name, w, h, this);
        tvi.mouse.setID(new Long(this.nextmID++));
        this.addView(tvi);
        tvi.setRepaintPolicy(this.generalRepaintPolicy);
        if (!this.animator.started) {
            this.animator.start();
        }
        return tvi.panel;
    }

    protected void addView(View v) {
        View[] tmpA = new View[this.allViews.length + 1];
        System.arraycopy(this.allViews, 0, tmpA, 0, this.allViews.length);
        tmpA[this.allViews.length] = v;
        this.allViews = tmpA;
        this.name2viewIndex.put(v.name, new Integer(this.allViews.length - 1));
        this.animator.registerView();
    }

    public View addExternalView(Vector cameraList, String name, int panelWidth, int panelHeight, boolean visible, boolean decorated, short viewType, JPanel parentPanel, JFrame frame) {
        JPanelView v = new JPanelView(cameraList, name, panelWidth, panelHeight, visible, decorated, this, viewType, parentPanel, frame);
        v.mouse.setID(new Long(this.nextmID++));
        this.addView(v);
        v.setRepaintPolicy(this.generalRepaintPolicy);
        if (!this.animator.started) {
            this.animator.start();
        }
        return v;
    }

    protected int getViewIndex(String n) {
        try {
            return (Integer)this.name2viewIndex.get(n);
        }
        catch (NullPointerException ex) {
            return -1;
        }
    }

    public View getView(String n) {
        int index = this.getViewIndex(n);
        if (index != -1) {
            return this.allViews[index];
        }
        return null;
    }

    protected void destroyView(int i) {
        this.animator.unregisterView(i);
        View[] tmpA = new View[this.allViews.length - 1];
        if (tmpA.length > 0) {
            System.arraycopy(this.allViews, 0, tmpA, 0, i);
            System.arraycopy(this.allViews, i + 1, tmpA, i, this.allViews.length - i - 1);
        }
        this.allViews = tmpA;
        this.updateViewIndex();
    }

    protected void updateViewIndex() {
        this.name2viewIndex.clear();
        for (int i = 0; i < this.allViews.length; ++i) {
            this.name2viewIndex.put(this.allViews[i].name, new Integer(i));
        }
    }

    protected void destroyView(View v) {
        for (int i = 0; i < this.allViews.length; ++i) {
            if (this.allViews[i] != v) continue;
            this.destroyView(i);
            break;
        }
    }

    protected void destroyView(String viewName) {
        this.destroyView(this.getView(viewName));
    }

    public void repaintNow() {
        for (int i = 0; i < this.allViews.length; ++i) {
            this.allViews[i].repaintNow();
        }
    }

    public void repaintNow(View v) {
        v.repaintNow();
    }

    public void repaintNow(View v, RepaintListener rl) {
        v.repaintNow(rl);
    }

    protected void repaintNow(int i) {
        this.repaintNow(this.allViews[i]);
    }

    public VirtualSpace addVirtualSpace(String n) {
        VirtualSpace tvs = new VirtualSpace(n);
        tvs.setManager(this);
        this.allVirtualSpaces.put(n, tvs);
        return tvs;
    }

    public void destroyVirtualSpace(String n) {
        if (this.allVirtualSpaces.containsKey(n)) {
            VirtualSpace vs = (VirtualSpace)this.allVirtualSpaces.get(n);
            vs.destroy();
            this.allVirtualSpaces.remove(n);
        }
    }

    public VirtualSpace getOwningSpace(Glyph g) {
        Enumeration e = this.allVirtualSpaces.elements();
        while (e.hasMoreElements()) {
            VirtualSpace vs = (VirtualSpace)e.nextElement();
            if (!vs.getAllGlyphs().contains(g)) continue;
            return vs;
        }
        return null;
    }

    public VirtualSpace getVirtualSpace(String n) {
        return (VirtualSpace)this.allVirtualSpaces.get(n);
    }

    public VirtualSpace getActiveSpace() {
        return this.activeView != null ? this.activeView.getActiveCamera().getOwningSpace() : null;
    }

    public void setActiveView(View v) {
        this.activeView = v;
        this.activeViewIndex = this.getViewIndex(v.getName());
    }

    public View getActiveView() {
        return this.activeView;
    }

    public void stickToMouse(Long id) {
        this.stickToMouse(this.getGlyph(id));
    }

    public void stickToMouse(Glyph g) {
        this.activeView.mouse.stick(g);
    }

    public void unstickFromMouse() {
        this.activeView.mouse.unstick();
    }

    public void stickToGlyph(Long id1, Long id2) {
        this.stickToGlyph(this.getGlyph(id1), this.getGlyph(id2));
    }

    public void stickToGlyph(Glyph g1, Glyph g2) {
        g2.stick(g1);
    }

    public void unstickFromGlyph(Long id1, Long id2) {
        this.getGlyph(id2).unstick(this.getGlyph(id1));
    }

    public void unstickFromGlyph(Glyph g1, Glyph g2) {
        g2.unstick(g1);
    }

    public void stickToCamera(Long id1, Integer id2) {
        this.stickToCamera(this.getGlyph(id1), this.getCamera(id2));
    }

    public void stickToCamera(Glyph g, Camera c) {
        c.stick(g);
    }

    public void unstickAllGlyphs(Glyph g) {
        g.unstickAllGlyphs();
    }

    public void unstickAllGlyphs(Camera c) {
        c.unstickAllGlyphs();
    }

    public Location getGlobalView(Camera c) {
        return this.getGlobalView(c, 1.0f);
    }

    public Location getGlobalView(Camera c, float mFactor) {
        View v = null;
        try {
            v = c.getOwningView();
            if (v != null) {
                float tmpRatio;
                long[] wnes = VirtualSpaceManager.findFarmostGlyphCoords(c.parentSpace);
                long dx = (wnes[2] + wnes[0]) / 2L;
                long dy = (wnes[1] + wnes[3]) / 2L;
                long[] regBounds = v.getVisibleRegion(c);
                long[] trRegBounds = new long[]{regBounds[0] + dx - c.posx, regBounds[3] + dy - c.posy};
                float currentAlt = c.getAltitude() + c.getFocal();
                float ratio = 0.0f;
                if (trRegBounds[0] != 0L) {
                    ratio = (float)(dx - wnes[0]) / (float)(dx - trRegBounds[0]);
                }
                if (trRegBounds[1] != 0L && (tmpRatio = (float)(dy - wnes[3]) / (float)(dy - trRegBounds[1])) > ratio) {
                    ratio = tmpRatio;
                }
                return new Location(dx, dy, currentAlt * Math.abs(ratio *= mFactor) - c.getFocal());
            }
            return null;
        }
        catch (NullPointerException e) {
            System.err.println("Error:VirtualSpaceManager:getGlobalView: ");
            System.err.println("Camera c=" + c);
            System.err.println("View v=" + v);
            if (debug) {
                e.printStackTrace();
            } else {
                System.err.println(e);
            }
            return null;
        }
    }

    public Location getGlobalView(Camera c, int d) {
        return this.getGlobalView(c, d, 1.0f);
    }

    public Location getGlobalView(Camera c, int d, float mFactor) {
        Location l = this.getGlobalView(c, mFactor);
        if (l != null) {
            float dAlt = l.alt - c.getAltitude();
            Vector<Object> prms = new Vector<Object>();
            prms.add(new Float(dAlt));
            prms.add(new LongPoint(l.vx - c.posx, l.vy - c.posy));
            this.animator.createCameraAnimation(d, (short)6, prms, c.getID());
        }
        return l;
    }

    public static long[] findFarmostGlyphCoords(VirtualSpace s) {
        return VirtualSpaceManager.findFarmostGlyphCoords(s, new long[4]);
    }

    public static long[] findFarmostGlyphCoords(VirtualSpace s, long[] res) {
        if (s != null) {
            return s.findFarmostGlyphCoords(res);
        }
        return null;
    }

    public Location centerOnGlyph(Glyph g, Camera c, int d) {
        return this.centerOnGlyph(g, c, d, true);
    }

    public Location centerOnGlyph(Glyph g, Camera c, int d, boolean z) {
        return this.centerOnGlyph(g, c, d, z, 1.0f);
    }

    public Location centerOnGlyph(Glyph g, Camera c, int d, boolean z, float mFactor) {
        return this.centerOnGlyph(g, c, d, z, mFactor, null);
    }

    public Location centerOnGlyph(Glyph g, Camera c, int d, boolean z, float mFactor, PostAnimationAction paa) {
        View v = null;
        try {
            v = c.getOwningView();
            if (v != null) {
                long dy;
                long dx;
                if (g instanceof VText) {
                    VText t = (VText)g;
                    LongPoint p = t.getBounds(c.getIndex());
                    if (t.getTextAnchor() == 0) {
                        dx = g.vx + p.x / 2L - c.posx;
                        dy = g.vy + p.y / 2L - c.posy;
                    } else if (t.getTextAnchor() == 1) {
                        dx = g.vx - c.posx;
                        dy = g.vy - c.posy;
                    } else {
                        dx = g.vx - p.x / 2L - c.posx;
                        dy = g.vy - p.y / 2L - c.posy;
                    }
                } else if (g instanceof VPath) {
                    VPath p = (VPath)g;
                    dx = p.realHotSpot.x - c.posx;
                    dy = p.realHotSpot.y - c.posy;
                } else {
                    dx = g.vx - c.posx;
                    dy = g.vy - c.posy;
                }
                float currentAlt = c.getAltitude() + c.getFocal();
                if (z) {
                    float tmpRatio;
                    long[] regBounds = v.getVisibleRegion(c);
                    long[] trRegBounds = new long[]{regBounds[0] + dx, regBounds[3] + dy};
                    float ratio = 0.0f;
                    if (trRegBounds[0] != 0L) {
                        ratio = g instanceof VText ? (float)((VText)g).getBounds((int)c.getIndex()).x / (float)(g.vx - trRegBounds[0]) : (g instanceof RectangularShape ? (float)((RectangularShape)((Object)g)).getWidth() / (float)(g.vx - trRegBounds[0]) : g.getSize() / (float)(g.vx - trRegBounds[0]));
                    }
                    if (trRegBounds[1] != 0L && (tmpRatio = g instanceof VText ? (float)((VText)g).getBounds((int)c.getIndex()).y / (float)(g.vy - trRegBounds[1]) : (g instanceof RectangularShape ? (float)((RectangularShape)((Object)g)).getHeight() / (float)(g.vy - trRegBounds[1]) : g.getSize() / (float)(g.vy - trRegBounds[1]))) > ratio) {
                        ratio = tmpRatio;
                    }
                    float newAlt = currentAlt * Math.abs(ratio *= mFactor);
                    float dAlt = newAlt - currentAlt;
                    Vector<Object> prms = new Vector<Object>();
                    prms.add(new Float(dAlt));
                    prms.add(new LongPoint(dx, dy));
                    this.animator.createCameraAnimation(d, (short)6, prms, c.getID(), paa);
                    return new Location(g.vx, g.vy, newAlt);
                }
                this.animator.createCameraAnimation(d, (short)2, new LongPoint(dx, dy), c.getID(), paa);
                return new Location(g.vx, g.vy, currentAlt);
            }
            return null;
        }
        catch (NullPointerException e) {
            System.err.println("Error:VirtualSpaceManager:centerOnGlyph: ");
            System.err.println("Glyph g=" + g);
            System.err.println("Camera c=" + c);
            System.err.println("View v=" + v);
            if (debug) {
                e.printStackTrace();
            } else {
                System.err.println(e);
            }
            return null;
        }
    }

    public Location centerOnRegion(Camera c, int d, long x1, long y1, long x2, long y2) {
        View v = null;
        try {
            v = c.getOwningView();
            if (v != null) {
                float tmpRatio;
                long minX = Math.min(x1, x2);
                long minY = Math.min(y1, y2);
                long maxX = Math.max(x1, x2);
                long maxY = Math.max(y1, y2);
                long[] wnes = new long[]{minX, maxY, maxX, minY};
                long dx = (wnes[2] + wnes[0]) / 2L;
                long dy = (wnes[1] + wnes[3]) / 2L;
                long[] regBounds = v.getVisibleRegion(c);
                long[] trRegBounds = new long[]{regBounds[0] + dx - c.posx, regBounds[3] + dy - c.posy};
                float currentAlt = c.getAltitude() + c.getFocal();
                float ratio = 0.0f;
                if (trRegBounds[0] != 0L) {
                    ratio = (float)(dx - wnes[0]) / (float)(dx - trRegBounds[0]);
                }
                if (trRegBounds[1] != 0L && (tmpRatio = (float)(dy - wnes[3]) / (float)(dy - trRegBounds[1])) > ratio) {
                    ratio = tmpRatio;
                }
                float newAlt = currentAlt * Math.abs(ratio);
                float dAlt = newAlt - currentAlt;
                Vector<Object> prms = new Vector<Object>();
                prms.add(new Float(dAlt));
                prms.add(new LongPoint(dx - c.posx, dy - c.posy));
                this.animator.createCameraAnimation(d, (short)6, prms, c.getID());
                return new Location(dx, dy, newAlt);
            }
            return null;
        }
        catch (NullPointerException e) {
            System.err.println("Error:VirtualSpaceManager:centerOnRegion: ");
            System.err.println("Camera c=" + c);
            System.err.println("View v=" + v);
            if (debug) {
                e.printStackTrace();
            } else {
                System.err.println(e);
            }
            return null;
        }
    }

    public Vector getGlyphsInRegion(long x1, long y1, long x2, long y2, String vsn, int wg) {
        Vector<Glyph> res = new Vector<Glyph>();
        VirtualSpace vs = this.getVirtualSpace(vsn);
        long minX = Math.min(x1, x2);
        long minY = Math.min(y1, y2);
        long maxX = Math.max(x1, x2);
        long maxY = Math.max(y1, y2);
        if (vs != null) {
            Vector allG = vs.getAllGlyphs();
            for (int i = 0; i < allG.size(); ++i) {
                Glyph g = (Glyph)allG.elementAt(i);
                if (g.vx < minX || g.vy < minY || g.vx > maxX || g.vy > maxY) continue;
                if (wg == VIS_AND_SENS_GLYPHS && g.isSensitive() && g.isVisible()) {
                    res.add(g);
                    continue;
                }
                if (wg == VISIBLE_GLYPHS && g.isVisible()) {
                    res.add(g);
                    continue;
                }
                if (wg == SENSITIVE_GLYPHS && g.isSensitive()) {
                    res.add(g);
                    continue;
                }
                if (wg != ALL_GLYPHS) continue;
                res.add(g);
            }
        }
        if (res.isEmpty()) {
            res = null;
        }
        return res;
    }

    public void setTextDisplayedAsSegCoef(float f) {
        this.textAsLineCoef = f;
    }

    public float getTextDisplayedAsSegCoef() {
        return this.textAsLineCoef;
    }

    public void removeGlyphFromUnderMouseLists(Glyph g) {
        VirtualSpace vs = null;
        try {
            Enumeration e = this.allVirtualSpaces.elements();
            while (e.hasMoreElements() && !(vs = (VirtualSpace)e.nextElement()).getAllGlyphs().contains(g)) {
            }
            Camera[] cl = vs.getCameraListAsArray();
            for (int i = 0; i < cl.length; ++i) {
                cl[i].getOwningView().mouse.removeGlyphFromList(g);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void eventDispatched(AWTEvent e) {
        if (e.getID() == 205) {
            this.activeJFrame = e.getSource();
        }
    }
}

