/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.glyphs;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.glyphs.Glyph;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import net.claribole.zvtm.glyphs.projection.ProjCbCurve;

public class VCbCurve
extends Glyph {
    long vs;
    long vrad1;
    float ang1;
    long vrad2;
    float ang2;
    ProjCbCurve[] pc;

    public VCbCurve(long x, long y, int z, long s, Color c, float or, long ctrlDist1, float or1, long ctrlDist2, float or2) {
        this.vx = x;
        this.vy = y;
        this.vz = z;
        this.vs = s;
        this.sensit = false;
        this.orient = or;
        this.vrad1 = ctrlDist1;
        this.ang1 = or1;
        this.vrad2 = ctrlDist2;
        this.ang2 = or2;
        this.computeSize();
        this.setColor(c);
    }

    public void setCtrlPoint1(long d, float o) {
        this.vrad1 = d;
        this.ang1 = o;
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
    }

    public void setCtrlPoint2(long d, float o) {
        this.vrad2 = d;
        this.ang2 = o;
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
    }

    public long getCtrlPointRadius1() {
        return this.vrad1;
    }

    public float getCtrlPointAngle1() {
        return this.ang1;
    }

    public long getCtrlPointRadius2() {
        return this.vrad2;
    }

    public float getCtrlPointAngle2() {
        return this.ang2;
    }

    public void initCams(int nbCam) {
        this.pc = new ProjCbCurve[nbCam];
        for (int i = 0; i < nbCam; ++i) {
            this.pc[i] = new ProjCbCurve();
        }
    }

    public void addCamera(int verifIndex) {
        if (this.pc != null) {
            if (verifIndex == this.pc.length) {
                ProjCbCurve[] ta = this.pc;
                this.pc = new ProjCbCurve[ta.length + 1];
                for (int i = 0; i < ta.length; ++i) {
                    this.pc[i] = ta[i];
                }
                this.pc[this.pc.length - 1] = new ProjCbCurve();
            } else {
                System.err.println("VCbCurve:Error while adding camera " + verifIndex);
            }
        } else if (verifIndex == 0) {
            this.pc = new ProjCbCurve[1];
            this.pc[0] = new ProjCbCurve();
        } else {
            System.err.println("VCbCurve:Error while adding camera " + verifIndex);
        }
    }

    public void removeCamera(int index) {
        this.pc[index] = null;
    }

    public void resetMouseIn() {
        for (int i = 0; i < this.pc.length; ++i) {
            this.resetMouseIn(i);
        }
    }

    public void resetMouseIn(int i) {
        if (this.pc[i] != null) {
            this.pc[i].prevMouseIn = false;
        }
    }

    public float getOrient() {
        return this.orient;
    }

    public void orientTo(float angle) {
        this.orient = angle;
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public float getSize() {
        return this.size;
    }

    void computeSize() {
        this.size = this.vs;
    }

    public void sizeTo(float radius) {
        this.vrad1 = Math.round((float)this.vrad1 * radius / this.size);
        this.vrad2 = Math.round((float)this.vrad2 * radius / this.size);
        this.size = radius;
        this.vs = Math.round(this.size);
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void reSize(float factor) {
        this.size *= factor;
        this.vs = Math.round(this.size);
        this.vrad1 = Math.round((float)this.vrad1 * factor);
        this.vrad2 = Math.round((float)this.vrad2 * factor);
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public boolean fillsView(long w, long h, int camIndex) {
        return false;
    }

    public boolean coordInside(int jpx, int jpy, int camIndex, long cvx, long cvy) {
        return false;
    }

    public boolean visibleInDisc(long dvx, long dvy, long dvr, Shape dvs, int camIndex, int jpx, int jpy, int dpr) {
        return this.pc[camIndex].curve.intersects(jpx - dpr, jpy - dpr, 2 * dpr, 2 * dpr);
    }

    public short mouseInOut(int jpx, int jpy, int camIndex, long cvx, long cvy) {
        return 0;
    }

    public void project(Camera c, Dimension d) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude);
        this.pc[i].cx = d.width / 2 + Math.round((float)(this.vx - c.posx) * this.coef);
        this.pc[i].cy = d.height / 2 - Math.round((float)(this.vy - c.posy) * this.coef);
        this.pc[i].cr = Math.round((float)this.vs * this.coef);
        if (this.pc[i].cr > 1) {
            this.pc[i].start.setLocation((double)this.pc[i].cx + (double)this.pc[i].cr * Math.cos(this.orient), (double)this.pc[i].cy + (double)this.pc[i].cr * Math.sin(this.orient));
            this.pc[i].end.setLocation((double)this.pc[i].cx - (double)this.pc[i].cr * Math.cos(this.orient), (double)this.pc[i].cy - (double)this.pc[i].cr * Math.sin(this.orient));
            this.pc[i].ctrlStart.setLocation(this.pc[i].start.x + (double)((int)Math.round((double)(this.coef * (float)this.vrad1) * Math.cos(this.orient - this.ang1))), this.pc[i].start.y + (double)((int)Math.round((double)(this.coef * (float)this.vrad1) * Math.sin(this.orient - this.ang1))));
            this.pc[i].ctrlEnd.setLocation(this.pc[i].end.x + (double)((int)Math.round((double)(this.coef * (float)this.vrad2) * Math.cos(this.orient - this.ang2))), this.pc[i].end.y + (double)((int)Math.round((double)(this.coef * (float)this.vrad2) * Math.sin(this.orient - this.ang2))));
            this.pc[i].curve.setCurve(this.pc[i].start, this.pc[i].ctrlStart, this.pc[i].ctrlEnd, this.pc[i].end);
        }
    }

    public void projectForLens(Camera c, int lensWidth, int lensHeight, float lensMag, long lensx, long lensy) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude) * lensMag;
        this.pc[i].lcx = lensWidth / 2 + Math.round((float)(this.vx - lensx) * this.coef);
        this.pc[i].lcy = lensHeight / 2 - Math.round((float)(this.vy - lensy) * this.coef);
        this.pc[i].lcr = Math.round((float)this.vs * this.coef);
        if (this.pc[i].lcr > 1) {
            this.pc[i].lstart.setLocation((double)this.pc[i].lcx + (double)this.pc[i].lcr * Math.cos(this.orient), (double)this.pc[i].lcy + (double)this.pc[i].lcr * Math.sin(this.orient));
            this.pc[i].lend.setLocation((double)this.pc[i].lcx - (double)this.pc[i].lcr * Math.cos(this.orient), (double)this.pc[i].lcy - (double)this.pc[i].lcr * Math.sin(this.orient));
            this.pc[i].lctrlStart.setLocation(this.pc[i].lstart.x + (double)((int)Math.round((double)(this.coef * (float)this.vrad1) * Math.cos(this.orient - this.ang1))), this.pc[i].lstart.y + (double)((int)Math.round((double)(this.coef * (float)this.vrad1) * Math.sin(this.orient - this.ang1))));
            this.pc[i].lctrlEnd.setLocation(this.pc[i].lend.x + (double)((int)Math.round((double)(this.coef * (float)this.vrad2) * Math.cos(this.orient - this.ang2))), this.pc[i].lend.y + (double)((int)Math.round((double)(this.coef * (float)this.vrad2) * Math.sin(this.orient - this.ang2))));
            this.pc[i].lcurve.setCurve(this.pc[i].lstart, this.pc[i].lctrlStart, this.pc[i].lctrlEnd, this.pc[i].lend);
        }
    }

    public void draw(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        g.setColor(this.color);
        if (this.pc[i].cr > 1) {
            if (this.stroke != null) {
                g.setStroke(this.stroke);
                g.translate(dx, dy);
                g.draw(this.pc[i].curve);
                g.translate(-dx, -dy);
                g.setStroke(stdS);
            } else {
                g.translate(dx, dy);
                g.draw(this.pc[i].curve);
                g.translate(-dx, -dy);
            }
        } else {
            g.fillRect(dx + this.pc[i].cx, dy + this.pc[i].cy, 1, 1);
        }
    }

    public void drawForLens(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        g.setColor(this.color);
        if (this.pc[i].lcr > 1) {
            if (this.stroke != null) {
                g.setStroke(this.stroke);
                g.translate(dx, dy);
                g.draw(this.pc[i].lcurve);
                g.translate(-dx, -dy);
                g.setStroke(stdS);
            } else {
                g.translate(dx, dy);
                g.draw(this.pc[i].lcurve);
                g.translate(-dx, -dy);
            }
        } else {
            g.fillRect(dx + this.pc[i].lcx, dy + this.pc[i].lcy, 1, 1);
        }
    }

    public Object clone() {
        VCbCurve res = new VCbCurve(this.vx, this.vy, 0, this.vs, this.color, this.orient, this.vrad1, this.ang1, this.vrad2, this.ang2);
        res.mouseInsideColor = this.mouseInsideColor;
        return res;
    }

    public void highlight(boolean b, Color selectedColor) {
    }
}

