require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_POWERPC_OEA_VMPARAM_H_)) {
    eval 'sub _POWERPC_OEA_VMPARAM_H_ () {1;}' unless defined(&_POWERPC_OEA_VMPARAM_H_);
    require 'sys/queue.ph';
    eval 'sub PAGE_SHIFT () {12;}' unless defined(&PAGE_SHIFT);
    eval 'sub PAGE_SIZE () {(1<<  &PAGE_SHIFT);}' unless defined(&PAGE_SIZE);
    eval 'sub PAGE_MASK () {( &PAGE_SIZE - 1);}' unless defined(&PAGE_MASK);
    unless(defined(&USRSTACK)) {
	eval 'sub USRSTACK () { &VM_MAXUSER_ADDRESS;}' unless defined(&USRSTACK);
    }
    unless(defined(&USRSTACK32)) {
	eval 'sub USRSTACK32 () { &VM_MAXUSER_ADDRESS32;}' unless defined(&USRSTACK32);
    }
    unless(defined(&MAXTSIZ)) {
	eval 'sub MAXTSIZ () {(256*1024*1024);}' unless defined(&MAXTSIZ);
    }
    unless(defined(&MAXDSIZ)) {
	eval 'sub MAXDSIZ () {(1024*1024*1024);}' unless defined(&MAXDSIZ);
    }
    unless(defined(&MAXDSIZ32)) {
	eval 'sub MAXDSIZ32 () {(1024*1024*1024);}' unless defined(&MAXDSIZ32);
    }
    unless(defined(&MAXSSIZ)) {
	eval 'sub MAXSSIZ () {(32*1024*1024);}' unless defined(&MAXSSIZ);
    }
    unless(defined(&MAXSSIZ32)) {
	eval 'sub MAXSSIZ32 () {(32*1024*1024);}' unless defined(&MAXSSIZ32);
    }
    unless(defined(&DFLDSIZ)) {
	eval 'sub DFLDSIZ () {(256*1024*1024);}' unless defined(&DFLDSIZ);
    }
    unless(defined(&DFLDSIZ32)) {
	eval 'sub DFLSSIZ32 () {(256*1024*1024);}' unless defined(&DFLSSIZ32);
    }
    unless(defined(&DFLSSIZ)) {
	eval 'sub DFLSSIZ () {(2*1024*1024);}' unless defined(&DFLSSIZ);
    }
    unless(defined(&DFLSSIZ32)) {
	eval 'sub DFLSSIZ32 () {(2*1024*1024);}' unless defined(&DFLSSIZ32);
    }
    unless(defined(&USRIOSIZE)) {
	eval 'sub USRIOSIZE () {1024;}' unless defined(&USRIOSIZE);
    }
    unless(defined(&MAXSLP)) {
	eval 'sub MAXSLP () {20;}' unless defined(&MAXSLP);
    }
    eval 'sub SEGMENT_LENGTH () {( 0x10000000);}' unless defined(&SEGMENT_LENGTH);
    eval 'sub SEGMENT_MASK () {(~0xfffffff);}' unless defined(&SEGMENT_MASK);
    if(0) {
	eval 'sub VSID__KEYSHFT () {( &SR_VSID_WIDTH -  &SR_KEY_LEN);}' unless defined(&VSID__KEYSHFT);
	eval 'sub VSID_SR_INCREMENT () {((1 <<  &VSID__KEYSHFT) - 1);}' unless defined(&VSID_SR_INCREMENT);
	eval 'sub VSID__HASHMASK () {( &VSID_SR_INCREMENT - 1);}' unless defined(&VSID__HASHMASK);
	eval 'sub VSID_MAKE {
	    my($sr, $hash) = @_;
    	    eval q((( ((($sr) <<  &VSID__KEYSHFT) | (($hash) &  &VSID__HASMASK)));
	}' unless defined(&VSID_MAKE);
	eval 'sub VSID_TO_SR {
	    my($vsid) = @_;
    	    eval q(((($vsid) &  &SR_VSID) >> ( &SR_VSID_SHFT +  &VSID__KEYSHFT)));
	}' unless defined(&VSID_TO_SR);
	eval 'sub VSID_TO_HASH {
	    my($vsid) = @_;
    	    eval q(((($vsid) &  &SR_VSID) >>  &SR_VSID_SHFT) &  &VSID__HASHMASK));
	}' unless defined(&VSID_TO_HASH);
    } else {
	eval 'sub VSID__HASHSHFT () {( &SR_KEY_LEN);}' unless defined(&VSID__HASHSHFT);
	eval 'sub VSID_SR_INCREMENT () {(1 << 0);}' unless defined(&VSID_SR_INCREMENT);
	eval 'sub VSID__KEYMASK () {((1 <<  &VSID__HASHSHFT) - 1);}' unless defined(&VSID__KEYMASK);
	eval 'sub VSID_MAKE {
	    my($sr, $hash) = @_;
    	    eval q((( ((($hash) <<  &VSID__HASHSHFT) | (($sr) &  &VSID__KEYMASK)) <<  &SR_VSID_SHFT) &  &SR_VSID));
	}' unless defined(&VSID_MAKE);
	eval 'sub VSID_TO_SR {
	    my($vsid) = @_;
    	    eval q(((($vsid) >>  &SR_VSID_SHFT) &  &VSID__KEYMASK));
	}' unless defined(&VSID_TO_SR);
	eval 'sub VSID_TO_HASH {
	    my($vsid) = @_;
    	    eval q(((($vsid) &  &SR_VSID) >> ( &SR_VSID_SHFT +  &VSID__HASHSHFT)));
	}' unless defined(&VSID_TO_HASH);
    }
    unless(defined(&_LP64)) {
	unless(defined(&USER_SR)) {
	    eval 'sub USER_SR () {12;}' unless defined(&USER_SR);
	}
	unless(defined(&KERNEL_SR)) {
	    eval 'sub KERNEL_SR () {13;}' unless defined(&KERNEL_SR);
	}
	unless(defined(&KERNEL2_SR)) {
	    eval 'sub KERNEL2_SR () {14;}' unless defined(&KERNEL2_SR);
	}
	eval 'sub KERNEL2_SEGMENT () { &VSID_MAKE( &KERNEL2_SR,  &KERNEL_VSIDBITS);}' unless defined(&KERNEL2_SEGMENT);
    }
    eval 'sub KERNEL_VSIDBITS () {0xfffff;}' unless defined(&KERNEL_VSIDBITS);
    eval 'sub PHYSMAP_VSIDBITS () {0xffffe;}' unless defined(&PHYSMAP_VSIDBITS);
    eval 'sub PHYSMAPN_SEGMENT {
        my($s) = @_;
	    eval q( &VSID_MAKE($s,  &PHYSMAP_VSIDBITS));
    }' unless defined(&PHYSMAPN_SEGMENT);
    eval 'sub KERNEL_SEGMENT () { &VSID_MAKE( &KERNEL_SR,  &KERNEL_VSIDBITS);}' unless defined(&KERNEL_SEGMENT);
    eval 'sub KERNELN_SEGMENT {
        my($s) = @_;
	    eval q( &VSID_MAKE($s,  &KERNEL_VSIDBITS));
    }' unless defined(&KERNELN_SEGMENT);
    eval 'sub EMPTY_SEGMENT () { &VSID_MAKE(0, 0xffffe);}' unless defined(&EMPTY_SEGMENT);
    eval 'sub USER_ADDR () {(( &void *)( &USER_SR <<  &ADDR_SR_SHFT));}' unless defined(&USER_ADDR);
    unless(defined(&NPMAPS)) {
	eval 'sub NPMAPS () {32768;}' unless defined(&NPMAPS);
    }
    eval 'sub VM_MIN_ADDRESS () {(( &vaddr_t) 0);}' unless defined(&VM_MIN_ADDRESS);
    eval 'sub VM_MAXUSER_ADDRESS32 () {(( &vaddr_t) ( &uint32_t) ~0xfff);}' unless defined(&VM_MAXUSER_ADDRESS32);
    if(defined(&_LP64)) {
	eval 'sub VM_MAXUSER_ADDRESS () {(( &vaddr_t) 1 << 48);}' unless defined(&VM_MAXUSER_ADDRESS);
    } else {
	eval 'sub VM_MAXUSER_ADDRESS () { &VM_MAXUSER_ADDRESS32;}' unless defined(&VM_MAXUSER_ADDRESS);
    }
    eval 'sub VM_MAX_ADDRESS () { &VM_MAXUSER_ADDRESS;}' unless defined(&VM_MAX_ADDRESS);
    if(defined(&_LP64)) {
	eval 'sub VM_MIN_KERNEL_ADDRESS () {(( &vaddr_t) 0xffffff << 40);}' unless defined(&VM_MIN_KERNEL_ADDRESS);
	eval 'sub VM_MAX_KERNEL_ADDRESS () {(( &vaddr_t) -32768);}' unless defined(&VM_MAX_KERNEL_ADDRESS);
    } else {
	eval 'sub VM_MIN_KERNEL_ADDRESS () {(( &vaddr_t) ( &KERNEL_SR <<  &ADDR_SR_SHFT));}' unless defined(&VM_MIN_KERNEL_ADDRESS);
	eval 'sub VM_MAX_KERNEL_ADDRESS () {( &VM_MIN_KERNEL_ADDRESS + 2* &SEGMENT_LENGTH);}' unless defined(&VM_MAX_KERNEL_ADDRESS);
    }
    eval 'sub VM_PHYSSEG_STRAT () { &VM_PSTRAT_BIGFIRST;}' unless defined(&VM_PHYSSEG_STRAT);
    unless(defined(&VM_PHYS_SIZE)) {
	eval 'sub VM_PHYS_SIZE () {( &USRIOSIZE *  &PAGE_SIZE);}' unless defined(&VM_PHYS_SIZE);
    }
}
1;
