<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\DataFusion;

class PrivateServiceConnectConfig extends \Google\Model
{
  /**
   * @var string
   */
  public $effectiveUnreachableCidrBlock;
  /**
   * @var string
   */
  public $networkAttachment;
  /**
   * @var string
   */
  public $unreachableCidrBlock;

  /**
   * @param string
   */
  public function setEffectiveUnreachableCidrBlock($effectiveUnreachableCidrBlock)
  {
    $this->effectiveUnreachableCidrBlock = $effectiveUnreachableCidrBlock;
  }
  /**
   * @return string
   */
  public function getEffectiveUnreachableCidrBlock()
  {
    return $this->effectiveUnreachableCidrBlock;
  }
  /**
   * @param string
   */
  public function setNetworkAttachment($networkAttachment)
  {
    $this->networkAttachment = $networkAttachment;
  }
  /**
   * @return string
   */
  public function getNetworkAttachment()
  {
    return $this->networkAttachment;
  }
  /**
   * @param string
   */
  public function setUnreachableCidrBlock($unreachableCidrBlock)
  {
    $this->unreachableCidrBlock = $unreachableCidrBlock;
  }
  /**
   * @return string
   */
  public function getUnreachableCidrBlock()
  {
    return $this->unreachableCidrBlock;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(PrivateServiceConnectConfig::class, 'Google_Service_DataFusion_PrivateServiceConnectConfig');
