import sqlite
from pytable.pysqlite import tableactions
from pytable import dbspecifier

driver, connection = dbspecifier.DBSpecifier(
	drivername='SQLite',
	database=":memory:",
).connect()

##connection = sqlite.connect(
##	':memory:',
##)

cursor = connection.cursor()

cursor.execute("""CREATE TABLE TEST (V VARCHAR PRIMARY KEY DEFAULT 'this', I INTEGER, D TIMESTAMP, M INTEGER UNIQUE);""")
cursor.execute("""CREATE UNIQUE INDEX TEST_I ON TEST( V );""")
cursor.execute("""CREATE INDEX TEST_X ON TEST( V, I );""")
cursor.execute("""CREATE INDEX TEST_Y ON TEST( D );""")

def printResults( cursor ):
	print cursor.description
	for record in cursor.fetchall():
		print '  ',record
	

print tableactions.ListDatabases()( cursor )
for table in tableactions.ListTables()( cursor ):
	print tableactions.TableStructure()( cursor, tableName = table[1] )


def test():
	cursor.execute( "PRAGMA database_list;" )
	printResults( cursor )
	cursor.execute( """SELECT * FROM sqlite_master WHERE type = 'table'
	   UNION
	SELECT * FROM sqlite_temp_master WHERE type = 'table';""" )
	printResults( cursor )
	cursor.execute( "PRAGMA table_info(TEST);" )
	printResults( cursor )
	cursor.execute( "PRAGMA index_list(TEST);" )
	for record in cursor.fetchall():
		print repr(record)
		cursor.execute( "PRAGMA index_info(%s);"%( record[1],))
		printResults( cursor )

	cursor.execute( """SELECT * FROM sqlite_master
	   UNION
	SELECT * FROM sqlite_temp_master;""" )
	printResults( cursor )

connection.commit()
try:
	connection.close()
except:
	pass
