from django.utils.translation import gettext_lazy as _

#: List of regions, from west to east
REGION_CHOICES = (
    ('OCC', _('Occidental')),
    ('CTL', _('Central')),
    ('OTL', _('Oriental')),
)

#: Normalized versions of regions
REGION_NORMALIZED = {
    'occ': 'OCC',
    'occidente': 'OCC',
    'occidental': 'OCC',
    'ctl': 'CTL',
    'centro': 'CTL',
    'central': 'CTL',
    'otl': 'OTL',
    'oriente': 'OTL',
    'oriental': 'OTL',
}

#: List of provinces, from west to east
PROVINCE_CHOICES = (
    ('PRI', _('Pinar del Río')),
    ('ART', _('Artemisa')),
    ('MAY', _('Mayabeque')),
    ('HAB', _('La Habana')),
    ('MTZ', _('Matanzas')),
    ('CFG', _('Cienfuegos')),
    ('VCL', _('Villa Clara')),
    ('SSP', _('Sancti Spíritus')),
    ('CAV', _('Ciego de Ávila')),
    ('CMG', _('Camagüey')),
    ('LTU', _('Las Tunas')),
    ('HOL', _('Holguín')),
    ('GRA', _('Granma')),
    ('SCU', _('Santiago de Cuba')),
    ('GTM', _('Guantánamo')),
    ('IJV', _('Isla de la Juventud')),
)

#: Normalized versions of provinces
PROVINCE_NORMALIZED = {
    'pr': 'PRI',
    'pri': 'PRI',
    'pinar': 'PRI',
    'pinar del rio': 'PRI',
    'pinar del río': 'PRI',
    'ar': 'ART',
    'art': 'ART',
    'artemisa': 'ART',
    'may': 'MAY',
    'mayabeque': 'MAY',
    'h': 'HAB',
    'hab': 'HAB',
    'lha': 'HAB',
    'habana': 'HAB',
    'la habana': 'HAB',
    'ciudad de la habana': 'HAB',
    'mt': 'MTZ',
    'mtz': 'MTZ',
    'matanzas': 'MTZ',
    'cf': 'CFG',
    'cfg': 'CFG',
    'cienfuegos': 'CFG',
    'vc': 'VCL',
    'vcl': 'VCL',
    'las villas': 'VCL',
    'villa clara': 'VCL',
    'ss': 'SSP',
    'ssp': 'SSP',
    's spiritus': 'SSP',
    's. spiritus': 'SSP',
    'sancti spiritus': 'SSP',
    'sancti spíritus': 'SSP',
    'ca': 'CAV',
    'cav': 'CAV',
    'ciego': 'CAV',
    'ciego de avila': 'CAV',
    'ciego de ávila': 'CAV',
    'cmg': 'CMG',
    'camaguey': 'CMG',
    'camagüey': 'CMG',
    'lt': 'LTU',
    'ltu': 'LTU',
    'tunas': 'LTU',
    'las tunas': 'LTU',
    'hol': 'HOL',
    'holguin': 'HOL',
    'holguín': 'HOL',
    'gr': 'GRA',
    'gra': 'GRA',
    'grm': 'GRA',
    'granma': 'GRA',
    'sc': 'SCU',
    'scu': 'SCU',
    'santiago': 'SCU',
    'santiago de cuba': 'SCU',
    'GTM': 'GTM',
    'guantanamo': 'GTM',
    'guantánamo': 'GTM',
    'ij': 'IJV',
    'ijv': 'IJV',
    'la isla': 'IJV',
    'isla de la juventud': 'IJV',
    'la isla de la juventud': 'IJV',
}
