/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

public abstract class AbstractList
extends AbstractCollection
implements List {
    protected transient int modCount;

    public abstract Object get(int var1);

    public void add(int index, Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean add(Object o) {
        this.add(this.size(), o);
        return true;
    }

    public boolean addAll(int index, Collection c) {
        int size;
        Iterator itr = c.iterator();
        int pos = size = c.size();
        while (pos > 0) {
            this.add(index++, itr.next());
            --pos;
        }
        boolean bl = false;
        if (size > 0) {
            bl = true;
        }
        return bl;
    }

    public void clear() {
        this.removeRange(0, this.size());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        int size = this.size();
        if (size != ((List)o).size()) {
            return false;
        }
        Iterator itr1 = this.iterator();
        Iterator itr2 = ((List)o).iterator();
        while (--size >= 0) {
            if (AbstractList.equals(itr1.next(), itr2.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        Iterator itr = this.iterator();
        int pos = this.size();
        while (--pos >= 0) {
            hashCode = 31 * hashCode + AbstractList.hashCode(itr.next());
        }
        return hashCode;
    }

    public int indexOf(Object o) {
        ListIterator itr = this.listIterator();
        int size = this.size();
        int pos = 0;
        while (pos < size) {
            if (AbstractList.equals(o, itr.next())) {
                return pos;
            }
            ++pos;
        }
        return -1;
    }

    public Iterator iterator() {
        return new Iterator(){
            private int pos;
            private int size;
            private int last;
            private int knownMod;

            private final void checkMod() {
                if (this.knownMod != AbstractList.this.modCount) {
                    throw new ConcurrentModificationException();
                }
            }

            public final boolean hasNext() {
                this.checkMod();
                boolean bl = false;
                if (this.pos < this.size) {
                    bl = true;
                }
                return bl;
            }

            public final Object next() {
                this.checkMod();
                if (this.pos == this.size) {
                    throw new NoSuchElementException();
                }
                this.last = this.pos;
                return AbstractList.this.get(this.pos++);
            }

            public final void remove() {
                this.checkMod();
                if (this.last < 0) {
                    throw new IllegalStateException();
                }
                AbstractList.this.remove(this.last);
                --this.pos;
                --this.size;
                this.last = -1;
                this.knownMod = AbstractList.this.modCount;
            }

            private final /* synthetic */ void this() {
                this.pos = 0;
                this.size = AbstractList.this.size();
                this.last = -1;
                this.knownMod = AbstractList.this.modCount;
            }
            {
                this.this();
            }
        };
    }

    public int lastIndexOf(Object o) {
        int pos = this.size();
        ListIterator itr = this.listIterator(pos);
        while (--pos >= 0) {
            if (!AbstractList.equals(o, itr.previous())) continue;
            return pos;
        }
        return -1;
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(final int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size:" + this.size());
        }
        return new ListIterator(){
            private int knownMod;
            private int position;
            private int lastReturned;
            private int size;

            private final void checkMod() {
                if (this.knownMod != AbstractList.this.modCount) {
                    throw new ConcurrentModificationException();
                }
            }

            public final boolean hasNext() {
                this.checkMod();
                boolean bl = false;
                if (this.position < this.size) {
                    bl = true;
                }
                return bl;
            }

            public final boolean hasPrevious() {
                this.checkMod();
                boolean bl = false;
                if (this.position > 0) {
                    bl = true;
                }
                return bl;
            }

            public final Object next() {
                this.checkMod();
                if (this.position == this.size) {
                    throw new NoSuchElementException();
                }
                this.lastReturned = this.position;
                return AbstractList.this.get(this.position++);
            }

            public final Object previous() {
                this.checkMod();
                if (this.position == 0) {
                    throw new NoSuchElementException();
                }
                this.lastReturned = --this.position;
                return AbstractList.this.get(this.lastReturned);
            }

            public final int nextIndex() {
                this.checkMod();
                return this.position;
            }

            public final int previousIndex() {
                this.checkMod();
                return this.position - 1;
            }

            public final void remove() {
                this.checkMod();
                if (this.lastReturned < 0) {
                    throw new IllegalStateException();
                }
                AbstractList.this.remove(this.lastReturned);
                --this.size;
                this.position = this.lastReturned;
                this.lastReturned = -1;
                this.knownMod = AbstractList.this.modCount;
            }

            public final void set(Object o) {
                this.checkMod();
                if (this.lastReturned < 0) {
                    throw new IllegalStateException();
                }
                AbstractList.this.set(this.lastReturned, o);
            }

            public final void add(Object o) {
                this.checkMod();
                AbstractList.this.add(this.position++, o);
                ++this.size;
                this.lastReturned = -1;
                this.knownMod = AbstractList.this.modCount;
            }

            private final /* synthetic */ void this() {
                this.knownMod = AbstractList.this.modCount;
                this.position = index;
                this.lastReturned = -1;
                this.size = AbstractList.this.size();
            }
            {
                this.this();
            }
        };
    }

    public Object remove(int index) {
        throw new UnsupportedOperationException();
    }

    protected void removeRange(int fromIndex, int toIndex) {
        ListIterator itr = this.listIterator(fromIndex);
        int index = fromIndex;
        while (index < toIndex) {
            itr.next();
            itr.remove();
            ++index;
        }
    }

    public Object set(int index, Object o) {
        throw new UnsupportedOperationException();
    }

    public List subList(int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException(fromIndex + " > " + toIndex);
        }
        if (fromIndex < 0 || toIndex > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (this instanceof RandomAccess) {
            return new RandomAccessSubList(this, fromIndex, toIndex);
        }
        return new SubList(this, fromIndex, toIndex);
    }

    protected AbstractList() {
    }

    private static final class RandomAccessSubList
    extends SubList
    implements RandomAccess {
        RandomAccessSubList(AbstractList backing, int fromIndex, int toIndex) {
            super(backing, fromIndex, toIndex);
        }
    }

    private static class SubList
    extends AbstractList {
        final AbstractList backingList;
        final int offset;
        int size;

        void checkMod() {
            if (this.modCount != this.backingList.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        private final void checkBoundsInclusive(int index) {
            if (index < 0 || index > this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size:" + this.size);
            }
        }

        private final void checkBoundsExclusive(int index) {
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size:" + this.size);
            }
        }

        public int size() {
            this.checkMod();
            return this.size;
        }

        public Object set(int index, Object o) {
            this.checkMod();
            this.checkBoundsExclusive(index);
            return this.backingList.set(index + this.offset, o);
        }

        public Object get(int index) {
            this.checkMod();
            this.checkBoundsExclusive(index);
            return this.backingList.get(index + this.offset);
        }

        public void add(int index, Object o) {
            this.checkMod();
            this.checkBoundsInclusive(index);
            this.backingList.add(index + this.offset, o);
            ++this.size;
            this.modCount = this.backingList.modCount;
        }

        public Object remove(int index) {
            this.checkMod();
            this.checkBoundsExclusive(index);
            Object o = this.backingList.remove(index + this.offset);
            --this.size;
            this.modCount = this.backingList.modCount;
            return o;
        }

        protected void removeRange(int fromIndex, int toIndex) {
            this.checkMod();
            this.backingList.removeRange(this.offset + fromIndex, this.offset + toIndex);
            this.size -= toIndex - fromIndex;
            this.modCount = this.backingList.modCount;
        }

        public boolean addAll(int index, Collection c) {
            this.checkMod();
            this.checkBoundsInclusive(index);
            int csize = c.size();
            boolean result = this.backingList.addAll(this.offset + index, c);
            this.size += csize;
            this.modCount = this.backingList.modCount;
            return result;
        }

        public boolean addAll(Collection c) {
            return this.addAll(this.size, c);
        }

        public Iterator iterator() {
            return this.listIterator();
        }

        public ListIterator listIterator(final int index) {
            this.checkMod();
            this.checkBoundsInclusive(index);
            return new ListIterator(){
                private final ListIterator i;
                private int position;

                public final boolean hasNext() {
                    SubList.this.checkMod();
                    boolean bl = false;
                    if (this.position < SubList.this.size) {
                        bl = true;
                    }
                    return bl;
                }

                public final boolean hasPrevious() {
                    SubList.this.checkMod();
                    boolean bl = false;
                    if (this.position > 0) {
                        bl = true;
                    }
                    return bl;
                }

                public final Object next() {
                    if (this.position == SubList.this.size) {
                        throw new NoSuchElementException();
                    }
                    ++this.position;
                    return this.i.next();
                }

                public final Object previous() {
                    if (this.position == 0) {
                        throw new NoSuchElementException();
                    }
                    --this.position;
                    return this.i.previous();
                }

                public final int nextIndex() {
                    return this.i.nextIndex() - SubList.this.offset;
                }

                public final int previousIndex() {
                    return this.i.previousIndex() - SubList.this.offset;
                }

                public final void remove() {
                    this.i.remove();
                    --SubList.this.size;
                    this.position = this.nextIndex();
                    SubList.this.modCount = SubList.this.backingList.modCount;
                }

                public final void set(Object o) {
                    this.i.set(o);
                }

                public final void add(Object o) {
                    this.i.add(o);
                    ++SubList.this.size;
                    ++this.position;
                    SubList.this.modCount = SubList.this.backingList.modCount;
                }

                private final /* synthetic */ void this() {
                    this.i = SubList.this.backingList.listIterator(index + SubList.this.offset);
                    this.position = index;
                }
                {
                    this.this();
                }
            };
        }

        SubList(AbstractList backing, int fromIndex, int toIndex) {
            this.backingList = backing;
            this.modCount = backing.modCount;
            this.offset = fromIndex;
            this.size = toIndex - fromIndex;
        }
    }
}

