/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_PLUGIN_FUNCTION_H__
#define __SG_PLUGIN_FUNCTION_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "sg_plugin.h"

#define SG_PLUGIN_FUNCTION(obj)        GTK_CHECK_CAST (obj, sg_plugin_function_get_type (), SGpluginFunction)
#define GTK_TYPE_SG_PLUGIN_FUNCTION   (sg_plugin_function_get_type ())
  
#define SG_PLUGIN_FUNCTION_CLASS(klass) GTK_CHECK_CLASS_CAST (klass, sg_plugin_function_get_type(), SGpluginFunctionClass)
#define GTK_IS_SG_PLUGIN_FUNCTION(obj)     GTK_CHECK_TYPE (obj, sg_plugin_function_get_type ())


typedef struct _SGpluginFunction   SGpluginFunction;
typedef struct _SGpluginFunctionClass   SGpluginFunctionClass;

struct _SGpluginFunction
{
  SGplugin plugin;

  gint nparam; /*numper of parameters */
  gchar *param[10]; /* parameters */
  gchar *ivar; /* independent variable */
  gchar *function; /* function text */

  gdouble par_value[10]; /* parameter default values */ 
  gdouble ivalue; /* independent variable value */
 
  GtkPixmap *pixmap;

  gdouble        (* action)                 (SGpluginFunction *plugin,
					     gdouble *par_value,
					     gdouble ivalue,
					     gboolean *error,
					     gpointer data);
};

struct _SGpluginFunctionClass
{
  SGpluginClass parent_class;
};

GtkType         sg_plugin_function_get_type ();
SGpluginFunction *  sg_plugin_function_new  ();
gdouble         sg_plugin_function_action   (SGpluginFunction *plugin,
					     gdouble *par_value,
					     gdouble ivalue,
					     gboolean *error,
					     gpointer data);
SGpluginFunction*   sg_plugin_function_get  (const gchar *name);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __SG_PLUGIN_FUNCTION_H__ */

