/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.ByteBufferImpl;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DirectByteBufferImpl;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class ByteBuffer
extends Buffer
implements Comparable {
    ByteOrder endian;
    int array_offset;
    byte[] backing_buffer;

    public static ByteBuffer allocateDirect(int n) {
        return DirectByteBufferImpl.allocate(n);
    }

    public static ByteBuffer allocate(int n) {
        return ByteBuffer.wrap(new byte[n], 0, n);
    }

    public static final ByteBuffer wrap(byte[] byArray, int n, int n2) {
        return new ByteBufferImpl(byArray, 0, byArray.length, n + n2, n, -1, false);
    }

    public static final ByteBuffer wrap(byte[] byArray) {
        return ByteBuffer.wrap(byArray, 0, byArray.length);
    }

    public ByteBuffer get(byte[] byArray, int n, int n2) {
        ByteBuffer.checkArraySize(byArray.length, n, n2);
        this.checkForUnderflow(n2);
        int n3 = n;
        while (n3 < n + n2) {
            byArray[n3] = this.get();
            ++n3;
        }
        return this;
    }

    public ByteBuffer get(byte[] byArray) {
        return this.get(byArray, 0, byArray.length);
    }

    public ByteBuffer put(ByteBuffer byteBuffer) {
        if (byteBuffer == this) {
            throw new IllegalArgumentException();
        }
        this.checkForOverflow(byteBuffer.remaining());
        if (byteBuffer.remaining() > 0) {
            byte[] byArray = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray);
            this.put(byArray);
        }
        return this;
    }

    public ByteBuffer put(byte[] byArray, int n, int n2) {
        ByteBuffer.checkArraySize(byArray.length, n, n2);
        this.checkForOverflow(n2);
        int n3 = n;
        while (n3 < n + n2) {
            this.put(byArray[n3]);
            ++n3;
        }
        return this;
    }

    public final ByteBuffer put(byte[] byArray) {
        return this.put(byArray, 0, byArray.length);
    }

    public final boolean hasArray() {
        boolean bl = false;
        if (this.backing_buffer != null && !this.isReadOnly()) {
            bl = true;
        }
        return bl;
    }

    public final byte[] array() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        this.checkIfReadOnly();
        return this.backing_buffer;
    }

    public final int arrayOffset() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        this.checkIfReadOnly();
        return this.array_offset;
    }

    public int hashCode() {
        int n = this.get(this.position()) + 31;
        int n2 = 1;
        int n3 = this.position() + 1;
        while (n3 < this.limit()) {
            n += (this.get(n3) + 30) * (n2 *= 31);
            ++n3;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof ByteBuffer) {
            boolean bl = false;
            if (this.compareTo(object) == 0) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public int compareTo(Object object) {
        ByteBuffer byteBuffer = (ByteBuffer)object;
        int n = Math.min(this.remaining(), byteBuffer.remaining());
        int n2 = this.position();
        int n3 = byteBuffer.position();
        int n4 = 0;
        while (n4 < n) {
            byte by;
            byte by2;
            if ((by2 = this.get(n2++)) != (by = byteBuffer.get(n3++))) {
                if (by2 < by) {
                    return -1;
                }
                return 1;
            }
            ++n4;
        }
        return this.remaining() - byteBuffer.remaining();
    }

    public final ByteOrder order() {
        return this.endian;
    }

    public final ByteBuffer order(ByteOrder byteOrder) {
        this.endian = byteOrder;
        return this;
    }

    public abstract byte get();

    public abstract ByteBuffer put(byte var1);

    public abstract byte get(int var1);

    public abstract ByteBuffer put(int var1, byte var2);

    public abstract ByteBuffer compact();

    void shiftDown(int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            this.put(n + n4, this.get(n2 + n4));
            ++n4;
        }
    }

    public abstract boolean isDirect();

    public abstract ByteBuffer slice();

    public abstract ByteBuffer duplicate();

    public abstract ByteBuffer asReadOnlyBuffer();

    public abstract ShortBuffer asShortBuffer();

    public abstract CharBuffer asCharBuffer();

    public abstract IntBuffer asIntBuffer();

    public abstract LongBuffer asLongBuffer();

    public abstract FloatBuffer asFloatBuffer();

    public abstract DoubleBuffer asDoubleBuffer();

    public abstract char getChar();

    public abstract ByteBuffer putChar(char var1);

    public abstract char getChar(int var1);

    public abstract ByteBuffer putChar(int var1, char var2);

    public abstract short getShort();

    public abstract ByteBuffer putShort(short var1);

    public abstract short getShort(int var1);

    public abstract ByteBuffer putShort(int var1, short var2);

    public abstract int getInt();

    public abstract ByteBuffer putInt(int var1);

    public abstract int getInt(int var1);

    public abstract ByteBuffer putInt(int var1, int var2);

    public abstract long getLong();

    public abstract ByteBuffer putLong(long var1);

    public abstract long getLong(int var1);

    public abstract ByteBuffer putLong(int var1, long var2);

    public abstract float getFloat();

    public abstract ByteBuffer putFloat(float var1);

    public abstract float getFloat(int var1);

    public abstract ByteBuffer putFloat(int var1, float var2);

    public abstract double getDouble();

    public abstract ByteBuffer putDouble(double var1);

    public abstract double getDouble(int var1);

    public abstract ByteBuffer putDouble(int var1, double var2);

    public String toString() {
        return this.getClass().getName() + "[pos=" + this.position() + " lim=" + this.limit() + " cap=" + this.capacity() + ']';
    }

    private final /* synthetic */ void this() {
        this.endian = ByteOrder.BIG_ENDIAN;
    }

    ByteBuffer(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.this();
    }
}

