/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.ldap;

import gnu.inet.ldap.BERException;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;

public class BERDecoder {
    private byte[] buffer;
    private int offset;
    private int type;
    private int len;
    private boolean control;
    private boolean utf8;

    public int parseType() throws BERException {
        if (this.offset >= this.buffer.length) {
            return -1;
        }
        this.type = BERDecoder.byteToInt(this.buffer[this.offset++]);
        this.len = BERDecoder.byteToInt(this.buffer[this.offset++]);
        if ((this.len & 0x80) != 0) {
            int n = this.len - 128;
            if (n > 4) {
                throw new BERException("Data too long: " + n);
            }
            if (this.buffer.length - this.offset < n) {
                throw new BERException("Insufficient data");
            }
            this.len = 0;
            int n2 = 0;
            while (n2 < n) {
                this.len = (this.len << 8) + BERDecoder.byteToInt(this.buffer[this.offset++]);
                ++n2;
            }
            if (this.buffer.length - this.offset < this.len) {
                throw new BERException("Insufficient data");
            }
        }
        this.control = false;
        return this.type;
    }

    static int byteToInt(byte n) {
        int n2 = n;
        if (n2 < 0) {
            n2 += 256;
        }
        return n2;
    }

    int getLength() {
        return this.len;
    }

    public boolean available() {
        boolean bl = false;
        if (this.offset < this.buffer.length) {
            bl = true;
        }
        return bl;
    }

    public void skip() {
        this.offset += this.len;
        this.control = true;
    }

    public boolean parseBoolean() throws BERException {
        if (this.control) {
            this.parseType();
        }
        if (this.type != 1) {
            throw new BERException("Unexpected type: " + this.type);
        }
        byte by = this.buffer[this.offset++];
        this.control = true;
        boolean bl = false;
        if (by != 0) {
            bl = true;
        }
        return bl;
    }

    public int parseInt() throws BERException {
        if (this.control) {
            this.parseType();
        }
        if (this.type != 2 && this.type != 10) {
            throw new BERException("Unexpected type: " + this.type);
        }
        byte by = this.buffer[this.offset++];
        int n = by & 0x7F;
        int n2 = 1;
        while (n2 < this.len) {
            n <<= 8;
            n |= this.buffer[this.offset++] & 0xFF;
            ++n2;
        }
        if ((by & 0x80) != 0) {
            n = -n;
        }
        this.control = true;
        return n;
    }

    public String parseString() throws BERException {
        if (this.control) {
            this.parseType();
        }
        if (this.len == 0) {
            this.control = true;
            return "";
        }
        if (this.type != 12 && this.type != 4) {
            throw new BERException("Unexpected type: " + this.type);
        }
        String string = this.type == 12 ? "UTF-8" : "ISO-8859-1";
        try {
            String string2 = new String(this.buffer, this.offset, this.len, string);
            this.offset += this.len;
            this.control = true;
            return string2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new BERException("JVM does not support " + string);
        }
    }

    public byte[] parseOctetString() throws BERException {
        if (this.control) {
            this.parseType();
        }
        if (this.type != 4) {
            throw new BERException("Unexpected type: " + this.type);
        }
        byte[] byArray = new byte[this.len];
        System.arraycopy(this.buffer, this.offset, byArray, 0, this.len);
        this.offset += this.len;
        this.control = true;
        return byArray;
    }

    public BERDecoder parseSequence() throws BERException {
        return this.parseSequence(16);
    }

    public BERDecoder parseSequence(int n) throws BERException {
        if (this.control) {
            this.parseType();
        }
        if (n != -1 && this.type != n) {
            throw new BERException("Unexpected type: " + this.type);
        }
        byte[] byArray = new byte[this.len];
        System.arraycopy(this.buffer, this.offset, byArray, 0, this.len);
        this.offset += this.len;
        this.control = true;
        return new BERDecoder(byArray, this.utf8);
    }

    public BERDecoder parseSet() throws BERException {
        return this.parseSet(17);
    }

    public BERDecoder parseSet(int n) throws BERException {
        return this.parseSequence(n);
    }

    public static void main(String[] stringArray) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = System.in.read();
            while (n != -1) {
                byteArrayOutputStream.write(n);
                n = System.in.read();
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            BERDecoder bERDecoder = new BERDecoder(byArray, true);
            BERDecoder.debug(bERDecoder, 0);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    private static final void debug(BERDecoder bERDecoder, int n) throws BERException {
        int n2 = bERDecoder.parseType();
        while (n2 != -1) {
            int n3 = 0;
            while (n3 < n) {
                System.out.print('\t');
                ++n3;
            }
            switch (n2) {
                case 1: {
                    System.out.println("BOOLEAN: " + bERDecoder.parseBoolean());
                    break;
                }
                case 2: {
                    System.out.println("INTEGER: " + bERDecoder.parseInt());
                    break;
                }
                case 10: {
                    System.out.println("ENUMERATED: " + bERDecoder.parseInt());
                    break;
                }
                case 4: {
                    System.out.println("OCTET-STRING: " + BERDecoder.toString(bERDecoder.parseOctetString()));
                    break;
                }
                case 12: {
                    System.out.println("STRING: \"" + bERDecoder.parseString() + '\"');
                    break;
                }
                default: {
                    System.out.println("SEQUENCE " + n2 + "(0x" + Integer.toHexString(n2) + "): " + bERDecoder.getLength());
                    BERDecoder bERDecoder2 = bERDecoder.parseSequence(n2);
                    BERDecoder.debug(bERDecoder2, n + 1);
                }
            }
            n2 = bERDecoder.parseType();
        }
    }

    private static final String toString(byte[] byArray) {
        try {
            return "\"" + new String(byArray, "UTF-8") + '\"';
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return byArray.toString();
        }
    }

    public BERDecoder(byte[] byArray, boolean bl) {
        this.buffer = byArray;
        this.offset = 0;
        this.control = true;
        this.utf8 = bl;
    }
}

