/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt;

import java.awt.Color;
import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class BitwiseXORComposite
implements Composite {
    protected Color xorColor;

    public CompositeContext createContext(ColorModel colorModel, ColorModel colorModel2, RenderingHints renderingHints) {
        if (IntContext.isSupported(colorModel, colorModel2, renderingHints)) {
            return new IntContext(colorModel, this.xorColor);
        }
        return new GeneralContext(colorModel, colorModel2, this.xorColor);
    }

    public BitwiseXORComposite(Color color) {
        this.xorColor = color;
    }

    private static class IntContext
    extends GeneralContext {
        public void compose(Raster raster, Raster raster2, WritableRaster writableRaster) {
            int n = raster.getMinX();
            int n2 = raster.getMinY();
            int n3 = raster2.getMinX();
            int n4 = raster2.getMinY();
            int n5 = writableRaster.getMinX();
            int n6 = writableRaster.getMinY();
            int n7 = Math.min(Math.min(raster.getWidth(), raster2.getWidth()), writableRaster.getWidth());
            int n8 = Math.min(Math.min(raster.getHeight(), raster2.getHeight()), writableRaster.getHeight());
            if (n7 < 1 || n8 < 1) {
                return;
            }
            int[] nArray = new int[n7];
            int[] nArray2 = new int[n7];
            this.srcColorModel.getDataElements(this.xorColor.getRGB(), nArray);
            int n9 = nArray[0];
            int n10 = 0;
            while (n10 < n8) {
                raster.getDataElements(n, n10 + n2, n7, 1, nArray);
                raster2.getDataElements(n3, n10 + n4, n7, 1, nArray2);
                int n11 = 0;
                while (n11 < n7) {
                    int n12 = n11;
                    nArray2[n12] = nArray2[n12] ^ (nArray[n11] ^ n9);
                    ++n11;
                }
                writableRaster.setDataElements(n5, n10 + n6, n7, 1, nArray2);
                ++n10;
            }
        }

        public static boolean isSupported(ColorModel colorModel, ColorModel colorModel2, RenderingHints renderingHints) {
            int n = colorModel.getTransferType();
            if (n != colorModel2.getTransferType()) {
                return false;
            }
            return n == 3;
        }

        public IntContext(ColorModel colorModel, Color color) {
            super(colorModel, colorModel, color);
        }
    }

    private static class GeneralContext
    implements CompositeContext {
        ColorModel srcColorModel;
        ColorModel dstColorModel;
        Color xorColor;

        public void compose(Raster raster, Raster raster2, WritableRaster writableRaster) {
            Rectangle rectangle = raster.getBounds();
            Rectangle rectangle2 = raster2.getBounds();
            Rectangle rectangle3 = writableRaster.getBounds();
            int n = this.xorColor.getRGB();
            int n2 = Math.min(Math.min(rectangle.width, rectangle3.width), rectangle2.width);
            int n3 = Math.min(Math.min(rectangle.height, rectangle3.height), rectangle2.height);
            Object object = null;
            Object object2 = null;
            Object var12_12 = null;
            int n4 = 0;
            while (n4 < n3) {
                int n5 = 0;
                while (n5 < n2) {
                    object = raster.getDataElements(n5 + rectangle.x, n4 + rectangle.y, object);
                    object2 = raster2.getDataElements(n5 + rectangle2.x, n4 + rectangle2.y, object2);
                    int n6 = this.srcColorModel.getRGB(object);
                    int n7 = this.dstColorModel.getRGB(object2);
                    int n8 = n6 ^ n ^ n7;
                    writableRaster.setDataElements(n5 + rectangle3.x, n4 + rectangle3.y, this.dstColorModel.getDataElements(n8, var12_12));
                    ++n5;
                }
                ++n4;
            }
        }

        public void dispose() {
        }

        public GeneralContext(ColorModel colorModel, ColorModel colorModel2, Color color) {
            this.srcColorModel = colorModel;
            this.dstColorModel = colorModel2;
            this.xorColor = color;
        }
    }
}

