/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.server;

import gnu.java.rmi.server.ProtocolConstants;
import gnu.java.rmi.server.RMIIncomingThread;
import gnu.java.rmi.server.TripleKey;
import gnu.java.rmi.server.UnicastConnection;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RMISocketFactory;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Hashtable;
import java.util.Iterator;

public class UnicastConnectionManager
implements Runnable,
ProtocolConstants {
    private static String localhost;
    private static Hashtable servers;
    static Hashtable clients;
    static Thread scavenger;
    private static RMISocketFactory defaultSocketFactory;
    private static int ncsock;
    private static int nssock;
    private static int ncmanager;
    private static int nsmanager;
    private static final boolean debug = false;
    private static final Object GLOBAL_LOCK;
    ArrayList connections;
    private volatile Thread serverThread;
    private ServerSocket ssock;
    String serverName;
    int serverPort;
    Object serverobj;
    private RMIServerSocketFactory serverFactory;
    private RMIClientSocketFactory clientFactory;

    private static final void startScavenger() {
        scavenger = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final void run() {
                boolean bl = true;
                while (bl) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                    bl = false;
                    Iterator iterator = clients.values().iterator();
                    long l = System.currentTimeMillis();
                    try {
                        block8: while (iterator.hasNext()) {
                            UnicastConnectionManager unicastConnectionManager = (UnicastConnectionManager)iterator.next();
                            ArrayList arrayList = unicastConnectionManager.connections;
                            ArrayList arrayList2 = arrayList;
                            synchronized (arrayList2) {
                                int n = arrayList.size() - 1;
                                while (true) {
                                    if (n < 0) {
                                        continue block8;
                                    }
                                    UnicastConnection unicastConnection = (UnicastConnection)arrayList.get(n);
                                    if (UnicastConnection.isExpired(unicastConnection, l)) {
                                        arrayList.remove(n);
                                        unicastConnection.disconnect();
                                        unicastConnection = null;
                                    } else {
                                        bl = true;
                                    }
                                    --n;
                                }
                            }
                        }
                    }
                    catch (ConcurrentModificationException concurrentModificationException) {
                        bl = true;
                    }
                }
                scavenger = null;
            }
        });
        scavenger.setDaemon(true);
        scavenger.start();
    }

    public static synchronized UnicastConnectionManager getInstance(String string, int n, RMIClientSocketFactory rMIClientSocketFactory) {
        if (rMIClientSocketFactory == null) {
            rMIClientSocketFactory = defaultSocketFactory;
        }
        try {
            string = InetAddress.getByName(string).getHostAddress();
        }
        catch (Exception exception) {}
        TripleKey tripleKey = new TripleKey(string, n, rMIClientSocketFactory);
        UnicastConnectionManager unicastConnectionManager = (UnicastConnectionManager)clients.get(tripleKey);
        if (unicastConnectionManager == null) {
            unicastConnectionManager = new UnicastConnectionManager(string, n, rMIClientSocketFactory);
            clients.put(tripleKey, unicastConnectionManager);
            UnicastConnectionManager unicastConnectionManager2 = (UnicastConnectionManager)servers.get(tripleKey);
            if (unicastConnectionManager2 != null) {
                unicastConnectionManager.serverobj = unicastConnectionManager2.serverobj;
            }
        }
        return unicastConnectionManager;
    }

    public static synchronized UnicastConnectionManager getInstance(int n, RMIServerSocketFactory rMIServerSocketFactory) throws RemoteException {
        TripleKey tripleKey;
        UnicastConnectionManager unicastConnectionManager;
        if (rMIServerSocketFactory == null) {
            rMIServerSocketFactory = defaultSocketFactory;
        }
        if ((unicastConnectionManager = (UnicastConnectionManager)servers.get(tripleKey = new TripleKey(localhost, n, rMIServerSocketFactory))) == null) {
            unicastConnectionManager = new UnicastConnectionManager(n, rMIServerSocketFactory);
            tripleKey.port = unicastConnectionManager.serverPort;
            servers.put(tripleKey, unicastConnectionManager);
        }
        return unicastConnectionManager;
    }

    public UnicastConnection getConnection() throws IOException {
        if (this.ssock == null) {
            return this.getClientConnection();
        }
        return this.getServerConnection();
    }

    private final UnicastConnection getServerConnection() throws IOException {
        Socket socket = this.ssock.accept();
        socket.setTcpNoDelay(true);
        UnicastConnection unicastConnection = new UnicastConnection(this, socket);
        unicastConnection.acceptConnection();
        return unicastConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final UnicastConnection getClientConnection() throws IOException {
        UnicastConnection unicastConnection;
        block4: {
            ArrayList arrayList = this.connections;
            ArrayList arrayList2 = arrayList;
            synchronized (arrayList2) {
                int n = arrayList.size() - 1;
                if (n < 0) break block4;
                unicastConnection = (UnicastConnection)arrayList.get(n);
                arrayList.remove(n);
                long l = System.currentTimeMillis();
                if (!UnicastConnection.isExpired(unicastConnection, l)) {
                    return unicastConnection;
                }
                unicastConnection.disconnect();
                unicastConnection = null;
            }
        }
        Socket socket = this.clientFactory.createSocket(this.serverName, this.serverPort);
        unicastConnection = new UnicastConnection(this, socket);
        unicastConnection.makeConnection(75);
        return unicastConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void discardConnection(UnicastConnection unicastConnection) {
        if (this.ssock != null) {
            unicastConnection.disconnect();
            return;
        }
        UnicastConnection.resetTime(unicastConnection);
        Object object = GLOBAL_LOCK;
        synchronized (object) {
            this.connections.add(unicastConnection);
            if (scavenger != null) return;
            UnicastConnectionManager.startScavenger();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startServer() {
        UnicastConnectionManager unicastConnectionManager = this;
        synchronized (unicastConnectionManager) {
            if (this.ssock != null && this.serverThread == null) {
                this.serverThread = new Thread(this);
                // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl6 : MonitorExitStatement: MONITOREXIT : var1_1
                this.serverThread.start();
                return;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stopServer() {
        UnicastConnectionManager unicastConnectionManager = this;
        synchronized (unicastConnectionManager) {
            if (this.serverThread != null) {
                this.serverThread = null;
                try {
                    this.ssock.close();
                }
                catch (Exception exception) {}
            }
            return;
        }
    }

    public void run() {
        while (this.serverThread != null) {
            try {
                UnicastConnection unicastConnection = this.getServerConnection();
                String string = null;
                if (unicastConnection.sock != null) {
                    string = unicastConnection.sock.getInetAddress().getHostAddress();
                }
                new RMIIncomingThread(unicastConnection, string).start();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    void write(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeUTF(this.serverName);
        objectOutput.writeInt(this.serverPort);
    }

    static UnicastConnectionManager read(ObjectInput objectInput) throws IOException {
        String string = objectInput.readUTF();
        int n = objectInput.readInt();
        return UnicastConnectionManager.getInstance(string, n, null);
    }

    static /* synthetic */ boolean access$0() {
        return false;
    }

    private UnicastConnectionManager(String string, int n, RMIClientSocketFactory rMIClientSocketFactory) {
        this.ssock = null;
        this.serverName = string;
        this.serverPort = n;
        this.serverFactory = null;
        this.clientFactory = rMIClientSocketFactory;
        this.connections = new ArrayList();
    }

    private UnicastConnectionManager(int n, RMIServerSocketFactory rMIServerSocketFactory) throws RemoteException {
        try {
            this.ssock = rMIServerSocketFactory.createServerSocket(n);
            this.serverPort = this.ssock.getLocalPort();
        }
        catch (IOException iOException) {
            this.ssock = null;
            this.serverPort = 0;
            throw new ExportException("can not create Server Socket on port " + n, iOException);
        }
        this.serverName = localhost;
        this.serverFactory = rMIServerSocketFactory;
        this.clientFactory = null;
    }

    static {
        servers = new Hashtable();
        clients = new Hashtable();
        defaultSocketFactory = RMISocketFactory.getSocketFactory();
        ncsock = 0;
        nssock = 0;
        ncmanager = 0;
        nsmanager = 0;
        GLOBAL_LOCK = new Object();
        try {
            localhost = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            localhost = "localhost";
        }
    }
}

