/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.color;

public class ToneReproductionCurve {
    private float[] trc;
    private float gamma;
    private float[] reverseTrc;

    public float lookup(float f) {
        if (this.trc == null) {
            if (f == 0.0f) {
                return 0.0f;
            }
            return (float)Math.exp((double)this.gamma * Math.log(f));
        }
        double d = f * (float)(this.trc.length - 1);
        int n = (int)Math.floor(d);
        d -= (double)n;
        if (n >= this.trc.length - 1) {
            return this.trc[this.trc.length - 1];
        }
        if (n <= 0) {
            return this.trc[0];
        }
        float f2 = (float)((double)this.trc[n] * (1.0 - d) + (double)this.trc[n + 1] * d);
        return f2;
    }

    public float reverseLookup(float f) {
        if (this.trc == null) {
            if (f == 0.0f) {
                return 0.0f;
            }
            return (float)Math.exp(1.0 / (double)this.gamma * Math.log(f));
        }
        double d = f * (float)(this.reverseTrc.length - 1);
        int n = (int)Math.floor(d);
        d -= (double)n;
        if (n >= this.reverseTrc.length - 1) {
            return this.reverseTrc[this.reverseTrc.length - 1];
        }
        if (n <= 0) {
            return this.reverseTrc[0];
        }
        float f2 = (float)((double)this.reverseTrc[n] * (1.0 - d) + (double)this.reverseTrc[n + 1] * d);
        return f2;
    }

    public void setupReverseTrc() {
        this.reverseTrc = new float[10000];
        int n = 0;
        int n2 = 0;
        while (n2 < 10000) {
            float f = (float)n2 / 10000.0f;
            while (this.trc[n + 1] < f && n < this.trc.length - 2) {
                ++n;
            }
            this.reverseTrc[n2] = n == this.trc.length - 2 ? this.trc[this.trc.length - 1] : ((float)n + (f - this.trc[n]) / (this.trc[n + 1] - this.trc[n])) / (float)this.trc.length;
            ++n2;
        }
    }

    public ToneReproductionCurve(float f) {
        this.trc = null;
        this.reverseTrc = null;
        this.gamma = f;
    }

    public ToneReproductionCurve(float[] fArray) {
        this.trc = new float[fArray.length];
        System.arraycopy(fArray, 0, this.trc, 0, fArray.length);
        this.setupReverseTrc();
    }

    public ToneReproductionCurve(short[] sArray) {
        this.trc = new float[sArray.length];
        int n = 0;
        while (n < sArray.length) {
            this.trc[n] = (float)(sArray[n] & (char)-1) / 65535.0f;
            ++n;
        }
        this.setupReverseTrc();
    }
}

